/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.session.MediaControllerCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media.AudioAttributesCompat;
import androidx.media.widget.MainHandlerExecutor;
import androidx.media.widget.MediaControlView2;
import androidx.media.widget.R;
import androidx.media.widget.RoutePlayer2;
import androidx.media.widget.SubtitleAnchorView;
import androidx.media.widget.VideoSurfaceView;
import androidx.media.widget.VideoTextureView;
import androidx.media.widget.VideoView2;
import androidx.media.widget.VideoView2Impl;
import androidx.media.widget.VideoViewInterface;
import androidx.media2.BaseMediaPlayer;
import androidx.media2.BaseRemoteMediaPlayer;
import androidx.media2.DataSourceDesc2;
import androidx.media2.MediaItem2;
import androidx.media2.MediaMetadata2;
import androidx.media2.MediaPlayer2;
import androidx.media2.MediaSession2;
import androidx.media2.SessionCommand2;
import androidx.media2.SessionCommandGroup2;
import androidx.media2.SessionToken2;
import androidx.media2.SubtitleData2;
import androidx.media2.subtitle.Cea708CaptionRenderer;
import androidx.media2.subtitle.ClosedCaptionRenderer;
import androidx.media2.subtitle.SubtitleController;
import androidx.media2.subtitle.SubtitleTrack;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import androidx.palette.graphics.Palette;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

@RequiresApi(value=28)
class VideoView2ImplBase
implements VideoView2Impl,
VideoViewInterface.SurfaceListener {
    private static final String TAG = "VideoView2ImplBase";
    static final boolean DEBUG = Log.isLoggable((String)"VideoView2ImplBase", (int)3);
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int INVALID_TRACK_INDEX = -1;
    private static final int SIZE_TYPE_EMBEDDED = 0;
    private static final int SIZE_TYPE_FULL = 1;
    private AudioAttributesCompat mAudioAttributes;
    private VideoView2.OnViewTypeChangedListener mViewTypeChangedListener;
    VideoViewInterface mCurrentView;
    private VideoTextureView mTextureView;
    private VideoSurfaceView mSurfaceView;
    MediaPlayer2 mMediaPlayer;
    MediaItem2 mMediaItem;
    private List<MediaItem2> mPlayList;
    MediaControlView2 mMediaControlView;
    MediaSession2 mMediaSession;
    private String mTitle;
    Executor mCallbackExecutor;
    private WindowManager mManager;
    View mMusicView;
    private Drawable mMusicAlbumDrawable;
    private String mMusicTitleText;
    private String mMusicArtistText;
    private boolean mIsMusicMediaType;
    private int mPrevWidth;
    private int mPrevHeight;
    int mDominantColor;
    private int mSizeType;
    int mTargetState = 0;
    int mCurrentState = 0;
    long mSeekWhenPrepared;
    int mVideoWidth;
    int mVideoHeight;
    private ArrayList<Integer> mVideoTrackIndices;
    ArrayList<Integer> mAudioTrackIndices;
    ArrayList<Pair<Integer, SubtitleTrack>> mSubtitleTrackIndices;
    private SubtitleController mSubtitleController;
    int mSelectedAudioTrackIndex;
    int mSelectedSubtitleTrackIndex;
    private SubtitleAnchorView mSubtitleAnchorView;
    private boolean mSubtitleEnabled;
    VideoView2 mInstance;
    private MediaRouter mMediaRouter;
    private MediaRouteSelector mRouteSelector;
    MediaRouter.RouteInfo mRoute;
    RoutePlayer2 mRoutePlayer;
    private final MediaRouter.Callback mRouterCallback = new MediaRouter.Callback(){

        public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
            if (route.supportsControlCategory("android.media.intent.category.REMOTE_PLAYBACK")) {
                int localPlaybackState = VideoView2ImplBase.this.mCurrentState;
                long localPlaybackPosition = VideoView2ImplBase.this.mMediaSession == null ? 0L : VideoView2ImplBase.this.mMediaSession.getCurrentPosition();
                VideoView2ImplBase.this.resetPlayer();
                VideoView2ImplBase.this.mRoute = route;
                VideoView2ImplBase.this.mRoutePlayer = new RoutePlayer2(VideoView2ImplBase.this.mInstance.getContext(), route);
                VideoView2ImplBase.this.mRoutePlayer.setDataSource(VideoView2ImplBase.this.mMediaItem.getDataSourceDesc());
                VideoView2ImplBase.this.mRoutePlayer.setCurrentPosition(localPlaybackPosition);
                if (VideoView2ImplBase.this.mMediaSession != null) {
                    VideoView2ImplBase.this.mMediaSession.updatePlayer((BaseMediaPlayer)VideoView2ImplBase.this.mRoutePlayer, VideoView2ImplBase.this.mMediaSession.getPlaylistAgent());
                } else {
                    Context context = VideoView2ImplBase.this.mInstance.getContext();
                    VideoView2ImplBase.this.mMediaSession = new MediaSession2.Builder(context).setPlayer((BaseMediaPlayer)VideoView2ImplBase.this.mRoutePlayer).setId("VideoView2_" + VideoView2ImplBase.this.mInstance.toString()).setSessionCallback(VideoView2ImplBase.this.mCallbackExecutor, (MediaSession2.SessionCallback)new MediaSessionCallback()).build();
                }
                if (localPlaybackState == 3) {
                    VideoView2ImplBase.this.mMediaSession.play();
                }
            }
        }

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route, int reason) {
            long currentPosition = 0L;
            int currentState = 0;
            if (VideoView2ImplBase.this.mRoute != null && VideoView2ImplBase.this.mRoutePlayer != null) {
                currentPosition = VideoView2ImplBase.this.mRoutePlayer.getCurrentPosition();
                currentState = VideoView2ImplBase.this.mRoutePlayer.getPlayerState();
                VideoView2ImplBase.this.mRoutePlayer.close();
                VideoView2ImplBase.this.mRoutePlayer = null;
            }
            if (VideoView2ImplBase.this.mRoute == route) {
                VideoView2ImplBase.this.mRoute = null;
            }
            if (reason != 3) {
                VideoView2ImplBase.this.openVideo();
                VideoView2ImplBase.this.mMediaSession.seekTo(currentPosition);
                if (currentState == 2) {
                    VideoView2ImplBase.this.mMediaSession.play();
                }
            }
        }
    };
    MediaPlayer2.EventCallback mMediaPlayer2Callback = new MediaPlayer2.EventCallback(){

        public void onVideoSizeChanged(MediaPlayer2 mp, DataSourceDesc2 dsd, int width, int height) {
            if (DEBUG) {
                Log.d((String)VideoView2ImplBase.TAG, (String)("onVideoSizeChanged(): size: " + width + "/" + height));
            }
            VideoView2ImplBase.this.mVideoWidth = width;
            VideoView2ImplBase.this.mVideoHeight = height;
            if (DEBUG) {
                Log.d((String)VideoView2ImplBase.TAG, (String)("onVideoSizeChanged(): mVideoSize:" + VideoView2ImplBase.this.mVideoWidth + "/" + VideoView2ImplBase.this.mVideoHeight));
            }
            if (VideoView2ImplBase.this.mVideoWidth != 0 && VideoView2ImplBase.this.mVideoHeight != 0) {
                VideoView2ImplBase.this.mInstance.requestLayout();
            }
        }

        public void onInfo(MediaPlayer2 mp, DataSourceDesc2 dsd, int what, int extra) {
            if (DEBUG) {
                Log.d((String)VideoView2ImplBase.TAG, (String)"onInfo()");
            }
            if (what == 802) {
                VideoView2ImplBase.this.extractTracks();
            } else if (what == 100) {
                this.onPrepared(mp, dsd);
            } else if (what == 5) {
                this.onCompletion(mp, dsd);
            }
        }

        public void onError(MediaPlayer2 mp, DataSourceDesc2 dsd, int frameworkErr, int implErr) {
            if (DEBUG) {
                Log.d((String)VideoView2ImplBase.TAG, (String)("Error: " + frameworkErr + "," + implErr));
            }
            VideoView2ImplBase.this.mCurrentState = -1;
            VideoView2ImplBase.this.mTargetState = -1;
            if (VideoView2ImplBase.this.mMediaControlView != null) {
                VideoView2ImplBase.this.mMediaControlView.setVisibility(8);
            }
        }

        public void onSubtitleData(MediaPlayer2 mp, DataSourceDesc2 dsd, SubtitleData2 data) {
            int index;
            if (DEBUG) {
                Log.d((String)VideoView2ImplBase.TAG, (String)("onSubtitleData(): getTrackIndex: " + data.getTrackIndex() + ", getCurrentPosition: " + mp.getCurrentPosition() + ", getStartTimeUs(): " + data.getStartTimeUs() + ", diff: " + (data.getStartTimeUs() / 1000L - mp.getCurrentPosition()) + "ms, getDurationUs(): " + data.getDurationUs()));
            }
            if ((index = data.getTrackIndex()) != VideoView2ImplBase.this.mSelectedSubtitleTrackIndex) {
                Log.w((String)VideoView2ImplBase.TAG, (String)("onSubtitleData(): getTrackIndex: " + data.getTrackIndex() + ", selected track index: " + VideoView2ImplBase.this.mSelectedSubtitleTrackIndex));
                return;
            }
            for (Pair<Integer, SubtitleTrack> p : VideoView2ImplBase.this.mSubtitleTrackIndices) {
                if ((Integer)p.first != index) continue;
                SubtitleTrack track = (SubtitleTrack)p.second;
                track.onData(data);
            }
        }

        private void onPrepared(MediaPlayer2 mp, DataSourceDesc2 dsd) {
            if (DEBUG) {
                Log.d((String)VideoView2ImplBase.TAG, (String)("OnPreparedListener(): , mCurrentState=" + VideoView2ImplBase.this.mCurrentState + ", mTargetState=" + VideoView2ImplBase.this.mTargetState));
            }
            VideoView2ImplBase.this.mCurrentState = 2;
            if (VideoView2ImplBase.this.mMediaSession != null) {
                VideoView2ImplBase.this.extractTracks();
                VideoView2ImplBase.this.extractMetadata();
                VideoView2ImplBase.this.sendMetadata();
            }
            if (VideoView2ImplBase.this.mMediaControlView != null) {
                VideoView2ImplBase.this.mMediaControlView.setEnabled(true);
            }
            int videoWidth = mp.getVideoWidth();
            int videoHeight = mp.getVideoHeight();
            long seekToPosition = VideoView2ImplBase.this.mSeekWhenPrepared;
            if (seekToPosition != 0L) {
                VideoView2ImplBase.this.mMediaSession.seekTo(seekToPosition);
            }
            if (videoWidth != 0 && videoHeight != 0) {
                if (videoWidth != VideoView2ImplBase.this.mVideoWidth || videoHeight != VideoView2ImplBase.this.mVideoHeight) {
                    VideoView2ImplBase.this.mVideoWidth = videoWidth;
                    VideoView2ImplBase.this.mVideoHeight = videoHeight;
                    VideoView2ImplBase.this.mInstance.requestLayout();
                }
                if (VideoView2ImplBase.this.needToStart()) {
                    VideoView2ImplBase.this.mMediaSession.play();
                }
            } else if (VideoView2ImplBase.this.needToStart()) {
                VideoView2ImplBase.this.mMediaSession.play();
            }
        }

        private void onCompletion(MediaPlayer2 mp, DataSourceDesc2 dsd) {
            VideoView2ImplBase.this.mCurrentState = 5;
            VideoView2ImplBase.this.mTargetState = 5;
        }
    };

    VideoView2ImplBase() {
    }

    @Override
    public void initialize(VideoView2 instance, Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        int viewType;
        boolean enableControlView;
        this.mInstance = instance;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.mSelectedSubtitleTrackIndex = -1;
        this.mAudioAttributes = new AudioAttributesCompat.Builder().setUsage(1).setContentType(3).build();
        this.mCallbackExecutor = MainHandlerExecutor.getExecutor(context);
        this.mInstance.setFocusable(true);
        this.mInstance.setFocusableInTouchMode(true);
        this.mInstance.requestFocus();
        this.mTextureView = new VideoTextureView(context);
        this.mSurfaceView = new VideoSurfaceView(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mTextureView.setLayoutParams(params);
        this.mSurfaceView.setLayoutParams(params);
        this.mTextureView.setSurfaceListener(this);
        this.mSurfaceView.setSurfaceListener(this);
        this.mInstance.addView((View)this.mTextureView);
        this.mInstance.addView((View)this.mSurfaceView);
        this.mSubtitleAnchorView = new SubtitleAnchorView(context);
        this.mSubtitleAnchorView.setLayoutParams(params);
        this.mSubtitleAnchorView.setBackgroundColor(0);
        this.mInstance.addView((View)this.mSubtitleAnchorView);
        boolean bl = enableControlView = attrs == null || attrs.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "enableControlView", true);
        if (enableControlView) {
            this.mMediaControlView = new MediaControlView2(context);
        }
        this.mSubtitleEnabled = attrs == null || attrs.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "enableSubtitle", false);
        int n = viewType = attrs == null ? 0 : attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "viewType", 0);
        if (viewType == 0) {
            Log.d((String)TAG, (String)"viewType attribute is surfaceView.");
            this.mTextureView.setVisibility(8);
            this.mSurfaceView.setVisibility(0);
            this.mCurrentView = this.mSurfaceView;
        } else if (viewType == 1) {
            Log.d((String)TAG, (String)"viewType attribute is textureView.");
            this.mTextureView.setVisibility(0);
            this.mSurfaceView.setVisibility(8);
            this.mCurrentView = this.mTextureView;
        }
        MediaRouteSelector.Builder builder = new MediaRouteSelector.Builder();
        builder.addControlCategory("android.media.intent.category.REMOTE_PLAYBACK");
        builder.addControlCategory("android.media.intent.category.LIVE_AUDIO");
        builder.addControlCategory("android.media.intent.category.LIVE_VIDEO");
        this.mRouteSelector = builder.build();
    }

    @Override
    public void setMediaControlView2(MediaControlView2 mediaControlView, long intervalMs) {
        this.mMediaControlView = mediaControlView;
        this.mMediaControlView.setShowControllerInterval(intervalMs);
        if (this.mInstance.isAttachedToWindow()) {
            this.attachMediaControlView();
        }
    }

    @Override
    public MediaControlView2 getMediaControlView2() {
        return this.mMediaControlView;
    }

    @Override
    public void setMediaMetadata(MediaMetadata2 metadata) {
        if (this.mMediaItem != null) {
            this.mMediaItem.setMetadata(metadata);
        }
    }

    @Override
    public MediaMetadata2 getMediaMetadata() {
        return this.mMediaItem != null ? this.mMediaItem.getMetadata() : null;
    }

    @Override
    public MediaControllerCompat getMediaController() {
        return null;
    }

    @Override
    public SessionToken2 getMediaSessionToken2() {
        this.checkMediaSession();
        return this.mMediaSession.getToken();
    }

    @Override
    public void setSubtitleEnabled(boolean enable) {
        if (enable != this.mSubtitleEnabled) {
            this.selectOrDeselectSubtitle(enable);
        }
        this.mSubtitleEnabled = enable;
    }

    @Override
    public boolean isSubtitleEnabled() {
        return this.mSubtitleEnabled;
    }

    @Override
    public void setSpeed(float speed) {
        if (speed <= 0.0f) {
            Log.e((String)TAG, (String)("Unsupported speed (" + speed + ") is ignored."));
            return;
        }
        this.checkMediaSession();
        this.mMediaSession.setPlaybackSpeed(speed);
    }

    @Override
    public float getSpeed() {
        this.checkMediaSession();
        return this.mMediaSession.getPlaybackSpeed();
    }

    @Override
    public void setAudioAttributes(@NonNull AudioAttributesCompat attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        this.mAudioAttributes = attributes;
    }

    @Override
    public void setVideoPath(String path) {
        this.setVideoUri(Uri.parse((String)path));
    }

    @Override
    public void setVideoUri(Uri uri) {
        this.setVideoUri(uri, null);
    }

    @Override
    public void setVideoUri(Uri uri, @Nullable Map<String, String> headers) {
        DataSourceDesc2.Builder builder = new DataSourceDesc2.Builder();
        builder.setDataSource(this.mInstance.getContext(), uri, headers, null);
        this.setDataSource(builder.build());
    }

    @Override
    public void setMediaItem2(@NonNull MediaItem2 mediaItem) {
        if (this.mPlayList != null) {
            this.mPlayList.clear();
        } else {
            this.mPlayList = new ArrayList<MediaItem2>();
        }
        this.mPlayList.add(mediaItem);
        this.mMediaItem = mediaItem;
        this.mSeekWhenPrepared = 0L;
        this.openVideo();
    }

    @Override
    public void setDataSource(@NonNull DataSourceDesc2 dataSource) {
        MediaItem2 mediaItem = new MediaItem2.Builder(2).setDataSourceDesc(dataSource).build();
        this.setMediaItem2(mediaItem);
    }

    @Override
    public void setViewType(int viewType) {
        VideoViewInterface targetView;
        if (viewType == this.mCurrentView.getViewType()) {
            return;
        }
        if (viewType == 1) {
            Log.d((String)TAG, (String)"switching to TextureView");
            targetView = this.mTextureView;
        } else if (viewType == 0) {
            Log.d((String)TAG, (String)"switching to SurfaceView");
            targetView = this.mSurfaceView;
        } else {
            throw new IllegalArgumentException("Unknown view type: " + viewType);
        }
        ((View)targetView).setVisibility(0);
        targetView.takeOver(this.mCurrentView);
        this.mInstance.requestLayout();
    }

    @Override
    public int getViewType() {
        return this.mCurrentView.getViewType();
    }

    @Override
    public void setOnViewTypeChangedListener(VideoView2.OnViewTypeChangedListener l) {
        this.mViewTypeChangedListener = l;
    }

    @Override
    public void onAttachedToWindowImpl() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = MediaPlayer2.create((Context)this.mInstance.getContext());
            this.mSurfaceView.setMediaPlayer(this.mMediaPlayer);
            this.mTextureView.setMediaPlayer(this.mMediaPlayer);
            this.mCurrentView.assignSurfaceToMediaPlayer(this.mMediaPlayer);
            if (this.mMediaSession != null) {
                this.mMediaSession.updatePlayer(this.mMediaPlayer.getBaseMediaPlayer(), this.mMediaSession.getPlaylistAgent());
            }
        } else if (!this.mCurrentView.assignSurfaceToMediaPlayer(this.mMediaPlayer)) {
            Log.w((String)TAG, (String)"failed to assign surface");
        }
        if (this.mMediaSession == null) {
            Context context = this.mInstance.getContext();
            this.mMediaSession = new MediaSession2.Builder(context).setPlayer(this.mMediaPlayer.getBaseMediaPlayer()).setId("VideoView2_" + this.mInstance.toString()).setSessionCallback(this.mCallbackExecutor, (MediaSession2.SessionCallback)new MediaSessionCallback()).build();
        }
        this.attachMediaControlView();
        this.mMediaRouter = MediaRouter.getInstance((Context)this.mInstance.getContext());
        this.mMediaRouter.setMediaSessionCompat(this.mMediaSession.getSessionCompat());
        this.mMediaRouter.addCallback(this.mRouteSelector, this.mRouterCallback, 1);
    }

    @Override
    public void onDetachedFromWindowImpl() {
        this.mMediaPlayer.close();
        this.mMediaSession.close();
        this.mMediaPlayer = null;
        this.mMediaSession = null;
    }

    @Override
    public void onTouchEventImpl(MotionEvent ev) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onTouchEvent(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState));
        }
    }

    @Override
    public void onTrackballEventImpl(MotionEvent ev) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onTrackBallEvent(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState));
        }
    }

    @Override
    public void onMeasureImpl(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIsMusicMediaType) {
            int currWidth = this.mInstance.getMeasuredWidth();
            int currHeight = this.mInstance.getMeasuredHeight();
            if (this.mPrevWidth != currWidth || this.mPrevHeight != currHeight) {
                Point screenSize = new Point();
                this.mManager.getDefaultDisplay().getSize(screenSize);
                int screenWidth = screenSize.x;
                int screenHeight = screenSize.y;
                if (currWidth == screenWidth && currHeight == screenHeight) {
                    int orientation = this.retrieveOrientation();
                    if (orientation == 0) {
                        this.inflateMusicView(R.layout.full_landscape_music);
                    } else {
                        this.inflateMusicView(R.layout.full_portrait_music);
                    }
                    if (this.mSizeType != 1) {
                        this.mSizeType = 1;
                    }
                } else if (this.mSizeType != 0) {
                    this.mSizeType = 0;
                    this.inflateMusicView(R.layout.embedded_music);
                }
                this.mPrevWidth = currWidth;
                this.mPrevHeight = currHeight;
            }
        }
    }

    @Override
    public void onSurfaceCreated(View view, int width, int height) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceCreated(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState + ", width/height: " + width + "/" + height + ", " + view.toString()));
        }
        if (this.needToStart()) {
            this.mMediaSession.play();
        }
    }

    @Override
    public void onSurfaceDestroyed(View view) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceDestroyed(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState + ", " + view.toString()));
        }
    }

    @Override
    public void onSurfaceChanged(View view, int width, int height) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceChanged(). width/height: " + width + "/" + height + ", " + view.toString()));
        }
    }

    @Override
    public void onSurfaceTakeOverDone(VideoViewInterface view) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceTakeOverDone(). Now current view is: " + view));
        }
        this.mCurrentView = view;
        if (this.mViewTypeChangedListener != null) {
            this.mViewTypeChangedListener.onViewTypeChanged((View)this.mInstance, view.getViewType());
        }
        if (this.needToStart()) {
            this.mMediaSession.play();
        }
    }

    private void checkMediaSession() {
        if (this.mMediaSession == null) {
            throw new IllegalStateException("MediaSession instance is not available.");
        }
    }

    private void attachMediaControlView() {
        this.mMediaControlView.setMediaSessionToken2(this.mMediaSession.getToken());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mInstance.addView((View)this.mMediaControlView, params);
    }

    private boolean isInPlaybackState() {
        return this.mMediaSession != null && this.mMediaSession.getPlayerState() != 3 && this.mMediaSession.getPlayerState() != 0;
    }

    boolean needToStart() {
        return (this.mMediaPlayer != null || this.mRoutePlayer != null) && this.isWaitingPlayback();
    }

    private boolean isWaitingPlayback() {
        return this.mCurrentState != 3 && this.mTargetState == 3;
    }

    void openVideo() {
        DataSourceDesc2 dsd;
        if (DEBUG) {
            Log.d((String)TAG, (String)"openVideo()");
        }
        if ((dsd = this.mMediaItem.getDataSourceDesc()) != null) {
            this.resetPlayer();
            if (this.isRemotePlayback()) {
                this.mRoutePlayer.setDataSource(dsd);
                return;
            }
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setDataSource(dsd);
            }
        }
        try {
            Context context;
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = MediaPlayer2.create((Context)this.mInstance.getContext());
            }
            this.mSurfaceView.setMediaPlayer(this.mMediaPlayer);
            this.mTextureView.setMediaPlayer(this.mMediaPlayer);
            if (!this.mCurrentView.assignSurfaceToMediaPlayer(this.mMediaPlayer)) {
                Log.w((String)TAG, (String)"failed to assign surface");
            }
            this.mMediaPlayer.setEventCallback(this.mCallbackExecutor, this.mMediaPlayer2Callback);
            this.mMediaPlayer.setAudioAttributes(this.mAudioAttributes);
            if (this.mMediaSession == null) {
                context = this.mInstance.getContext();
                this.mMediaSession = new MediaSession2.Builder(context).setPlayer(this.mMediaPlayer.getBaseMediaPlayer()).setId("VideoView2_" + this.mInstance.toString()).setSessionCallback(this.mCallbackExecutor, (MediaSession2.SessionCallback)new MediaSessionCallback()).build();
            } else {
                this.mMediaSession.updatePlayer(this.mMediaPlayer.getBaseMediaPlayer(), this.mMediaSession.getPlaylistAgent());
            }
            context = this.mInstance.getContext();
            this.mSubtitleController = new SubtitleController(context);
            this.mSubtitleController.registerRenderer((SubtitleController.Renderer)new ClosedCaptionRenderer(context));
            this.mSubtitleController.registerRenderer((SubtitleController.Renderer)new Cea708CaptionRenderer(context));
            this.mSubtitleController.setAnchor((SubtitleController.Anchor)this.mSubtitleAnchorView);
            this.mMediaSession.setPlaylist(this.mPlayList, null);
            this.mCurrentState = 1;
            this.mMediaSession.prepare();
        }
        catch (IllegalArgumentException ex) {
            Log.w((String)TAG, (String)("Unable to open content: " + this.mMediaItem), (Throwable)ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mMediaPlayer2Callback.onError(this.mMediaPlayer, dsd, 1, -1004);
        }
    }

    void resetPlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mTextureView.setMediaPlayer(null);
            this.mSurfaceView.setMediaPlayer(null);
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    boolean isRemotePlayback() {
        return this.mRoutePlayer != null && this.mMediaSession != null && this.mMediaSession.getPlayer() instanceof BaseRemoteMediaPlayer;
    }

    private void selectOrDeselectSubtitle(boolean select) {
        if (!this.isInPlaybackState()) {
            return;
        }
        if (select) {
            if (this.mSubtitleTrackIndices.size() > 0) {
                this.mSelectedSubtitleTrackIndex = (Integer)this.mSubtitleTrackIndices.get((int)0).first;
                this.mSubtitleController.selectTrack((SubtitleTrack)this.mSubtitleTrackIndices.get((int)0).second);
                this.mMediaPlayer.selectTrack(this.mSelectedSubtitleTrackIndex);
                this.mSubtitleAnchorView.setVisibility(0);
            }
        } else if (this.mSelectedSubtitleTrackIndex != -1) {
            this.mMediaPlayer.deselectTrack(this.mSelectedSubtitleTrackIndex);
            this.mSelectedSubtitleTrackIndex = -1;
            this.mSubtitleAnchorView.setVisibility(8);
        }
    }

    void extractTracks() {
        List trackInfos = this.mMediaPlayer.getTrackInfo();
        this.mVideoTrackIndices = new ArrayList();
        this.mAudioTrackIndices = new ArrayList();
        this.mSubtitleTrackIndices = new ArrayList();
        this.mSubtitleController.reset();
        for (int i = 0; i < trackInfos.size(); ++i) {
            SubtitleTrack track;
            int trackType = ((MediaPlayer2.TrackInfo)trackInfos.get(i)).getTrackType();
            if (trackType == 1) {
                this.mVideoTrackIndices.add(i);
                continue;
            }
            if (trackType == 2) {
                this.mAudioTrackIndices.add(i);
                continue;
            }
            if (trackType != 4 || (track = this.mSubtitleController.addTrack(((MediaPlayer2.TrackInfo)trackInfos.get(i)).getFormat())) == null) continue;
            this.mSubtitleTrackIndices.add((Pair<Integer, SubtitleTrack>)new Pair((Object)i, (Object)track));
        }
        if (this.mAudioTrackIndices.size() > 0) {
            this.mSelectedAudioTrackIndex = 0;
        }
        if (this.mVideoTrackIndices.size() == 0 && this.mAudioTrackIndices.size() > 0) {
            this.mIsMusicMediaType = true;
        }
        Bundle data = new Bundle();
        data.putInt("VideoTrackCount", this.mVideoTrackIndices.size());
        data.putInt("AudioTrackCount", this.mAudioTrackIndices.size());
        data.putInt("SubtitleTrackCount", this.mSubtitleTrackIndices.size());
        if (this.mSubtitleTrackIndices.size() > 0) {
            this.selectOrDeselectSubtitle(this.mSubtitleEnabled);
        }
        this.mMediaSession.sendCustomCommand(new SessionCommand2("UpdateTrackStatus", null), data);
    }

    void extractMetadata() {
        Uri uri;
        if (this.mMediaItem.getMetadata() != null) {
            return;
        }
        DataSourceDesc2 dsd = this.mMediaItem.getDataSourceDesc();
        Uri uri2 = uri = dsd != null ? dsd.getUri() : null;
        if (uri == null) {
            return;
        }
        String scheme = uri.getScheme();
        if (scheme != null) {
            if (scheme.equals("file")) {
                this.mTitle = uri.getLastPathSegment();
                this.mMediaControlView.setRouteSelector(null);
            } else if (scheme.equals("http") || scheme.equals("https")) {
                this.mTitle = uri.getPath();
                this.mMediaControlView.setRouteSelector(this.mRouteSelector);
            }
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            retriever.setDataSource(this.mInstance.getContext(), uri);
        }
        catch (IllegalArgumentException e) {
            Log.v((String)TAG, (String)"Cannot retrieve metadata for this media file.");
            retriever.release();
            return;
        }
        String title = retriever.extractMetadata(7);
        if (title != null) {
            this.mTitle = title;
        }
        if (!this.mIsMusicMediaType) {
            retriever.release();
            return;
        }
        Resources resources = this.mInstance.getResources();
        this.mManager = (WindowManager)this.mInstance.getContext().getApplicationContext().getSystemService("window");
        byte[] album = retriever.getEmbeddedPicture();
        if (album != null) {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])album, (int)0, (int)album.length);
            this.mMusicAlbumDrawable = new BitmapDrawable(bitmap);
            Palette.Builder builder = Palette.from((Bitmap)bitmap);
            builder.generate(new Palette.PaletteAsyncListener(){

                public void onGenerated(Palette palette) {
                    VideoView2ImplBase.this.mDominantColor = palette.getDominantColor(0);
                    if (VideoView2ImplBase.this.mMusicView != null) {
                        VideoView2ImplBase.this.mMusicView.setBackgroundColor(VideoView2ImplBase.this.mDominantColor);
                    }
                }
            });
        } else {
            this.mMusicAlbumDrawable = resources.getDrawable(R.drawable.ic_default_album_image);
        }
        title = retriever.extractMetadata(7);
        this.mMusicTitleText = title != null ? title : resources.getString(R.string.mcv2_music_title_unknown_text);
        String artist = retriever.extractMetadata(2);
        this.mMusicArtistText = artist != null ? artist : resources.getString(R.string.mcv2_music_artist_unknown_text);
        retriever.release();
        this.mInstance.removeView((View)this.mSurfaceView);
        this.mInstance.removeView((View)this.mTextureView);
        this.inflateMusicView(R.layout.embedded_music);
    }

    void sendMetadata() {
        MediaMetadata2.Builder builder = new MediaMetadata2.Builder();
        if (this.mIsMusicMediaType) {
            builder.putString("android.media.metadata.TITLE", this.mMusicTitleText);
            builder.putString("android.media.metadata.ARTIST", this.mMusicArtistText);
        } else {
            builder.putString("android.media.metadata.TITLE", this.mTitle);
        }
        builder.putLong("android.media.metadata.DURATION", this.mMediaSession.getDuration());
        builder.putString("android.media.metadata.MEDIA_ID", this.mMediaItem.getMediaId());
        this.mMediaItem.setMetadata(builder.build());
        this.mPlayList.set(0, this.mMediaItem);
        this.mMediaSession.setPlaylist(this.mPlayList, null);
    }

    private int retrieveOrientation() {
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        int height = dm.heightPixels;
        int width = dm.widthPixels;
        return height > width ? 1 : 0;
    }

    private void inflateMusicView(int layoutId) {
        TextView artistView;
        TextView titleView;
        this.mInstance.removeView(this.mMusicView);
        LayoutInflater inflater = (LayoutInflater)this.mInstance.getContext().getSystemService("layout_inflater");
        View v = inflater.inflate(layoutId, null);
        v.setBackgroundColor(this.mDominantColor);
        ImageView albumView = (ImageView)v.findViewById(R.id.album);
        if (albumView != null) {
            albumView.setImageDrawable(this.mMusicAlbumDrawable);
        }
        if ((titleView = (TextView)v.findViewById(R.id.title)) != null) {
            titleView.setText((CharSequence)this.mMusicTitleText);
        }
        if ((artistView = (TextView)v.findViewById(R.id.artist)) != null) {
            artistView.setText((CharSequence)this.mMusicArtistText);
        }
        this.mMusicView = v;
        this.mInstance.addView(this.mMusicView, 0);
    }

    class MediaSessionCallback
    extends MediaSession2.SessionCallback {
        MediaSessionCallback() {
        }

        public SessionCommandGroup2 onConnect(@NonNull MediaSession2 session, @NonNull MediaSession2.ControllerInfo controller) {
            SessionCommandGroup2 commands = new SessionCommandGroup2();
            commands.addCommand(2);
            commands.addCommand(1);
            commands.addCommand(3);
            commands.addCommand(6);
            commands.addCommand(7);
            commands.addCommand(8);
            commands.addCommand(9);
            commands.addCommand(10);
            commands.addCommand(11);
            commands.addCommand(23);
            commands.addCommand(26);
            commands.addCommand(38);
            commands.addCommand(new SessionCommand2("showSubtitle", null));
            commands.addCommand(new SessionCommand2("hideSubtitle", null));
            commands.addCommand(new SessionCommand2("SelectTrack", null));
            commands.addCommand(new SessionCommand2("SetPlaybackSpeed", null));
            commands.addCommand(new SessionCommand2("Mute", null));
            commands.addCommand(new SessionCommand2("Unmute", null));
            return commands;
        }

        public void onCustomCommand(@NonNull MediaSession2 session, @NonNull MediaSession2.ControllerInfo controller, @NonNull SessionCommand2 customCommand, @Nullable Bundle args, @Nullable ResultReceiver cb) {
            if (VideoView2ImplBase.this.isRemotePlayback()) {
                return;
            }
            switch (customCommand.getCustomCommand()) {
                case "showSubtitle": {
                    int subtitleTrackIndex;
                    int subtitleIndex;
                    int n = subtitleIndex = args != null ? args.getInt("SelectedSubtitleIndex", -1) : -1;
                    if (subtitleIndex == -1 || (subtitleTrackIndex = ((Integer)VideoView2ImplBase.this.mSubtitleTrackIndices.get((int)subtitleIndex).first).intValue()) == VideoView2ImplBase.this.mSelectedSubtitleTrackIndex) break;
                    VideoView2ImplBase.this.mSelectedSubtitleTrackIndex = subtitleTrackIndex;
                    VideoView2ImplBase.this.mInstance.setSubtitleEnabled(true);
                    break;
                }
                case "hideSubtitle": {
                    VideoView2ImplBase.this.mInstance.setSubtitleEnabled(false);
                    break;
                }
                case "SelectTrack": {
                    int audioTrackIndex;
                    int audioIndex;
                    int n = audioIndex = args != null ? args.getInt("SelectedAudioIndex", -1) : -1;
                    if (audioIndex == -1 || (audioTrackIndex = VideoView2ImplBase.this.mAudioTrackIndices.get(audioIndex).intValue()) == VideoView2ImplBase.this.mSelectedAudioTrackIndex) break;
                    VideoView2ImplBase.this.mSelectedAudioTrackIndex = audioTrackIndex;
                    VideoView2ImplBase.this.mMediaPlayer.selectTrack(VideoView2ImplBase.this.mSelectedAudioTrackIndex);
                }
            }
        }

        public boolean onCommandRequest(@NonNull MediaSession2 session, @NonNull MediaSession2.ControllerInfo controller, @NonNull SessionCommand2 command) {
            switch (command.getCommandCode()) {
                case 1: {
                    VideoView2ImplBase.this.mTargetState = 3;
                    if (VideoView2ImplBase.this.mCurrentView.hasAvailableSurface()) break;
                    Log.d((String)VideoView2ImplBase.TAG, (String)"surface is not available");
                    return false;
                }
                case 2: {
                    VideoView2ImplBase.this.mTargetState = 4;
                    break;
                }
                case 9: {
                    VideoView2ImplBase.this.mSeekWhenPrepared = 0L;
                }
            }
            return true;
        }

        public void onPlayerStateChanged(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, int state) {
            switch (state) {
                case 0: {
                    VideoView2ImplBase.this.mCurrentState = 0;
                    break;
                }
                case 2: {
                    VideoView2ImplBase.this.mCurrentState = 3;
                    break;
                }
                case 1: {
                    VideoView2ImplBase.this.mCurrentState = 4;
                    break;
                }
                case 3: {
                    VideoView2ImplBase.this.mCurrentState = -1;
                }
            }
        }

        public void onMediaPrepared(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, @NonNull MediaItem2 item) {
            Log.d((String)VideoView2ImplBase.TAG, (String)"onMediaPrepared() is called.");
        }
    }
}

