/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.mediarouter.media.MediaItemStatus;
import androidx.mediarouter.media.MediaRouter;
import androidx.mediarouter.media.MediaSessionStatus;
import androidx.mediarouter.media.RemotePlaybackClient;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(api=21)
public class RoutePlayer
extends MediaSession.Callback {
    public static final long PLAYBACK_ACTIONS = 334L;
    private RemotePlaybackClient mClient;
    private String mSessionId;
    private String mItemId;
    private PlayerEventCallback mCallback;
    private RemotePlaybackClient.StatusCallback mStatusCallback = new RemotePlaybackClient.StatusCallback(){

        public void onItemStatusChanged(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
            RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
            RoutePlayer.this.updateItemStatus(itemId, itemStatus);
        }
    };

    public RoutePlayer(Context context, MediaRouter.RouteInfo route) {
        this.mClient = new RemotePlaybackClient(context, route);
        this.mClient.setStatusCallback(this.mStatusCallback);
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.startSession(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
                }
            });
        }
    }

    public void onPlay() {
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.resume(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
                }
            });
        }
    }

    public void onPause() {
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.pause(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
                }
            });
        }
    }

    public void onSeekTo(long pos) {
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.seek(this.mItemId, pos, null, new RemotePlaybackClient.ItemActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
                    RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
                    RoutePlayer.this.updateItemStatus(itemId, itemStatus);
                }
            });
        }
    }

    public void onStop() {
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.stop(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
                }
            });
        }
    }

    public void setPlayerEventCallback(PlayerEventCallback callback) {
        this.mCallback = callback;
    }

    public void openVideo(Uri uri) {
        this.mClient.play(uri, "video/mp4", null, 0L, null, new RemotePlaybackClient.ItemActionCallback(){

            public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
                RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
                RoutePlayer.this.updateItemStatus(itemId, itemStatus);
            }
        });
    }

    public void release() {
        if (this.mClient != null) {
            this.mClient.release();
            this.mClient = null;
        }
        if (this.mCallback != null) {
            this.mCallback = null;
        }
    }

    private void playInternal(Uri uri) {
        this.mClient.play(uri, "video/mp4", null, 0L, null, new RemotePlaybackClient.ItemActionCallback(){

            public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
                RoutePlayer.this.updateSessionStatus(sessionId, sessionStatus);
                RoutePlayer.this.updateItemStatus(itemId, itemStatus);
            }
        });
    }

    void updateSessionStatus(String sessionId, MediaSessionStatus sessionStatus) {
        this.mSessionId = sessionId;
    }

    void updateItemStatus(String itemId, MediaItemStatus itemStatus) {
        this.mItemId = itemId;
        if (itemStatus == null || this.mCallback == null) {
            return;
        }
        this.mCallback.onPlayerStateChanged(itemStatus);
    }

    public static abstract class PlayerEventCallback {
        public void onPlayerStateChanged(MediaItemStatus itemStatus) {
        }
    }
}

