/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArrayMap;
import androidx.media.AudioAttributesCompat;
import androidx.media2.DataSourceDesc2;
import androidx.media2.MediaPlayerConnector;
import androidx.media2.UriDataSourceDesc2;
import androidx.mediarouter.media.MediaItemStatus;
import androidx.mediarouter.media.MediaRouter;
import androidx.mediarouter.media.MediaSessionStatus;
import androidx.mediarouter.media.RemotePlaybackClient;
import java.util.List;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(api=21)
public class RoutePlayer2
extends MediaPlayerConnector {
    private static final String TAG = "RoutePlayer2";
    static final boolean DEBUG = Log.isLoggable((String)"RoutePlayer2", (int)3);
    String mItemId;
    int mCurrentPlayerState;
    long mDuration;
    long mLastStatusChangedTime;
    long mPosition;
    boolean mCanResume;
    ArrayMap<MediaPlayerConnector.PlayerEventCallback, Executor> mPlayerEventCallbackMap = new ArrayMap();
    private RemotePlaybackClient mClient;
    private DataSourceDesc2 mDsd;
    private RemotePlaybackClient.StatusCallback mStatusCallback = new RemotePlaybackClient.StatusCallback(){

        public void onItemStatusChanged(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
            if (DEBUG && !RoutePlayer2.this.isSessionActive(sessionStatus)) {
                Log.v((String)RoutePlayer2.TAG, (String)"onItemStatusChanged() is called, but session is not active.");
            }
            RoutePlayer2.this.mLastStatusChangedTime = SystemClock.elapsedRealtime();
            RoutePlayer2.this.mPosition = itemStatus.getContentPosition();
            RoutePlayer2.this.mCurrentPlayerState = RoutePlayer2.this.convertPlaybackStateToPlayerState(itemStatus.getPlaybackState());
            if (RoutePlayer2.this.mPlayerEventCallbackMap.size() > 0) {
                for (MediaPlayerConnector.PlayerEventCallback callback : RoutePlayer2.this.mPlayerEventCallbackMap.keySet()) {
                    callback.onPlayerStateChanged((MediaPlayerConnector)RoutePlayer2.this, RoutePlayer2.this.mCurrentPlayerState);
                }
            }
        }
    };

    public RoutePlayer2(Context context, MediaRouter.RouteInfo route) {
        this.mClient = new RemotePlaybackClient(context, route);
        this.mClient.setStatusCallback(this.mStatusCallback);
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.startSession(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    if (DEBUG && !RoutePlayer2.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer2.TAG, (String)"RoutePlayer2 has been initialized, but session is notactive.");
                    }
                }
            });
        }
    }

    public void play() {
        if (this.mDsd == null) {
            return;
        }
        if (!this.mCanResume) {
            this.playInternal();
            return;
        }
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.resume(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    if (DEBUG && !RoutePlayer2.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer2.TAG, (String)"play() is called, but session is not active.");
                    }
                }
            });
        }
    }

    public void prepare() {
    }

    public void pause() {
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.pause(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    if (DEBUG && !RoutePlayer2.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer2.TAG, (String)"pause() is called, but session is not active.");
                    }
                    RoutePlayer2.this.mCanResume = true;
                }
            });
        }
    }

    public void reset() {
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.stop(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    if (DEBUG && !RoutePlayer2.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer2.TAG, (String)"reset() is called, but session is not active.");
                    }
                }
            });
        }
    }

    public void skipToNext() {
    }

    public void seekTo(long pos) {
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.seek(this.mItemId, pos, null, new RemotePlaybackClient.ItemActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
                    if (DEBUG && !RoutePlayer2.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer2.TAG, (String)"seekTo(long) is called, but session is not active.");
                    }
                    if (itemStatus != null && RoutePlayer2.this.mPlayerEventCallbackMap.size() > 0) {
                        for (MediaPlayerConnector.PlayerEventCallback callback : RoutePlayer2.this.mPlayerEventCallbackMap.keySet()) {
                            callback.onSeekCompleted((MediaPlayerConnector)RoutePlayer2.this, itemStatus.getContentPosition());
                        }
                    }
                }
            });
        }
    }

    public long getCurrentPosition() {
        long expectedPosition = this.mPosition;
        if (this.mCurrentPlayerState == 2) {
            expectedPosition = this.mPosition + (SystemClock.elapsedRealtime() - this.mLastStatusChangedTime);
        }
        return expectedPosition;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getBufferedPosition() {
        return 0L;
    }

    public int getPlayerState() {
        return this.mCurrentPlayerState;
    }

    public int getBufferingState() {
        return 0;
    }

    public void setAudioAttributes(AudioAttributesCompat attributes) {
    }

    public AudioAttributesCompat getAudioAttributes() {
        return null;
    }

    public void setDataSource(DataSourceDesc2 dsd) {
        this.mDsd = dsd;
    }

    public void setNextDataSource(DataSourceDesc2 dsd) {
    }

    public void setNextDataSources(List<DataSourceDesc2> dsds) {
    }

    public DataSourceDesc2 getCurrentDataSource() {
        return this.mDsd;
    }

    public void loopCurrent(boolean loop) {
    }

    public void setPlaybackSpeed(float speed) {
    }

    public float getPlaybackSpeed() {
        return 1.0f;
    }

    public void setPlayerVolume(float volume) {
    }

    public float getPlayerVolume() {
        return 0.0f;
    }

    public void registerPlayerEventCallback(Executor e, MediaPlayerConnector.PlayerEventCallback cb) {
        this.mPlayerEventCallbackMap.put((Object)cb, (Object)e);
    }

    public void unregisterPlayerEventCallback(MediaPlayerConnector.PlayerEventCallback cb) {
        this.mPlayerEventCallbackMap.remove((Object)cb);
    }

    public void close() {
        if (this.mClient != null) {
            try {
                this.mClient.release();
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)"Receiver not registered");
            }
            this.mClient = null;
        }
        this.mPlayerEventCallbackMap.clear();
    }

    void setCurrentPosition(long position) {
        this.mPosition = position;
    }

    boolean isSessionActive(MediaSessionStatus status) {
        return status != null && status.getSessionState() != 1 && status.getSessionState() != 2;
    }

    int convertPlaybackStateToPlayerState(int playbackState) {
        int playerState = 0;
        switch (playbackState) {
            case 0: 
            case 4: 
            case 5: {
                playerState = 0;
                break;
            }
            case 1: {
                playerState = 2;
                break;
            }
            case 2: 
            case 3: {
                playerState = 1;
                break;
            }
            case 6: 
            case 7: {
                playerState = 3;
            }
        }
        return playerState;
    }

    private void playInternal() {
        if (this.mDsd.getType() != 3) {
            Log.w((String)TAG, (String)("Data source type is not Uri." + this.mDsd));
            return;
        }
        this.mClient.play(((UriDataSourceDesc2)this.mDsd).getUri(), "video/mp4", null, this.mPosition, null, new RemotePlaybackClient.ItemActionCallback(){

            public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
                if (DEBUG && !RoutePlayer2.this.isSessionActive(sessionStatus)) {
                    Log.v((String)RoutePlayer2.TAG, (String)"play() is called, but session is not active.");
                }
                RoutePlayer2.this.mItemId = itemId;
                if (itemStatus != null) {
                    RoutePlayer2.this.mDuration = itemStatus.getContentDuration();
                }
            }
        });
    }
}

