/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.media.widget.VideoViewInterface;
import androidx.media2.MediaPlayer2;

@RequiresApi(value=21)
class VideoSurfaceView
extends SurfaceView
implements VideoViewInterface,
SurfaceHolder.Callback {
    private static final String TAG = "VideoSurfaceView";
    private static final boolean DEBUG = Log.isLoggable((String)"VideoSurfaceView", (int)3);
    private Surface mSurface = null;
    private VideoViewInterface.SurfaceListener mSurfaceListener = null;
    private MediaPlayer2 mMediaPlayer;
    private boolean mIsTakingOverOldView;
    private VideoViewInterface mOldView;

    VideoSurfaceView(Context context) {
        super(context, null);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    @Override
    public boolean assignSurfaceToMediaPlayer(MediaPlayer2 mp) {
        Log.d((String)TAG, (String)("assignSurfaceToMediaPlayer(): mSurface: " + this.mSurface));
        if (mp == null || !this.hasAvailableSurface()) {
            return false;
        }
        mp.setSurface(this.mSurface);
        return true;
    }

    @Override
    public void setSurfaceListener(VideoViewInterface.SurfaceListener l) {
        this.mSurfaceListener = l;
    }

    @Override
    public int getViewType() {
        return 0;
    }

    @Override
    public void setMediaPlayer(MediaPlayer2 mp) {
        this.mMediaPlayer = mp;
        if (this.mIsTakingOverOldView) {
            this.takeOver(this.mOldView);
        }
    }

    @Override
    public void takeOver(@NonNull VideoViewInterface oldView) {
        if (this.assignSurfaceToMediaPlayer(this.mMediaPlayer)) {
            ((View)oldView).setVisibility(8);
            this.mIsTakingOverOldView = false;
            this.mOldView = null;
            if (this.mSurfaceListener != null) {
                this.mSurfaceListener.onSurfaceTakeOverDone(this);
            }
        } else {
            this.mIsTakingOverOldView = true;
            this.mOldView = oldView;
        }
    }

    @Override
    public boolean hasAvailableSurface() {
        return this.mSurface != null && this.mSurface.isValid();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.d((String)TAG, (String)("surfaceCreated: mSurface: " + this.mSurface + ", new : " + holder.getSurface()));
        this.mSurface = holder.getSurface();
        if (this.mIsTakingOverOldView) {
            this.takeOver(this.mOldView);
        } else {
            this.assignSurfaceToMediaPlayer(this.mMediaPlayer);
        }
        if (this.mSurfaceListener != null) {
            Rect rect = holder.getSurfaceFrame();
            this.mSurfaceListener.onSurfaceCreated((View)this, rect.width(), rect.height());
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mSurfaceListener != null) {
            this.mSurfaceListener.onSurfaceChanged((View)this, width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mSurface = null;
        if (this.mSurfaceListener != null) {
            this.mSurfaceListener.onSurfaceDestroyed((View)this);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int videoHeight;
        int videoWidth = this.mMediaPlayer == null ? 0 : this.mMediaPlayer.getVideoWidth();
        int n = videoHeight = this.mMediaPlayer == null ? 0 : this.mMediaPlayer.getVideoHeight();
        if (DEBUG) {
            Log.d((String)TAG, (String)("onMeasure(" + View.MeasureSpec.toString((int)widthMeasureSpec) + ", " + View.MeasureSpec.toString((int)heightMeasureSpec) + ")"));
            Log.i((String)TAG, (String)(" measuredSize: " + this.getMeasuredWidth() + "/" + this.getMeasuredHeight()));
            Log.i((String)TAG, (String)(" viewSize: " + this.getWidth() + "/" + this.getHeight()));
            Log.i((String)TAG, (String)(" mVideoWidth/height: " + videoWidth + ", " + videoHeight));
        }
        int width = VideoSurfaceView.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
        int height = VideoSurfaceView.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
        if (videoWidth > 0 && videoHeight > 0) {
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            height = heightSpecSize;
            if (videoWidth * height < (width = widthSpecSize) * videoHeight) {
                width = height * videoWidth / videoHeight;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("image too wide, correcting. width: " + width));
                }
            } else if (videoWidth * height > width * videoHeight) {
                height = width * videoHeight / videoWidth;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("image too tall, correcting. height: " + height));
                }
            }
        }
        this.setMeasuredDimension(width, height);
        if (DEBUG) {
            Log.i((String)TAG, (String)"end of onMeasure()");
            Log.i((String)TAG, (String)(" measuredSize: " + this.getMeasuredWidth() + "/" + this.getMeasuredHeight()));
        }
    }
}

