/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.v4.media.session.MediaControllerCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.media.AudioAttributesCompat;
import androidx.media.widget.BaseLayout;
import androidx.media.widget.MediaControlView2;
import androidx.media.widget.VideoView2Impl;
import androidx.media.widget.VideoView2ImplApi28WithMp1;
import androidx.media.widget.VideoView2ImplBase;
import androidx.media.widget.VideoView2ImplBaseWithMp1;
import androidx.media2.DataSourceDesc2;
import androidx.media2.MediaItem2;
import androidx.media2.MediaMetadata2;
import androidx.media2.SessionToken2;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@TargetApi(value=28)
@RequiresApi(value=21)
public class VideoView2
extends BaseLayout {
    public static final int VIEW_TYPE_SURFACEVIEW = 0;
    public static final int VIEW_TYPE_TEXTUREVIEW = 1;
    private static final String TAG = "VideoView2";
    private static final boolean DEBUG = Log.isLoggable((String)"VideoView2", (int)3);
    private static final boolean USE_MP1 = Log.isLoggable((String)"VV2MP1", (int)3);
    private VideoView2Impl mImpl;

    public VideoView2(@NonNull Context context) {
        this(context, null);
    }

    public VideoView2(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoView2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (Build.VERSION.SDK_INT >= 28) {
            if (USE_MP1) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"Create VideoView2ImplApi28WithMp1");
                }
                this.mImpl = new VideoView2ImplApi28WithMp1();
            } else {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"Create VideoView2ImplBase");
                }
                this.mImpl = new VideoView2ImplBase();
            }
        } else {
            if (DEBUG) {
                Log.d((String)TAG, (String)"Create VideoView2ImplBaseWithMp1");
            }
            this.mImpl = new VideoView2ImplBaseWithMp1();
        }
        this.mImpl.initialize(this, context, attrs, defStyleAttr);
    }

    public void setMediaControlView2(MediaControlView2 mediaControlView, long intervalMs) {
        this.mImpl.setMediaControlView2(mediaControlView, intervalMs);
    }

    public MediaControlView2 getMediaControlView2() {
        return this.mImpl.getMediaControlView2();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMediaMetadata(MediaMetadata2 metadata) {
        this.mImpl.setMediaMetadata(metadata);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaMetadata2 getMediaMetadata() {
        return this.mImpl.getMediaMetadata();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaControllerCompat getMediaController() {
        return this.mImpl.getMediaController();
    }

    public SessionToken2 getMediaSessionToken2() {
        return this.mImpl.getMediaSessionToken2();
    }

    public void setSpeed(float speed) {
        this.mImpl.setSpeed(speed);
    }

    public float getSpeed() {
        return this.mImpl.getSpeed();
    }

    public void setAudioAttributes(@NonNull AudioAttributesCompat attributes) {
        this.mImpl.setAudioAttributes(attributes);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setVideoPath(String path) {
        this.mImpl.setVideoUri(Uri.parse((String)path));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setVideoUri(Uri uri) {
        this.mImpl.setVideoUri(uri, null);
    }

    public void setVideoUri(Uri uri, @Nullable Map<String, String> headers) {
        this.mImpl.setVideoUri(uri, headers);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMediaItem2(@NonNull MediaItem2 mediaItem) {
        this.mImpl.setMediaItem2(mediaItem);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setDataSource(@NonNull DataSourceDesc2 dataSource) {
        this.mImpl.setDataSource(dataSource);
    }

    public void setViewType(int viewType) {
        this.mImpl.setViewType(viewType);
    }

    public int getViewType() {
        return this.mImpl.getViewType();
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setOnViewTypeChangedListener(OnViewTypeChangedListener l) {
        this.mImpl.setOnViewTypeChangedListener(l);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mImpl.onAttachedToWindowImpl();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mImpl.onDetachedFromWindowImpl();
    }

    public CharSequence getAccessibilityClassName() {
        return VideoView2.class.getName();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mImpl.onTouchEventImpl(ev);
        return super.onTouchEvent(ev);
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        this.mImpl.onTrackballEventImpl(ev);
        return super.onTrackballEvent(ev);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mImpl.onMeasureImpl(widthMeasureSpec, heightMeasureSpec);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface OnViewTypeChangedListener {
        public void onViewTypeChanged(View var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ViewType {
    }
}

