/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.audio;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.BaseAudioProcessor;
import androidx.media3.common.audio.SonicAudioProcessor;
import androidx.media3.common.audio.SpeedProvider;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;

@UnstableApi
public final class SpeedChangingAudioProcessor
extends BaseAudioProcessor {
    private final SpeedProvider speedProvider;
    private final SonicAudioProcessor sonicAudioProcessor;
    private float currentSpeed;
    private long bytesRead;
    private boolean endOfStreamQueuedToSonic;

    public SpeedChangingAudioProcessor(SpeedProvider speedProvider) {
        this.speedProvider = speedProvider;
        this.sonicAudioProcessor = new SonicAudioProcessor();
        this.currentSpeed = 1.0f;
    }

    @Override
    @CanIgnoreReturnValue
    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        return this.sonicAudioProcessor.configure(inputAudioFormat);
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        int bytesToNextSpeedChange;
        long timeUs = Util.scaleLargeTimestamp(this.bytesRead, 1000000L, (long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame);
        float newSpeed = this.speedProvider.getSpeed(timeUs);
        if (newSpeed != this.currentSpeed) {
            this.currentSpeed = newSpeed;
            if (this.isUsingSonic()) {
                this.sonicAudioProcessor.setSpeed(newSpeed);
                this.sonicAudioProcessor.setPitch(newSpeed);
            }
            this.flush();
        }
        int inputBufferLimit = inputBuffer.limit();
        long nextSpeedChangeTimeUs = this.speedProvider.getNextSpeedChangeTimeUs(timeUs);
        if (nextSpeedChangeTimeUs != -9223372036854775807L) {
            bytesToNextSpeedChange = (int)Util.scaleLargeTimestamp(nextSpeedChangeTimeUs - timeUs, (long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame, 1000000L);
            int bytesToNextFrame = this.inputAudioFormat.bytesPerFrame - bytesToNextSpeedChange % this.inputAudioFormat.bytesPerFrame;
            if (bytesToNextFrame != this.inputAudioFormat.bytesPerFrame) {
                bytesToNextSpeedChange += bytesToNextFrame;
            }
            inputBuffer.limit(Math.min(inputBufferLimit, inputBuffer.position() + bytesToNextSpeedChange));
        } else {
            bytesToNextSpeedChange = -1;
        }
        long startPosition = inputBuffer.position();
        if (this.isUsingSonic()) {
            this.sonicAudioProcessor.queueInput(inputBuffer);
            if (bytesToNextSpeedChange != -1 && (long)inputBuffer.position() - startPosition == (long)bytesToNextSpeedChange) {
                this.sonicAudioProcessor.queueEndOfStream();
                this.endOfStreamQueuedToSonic = true;
            }
        } else {
            ByteBuffer buffer = this.replaceOutputBuffer(inputBuffer.remaining());
            if (inputBuffer.hasRemaining()) {
                buffer.put(inputBuffer);
            }
            buffer.flip();
        }
        this.bytesRead += (long)inputBuffer.position() - startPosition;
        inputBuffer.limit(inputBufferLimit);
    }

    @Override
    protected void onQueueEndOfStream() {
        if (!this.endOfStreamQueuedToSonic) {
            this.sonicAudioProcessor.queueEndOfStream();
            this.endOfStreamQueuedToSonic = true;
        }
    }

    @Override
    public ByteBuffer getOutput() {
        return this.isUsingSonic() ? this.sonicAudioProcessor.getOutput() : super.getOutput();
    }

    @Override
    public boolean isEnded() {
        return super.isEnded() && this.sonicAudioProcessor.isEnded();
    }

    @Override
    protected void onFlush() {
        this.sonicAudioProcessor.flush();
        this.endOfStreamQueuedToSonic = false;
    }

    @Override
    protected void onReset() {
        this.currentSpeed = 1.0f;
        this.bytesRead = 0L;
        this.sonicAudioProcessor.reset();
        this.endOfStreamQueuedToSonic = false;
    }

    private boolean isUsingSonic() {
        return this.currentSpeed != 1.0f;
    }
}

