/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.TimestampIterator;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class ConstantRateTimestampIterator
implements TimestampIterator {
    private final long durationUs;
    private final float frameRate;
    private final double framesDurationUs;
    private final long startingTimestampUs;
    private double currentTimestampUs;
    private int framesToAdd;

    public ConstantRateTimestampIterator(@IntRange(from=1L) long durationUs, @FloatRange(from=0.0, fromInclusive=false) float frameRate) {
        this(durationUs, frameRate, 0L);
    }

    public ConstantRateTimestampIterator(@IntRange(from=1L) long durationUs, @FloatRange(from=0.0, fromInclusive=false) float frameRate, @IntRange(from=0L) long startingTimestampUs) {
        Assertions.checkArgument(durationUs > 0L);
        Assertions.checkArgument(frameRate > 0.0f);
        Assertions.checkArgument(startingTimestampUs >= 0L);
        this.durationUs = durationUs;
        this.frameRate = frameRate;
        this.startingTimestampUs = startingTimestampUs;
        this.currentTimestampUs = startingTimestampUs;
        this.framesToAdd = Math.round(frameRate * ((float)durationUs / 1000000.0f));
        this.framesDurationUs = 1000000.0f / frameRate;
    }

    @Override
    public boolean hasNext() {
        return this.framesToAdd != 0;
    }

    @Override
    public long next() {
        Assertions.checkState(this.hasNext());
        --this.framesToAdd;
        long next = Math.round(this.currentTimestampUs);
        this.currentTimestampUs += this.framesDurationUs;
        return next;
    }

    @Override
    public ConstantRateTimestampIterator copyOf() {
        return new ConstantRateTimestampIterator(this.durationUs, this.frameRate, this.startingTimestampUs);
    }
}

