/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.net.Uri;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.text.TextUtils;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.TransferListener;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

@UnstableApi
public final class FileDataSource
extends BaseDataSource {
    @Nullable
    private RandomAccessFile file;
    @Nullable
    private Uri uri;
    private long bytesRemaining;
    private boolean opened;

    public FileDataSource() {
        super(false);
    }

    @Override
    public long open(DataSpec dataSpec) throws FileDataSourceException {
        Uri uri;
        this.uri = uri = dataSpec.uri;
        this.transferInitializing(dataSpec);
        this.file = FileDataSource.openLocalFile(uri);
        try {
            this.file.seek(dataSpec.position);
            this.bytesRemaining = dataSpec.length == -1L ? this.file.length() - dataSpec.position : dataSpec.length;
        }
        catch (IOException e) {
            throw new FileDataSourceException(e, 2000);
        }
        if (this.bytesRemaining < 0L) {
            throw new FileDataSourceException(null, null, 2008);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) throws FileDataSourceException {
        int bytesRead;
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            bytesRead = ((RandomAccessFile)Util.castNonNull((Object)this.file)).read(buffer, offset, (int)Math.min(this.bytesRemaining, (long)length));
        }
        catch (IOException e) {
            throw new FileDataSourceException(e, 2000);
        }
        if (bytesRead > 0) {
            this.bytesRemaining -= (long)bytesRead;
            this.bytesTransferred(bytesRead);
        }
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() throws FileDataSourceException {
        this.uri = null;
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            throw new FileDataSourceException(e, 2000);
        }
        finally {
            this.file = null;
            if (this.opened) {
                this.opened = false;
                this.transferEnded();
            }
        }
    }

    private static RandomAccessFile openLocalFile(Uri uri) throws FileDataSourceException {
        try {
            return new RandomAccessFile((String)Assertions.checkNotNull((Object)uri.getPath()), "r");
        }
        catch (FileNotFoundException e) {
            if (!TextUtils.isEmpty((CharSequence)uri.getQuery()) || !TextUtils.isEmpty((CharSequence)uri.getFragment())) {
                throw new FileDataSourceException(String.format("uri has query and/or fragment, which are not supported. Did you call Uri.parse() on a string containing '?' or '#'? Use Uri.fromFile(new File(path)) to avoid this. path=%s,query=%s,fragment=%s", uri.getPath(), uri.getQuery(), uri.getFragment()), e, 1004);
            }
            throw new FileDataSourceException(e, Util.SDK_INT >= 21 && Api21.isPermissionError(e.getCause()) ? 2006 : 2005);
        }
        catch (SecurityException e) {
            throw new FileDataSourceException(e, 2006);
        }
        catch (RuntimeException e) {
            throw new FileDataSourceException(e, 2000);
        }
    }

    public static class FileDataSourceException
    extends DataSourceException {
        @Deprecated
        public FileDataSourceException(Exception cause) {
            super(cause, 2000);
        }

        @Deprecated
        public FileDataSourceException(String message, IOException cause) {
            super(message, cause, 2000);
        }

        public FileDataSourceException(Throwable cause, int errorCode) {
            super(cause, errorCode);
        }

        public FileDataSourceException(@Nullable String message, @Nullable Throwable cause, int errorCode) {
            super(message, cause, errorCode);
        }
    }

    @RequiresApi(value=21)
    private static final class Api21 {
        private Api21() {
        }

        @DoNotInline
        private static boolean isPermissionError(@Nullable Throwable e) {
            return e instanceof ErrnoException && ((ErrnoException)e).errno == OsConstants.EACCES;
        }
    }

    public static final class Factory
    implements DataSource.Factory {
        @Nullable
        private TransferListener listener;

        @CanIgnoreReturnValue
        public Factory setListener(@Nullable TransferListener listener) {
            this.listener = listener;
            return this;
        }

        @Override
        public FileDataSource createDataSource() {
            FileDataSource dataSource = new FileDataSource();
            if (this.listener != null) {
                dataSource.addTransferListener(this.listener);
            }
            return dataSource;
        }
    }
}

