/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.annotation.FloatRange;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.AlphaScaleShaderProgram;
import androidx.media3.effect.GlEffect;

@UnstableApi
public final class AlphaScale
implements GlEffect {
    private final float alphaScale;

    public AlphaScale(@FloatRange(from=0.0) float alphaScale) {
        Assertions.checkArgument((0.0f <= alphaScale ? 1 : 0) != 0);
        this.alphaScale = alphaScale;
    }

    @Override
    public AlphaScaleShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        return new AlphaScaleShaderProgram(context, useHdr, this.alphaScale);
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        return this.alphaScale == 1.0f;
    }
}

