/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.DebugTraceUtil;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.TextureManager;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
final class BitmapTextureManager
implements TextureManager {
    private static final String UNSUPPORTED_IMAGE_CONFIGURATION = "Unsupported Image Configuration: No more than 8 bits of precision should be used for each RGB channel.";
    private final GlObjectsProvider glObjectsProvider;
    private final GlShaderProgram shaderProgram;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    private final Queue<BitmapFrameSequenceInfo> pendingBitmaps;
    private @MonotonicNonNull GlTextureInfo currentGlTextureInfo;
    private int downstreamShaderProgramCapacity;
    private int framesToQueueForCurrentBitmap;
    private double currentPresentationTimeUs;
    private boolean useHdr;
    private boolean currentInputStreamEnded;

    public BitmapTextureManager(GlObjectsProvider glObjectsProvider, GlShaderProgram shaderProgram, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor) {
        this.glObjectsProvider = glObjectsProvider;
        this.shaderProgram = shaderProgram;
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
        this.pendingBitmaps = new LinkedBlockingQueue<BitmapFrameSequenceInfo>();
    }

    @Override
    public void onReadyToAcceptInputFrame() {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            ++this.downstreamShaderProgramCapacity;
            this.maybeQueueToShaderProgram();
        });
    }

    @Override
    public void queueInputBitmap(Bitmap inputBitmap, long durationUs, FrameInfo frameInfo, float frameRate, boolean useHdr) {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            this.setupBitmap(inputBitmap, durationUs, frameInfo, frameRate, useHdr);
            this.currentInputStreamEnded = false;
        });
    }

    @Override
    public int getPendingFrameCount() {
        return 0;
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            if (this.framesToQueueForCurrentBitmap == 0 && this.pendingBitmaps.isEmpty()) {
                this.shaderProgram.signalEndOfCurrentInputStream();
                DebugTraceUtil.logEvent("BitmapTextureManager-SignalEOS", Long.MIN_VALUE);
            } else {
                this.currentInputStreamEnded = true;
            }
        });
    }

    @Override
    public void setOnFlushCompleteListener(@Nullable VideoFrameProcessingTaskExecutor.Task task) {
    }

    @Override
    public void release() {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            if (this.currentGlTextureInfo != null) {
                this.currentGlTextureInfo.release();
            }
        });
    }

    private void setupBitmap(Bitmap bitmap, long durationUs, FrameInfo frameInfo, float frameRate, boolean useHdr) throws VideoFrameProcessingException {
        if (Util.SDK_INT >= 26) {
            Assertions.checkState((!bitmap.getConfig().equals((Object)Bitmap.Config.RGBA_F16) ? 1 : 0) != 0, (Object)UNSUPPORTED_IMAGE_CONFIGURATION);
        }
        if (Util.SDK_INT >= 33) {
            Assertions.checkState((!bitmap.getConfig().equals((Object)Bitmap.Config.RGBA_1010102) ? 1 : 0) != 0, (Object)UNSUPPORTED_IMAGE_CONFIGURATION);
        }
        this.useHdr = useHdr;
        int framesToAdd = Math.round(frameRate * ((float)durationUs / 1000000.0f));
        Assertions.checkArgument((framesToAdd > 0 ? 1 : 0) != 0);
        double frameDurationUs = 1000000.0f / frameRate;
        this.pendingBitmaps.add(new BitmapFrameSequenceInfo(bitmap, frameInfo, frameDurationUs, framesToAdd));
        this.maybeQueueToShaderProgram();
    }

    private void maybeQueueToShaderProgram() throws VideoFrameProcessingException {
        if (this.pendingBitmaps.isEmpty() || this.downstreamShaderProgramCapacity == 0) {
            return;
        }
        BitmapFrameSequenceInfo currentBitmapInfo = (BitmapFrameSequenceInfo)Assertions.checkNotNull((Object)this.pendingBitmaps.peek());
        if (this.framesToQueueForCurrentBitmap == 0) {
            int currentTexId;
            Bitmap bitmap = currentBitmapInfo.bitmap;
            this.framesToQueueForCurrentBitmap = currentBitmapInfo.numberOfFrames;
            this.currentPresentationTimeUs = currentBitmapInfo.frameInfo.offsetToAddUs;
            try {
                if (this.currentGlTextureInfo != null) {
                    this.currentGlTextureInfo.release();
                }
                currentTexId = GlUtil.createTexture((int)currentBitmapInfo.frameInfo.width, (int)currentBitmapInfo.frameInfo.height, (boolean)this.useHdr);
                GLES20.glBindTexture((int)3553, (int)currentTexId);
                GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
                GlUtil.checkGlError();
            }
            catch (GlUtil.GlException e) {
                throw VideoFrameProcessingException.from((Exception)((Object)e));
            }
            this.currentGlTextureInfo = new GlTextureInfo(currentTexId, -1, -1, currentBitmapInfo.frameInfo.width, currentBitmapInfo.frameInfo.height);
        }
        --this.framesToQueueForCurrentBitmap;
        --this.downstreamShaderProgramCapacity;
        this.shaderProgram.queueInputFrame(this.glObjectsProvider, (GlTextureInfo)Assertions.checkNotNull((Object)this.currentGlTextureInfo), Math.round(this.currentPresentationTimeUs));
        DebugTraceUtil.logEvent("VFP-QueueBitmap", (long)this.currentPresentationTimeUs, currentBitmapInfo.frameInfo.width + "x" + currentBitmapInfo.frameInfo.height);
        this.currentPresentationTimeUs += currentBitmapInfo.frameDurationUs;
        if (this.framesToQueueForCurrentBitmap == 0) {
            this.pendingBitmaps.remove();
            if (this.pendingBitmaps.isEmpty() && this.currentInputStreamEnded) {
                this.shaderProgram.signalEndOfCurrentInputStream();
                DebugTraceUtil.logEvent("BitmapTextureManager-SignalEOS", Long.MIN_VALUE);
                this.currentInputStreamEnded = false;
            }
        }
    }

    private static final class BitmapFrameSequenceInfo {
        public final Bitmap bitmap;
        public final FrameInfo frameInfo;
        public final double frameDurationUs;
        public final int numberOfFrames;

        public BitmapFrameSequenceInfo(Bitmap bitmap, FrameInfo frameInfo, double frameDurationUs, int numberOfFrames) {
            this.bitmap = bitmap;
            this.frameInfo = frameInfo;
            this.frameDurationUs = frameDurationUs;
            this.numberOfFrames = numberOfFrames;
        }
    }
}

