/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.opengl.Matrix;
import androidx.annotation.FloatRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.RgbMatrix;
import java.util.Arrays;

@UnstableApi
public final class Brightness
implements RgbMatrix {
    private final float[] rgbMatrix;

    public Brightness(@FloatRange(from=-1.0, to=1.0) float brightness) {
        Assertions.checkArgument((brightness >= -1.0f && brightness <= 1.0f ? 1 : 0) != 0, (Object)"brightness value outside of range from -1f to 1f, inclusive");
        this.rgbMatrix = GlUtil.create4x4IdentityMatrix();
        Matrix.translateM((float[])this.rgbMatrix, (int)0, (float)brightness, (float)brightness, (float)brightness);
    }

    @Override
    public float[] getMatrix(long presentationTimeUs, boolean useHdr) {
        Assertions.checkArgument((!useHdr ? 1 : 0) != 0, (Object)"HDR is not supported.");
        return this.rgbMatrix;
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        return Arrays.equals(this.rgbMatrix, GlUtil.create4x4IdentityMatrix());
    }
}

