/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import androidx.annotation.FloatRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.RgbMatrix;

@UnstableApi
public final class Contrast
implements RgbMatrix {
    private final float contrast;
    private final float[] contrastMatrix;

    public Contrast(@FloatRange(from=-1.0, to=1.0) float contrast) {
        Assertions.checkArgument((-1.0f <= contrast && contrast <= 1.0f ? 1 : 0) != 0, (Object)"Contrast needs to be in the interval [-1, 1].");
        this.contrast = contrast;
        float contrastFactor = (1.0f + contrast) / (1.0001f - contrast);
        this.contrastMatrix = new float[]{contrastFactor, 0.0f, 0.0f, 0.0f, 0.0f, contrastFactor, 0.0f, 0.0f, 0.0f, 0.0f, contrastFactor, 0.0f, (1.0f - contrastFactor) * 0.5f, (1.0f - contrastFactor) * 0.5f, (1.0f - contrastFactor) * 0.5f, 1.0f};
    }

    @Override
    public float[] getMatrix(long presentationTimeUs, boolean useHdr) {
        return this.contrastMatrix;
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        return this.contrast == 0.0f;
    }
}

