/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.DefaultVideoFrameProcessor;
import androidx.media3.effect.TexturePool;
import androidx.media3.effect.VideoCompositor;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class DefaultVideoCompositor
implements VideoCompositor {
    private static final String THREAD_NAME = "Effect:DefaultVideoCompositor:GlThread";
    private static final String TAG = "DefaultVideoCompositor";
    private static final String VERTEX_SHADER_PATH = "shaders/vertex_shader_transformation_es2.glsl";
    private static final String FRAGMENT_SHADER_PATH = "shaders/fragment_shader_compositor_es2.glsl";
    private static final int PRIMARY_INPUT_ID = 0;
    private final Context context;
    private final VideoCompositor.Listener listener;
    private final DefaultVideoFrameProcessor.TextureOutputListener textureOutputListener;
    private final GlObjectsProvider glObjectsProvider;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    @GuardedBy(value="this")
    private final List<InputSource> inputSources;
    @GuardedBy(value="this")
    private boolean allInputsEnded;
    private final TexturePool outputTexturePool;
    private final Queue<Long> outputTextureTimestamps;
    private final Queue<Long> syncObjects;
    private @MonotonicNonNull EGLContext eglContext;
    private @MonotonicNonNull EGLDisplay eglDisplay;
    private @MonotonicNonNull GlProgram glProgram;
    private @MonotonicNonNull EGLSurface placeholderEglSurface;

    public DefaultVideoCompositor(Context context, GlObjectsProvider glObjectsProvider, @Nullable ExecutorService executorService, VideoCompositor.Listener listener, DefaultVideoFrameProcessor.TextureOutputListener textureOutputListener, @IntRange(from=1L) int textureOutputCapacity) {
        this.context = context;
        this.listener = listener;
        this.textureOutputListener = textureOutputListener;
        this.glObjectsProvider = glObjectsProvider;
        this.inputSources = new ArrayList<InputSource>();
        this.outputTexturePool = new TexturePool(false, textureOutputCapacity);
        this.outputTextureTimestamps = new ArrayDeque<Long>(textureOutputCapacity);
        this.syncObjects = new ArrayDeque<Long>(textureOutputCapacity);
        boolean ownsExecutor = executorService == null;
        ExecutorService instanceExecutorService = ownsExecutor ? Util.newSingleThreadExecutor((String)THREAD_NAME) : (ExecutorService)Assertions.checkNotNull((Object)executorService);
        this.videoFrameProcessingTaskExecutor = new VideoFrameProcessingTaskExecutor(instanceExecutorService, ownsExecutor, listener::onError);
        this.videoFrameProcessingTaskExecutor.submit(this::setupGlObjects);
    }

    @Override
    public synchronized int registerInputSource() {
        this.inputSources.add(new InputSource());
        return this.inputSources.size() - 1;
    }

    @Override
    public synchronized void signalEndOfInputSource(int inputId) {
        this.inputSources.get((int)inputId).isInputEnded = true;
        boolean allInputsEnded = true;
        for (int i = 0; i < this.inputSources.size(); ++i) {
            if (this.inputSources.get((int)i).isInputEnded) continue;
            allInputsEnded = false;
            break;
        }
        this.allInputsEnded = allInputsEnded;
        if (this.inputSources.get((int)0).frameInfos.isEmpty()) {
            if (inputId == 0) {
                this.releaseExcessFramesInAllSecondaryStreams();
            }
            if (allInputsEnded) {
                this.listener.onEnded();
                return;
            }
        }
        if (inputId != 0 && this.inputSources.get((int)inputId).frameInfos.size() == 1) {
            this.videoFrameProcessingTaskExecutor.submit(this::maybeComposite);
        }
    }

    @Override
    public synchronized void queueInputTexture(int inputId, GlTextureInfo inputTexture, long presentationTimeUs, DefaultVideoFrameProcessor.ReleaseOutputTextureCallback releaseTextureCallback) {
        InputSource inputSource = this.inputSources.get(inputId);
        Assertions.checkState((!inputSource.isInputEnded ? 1 : 0) != 0);
        InputFrameInfo inputFrameInfo = new InputFrameInfo(inputTexture, presentationTimeUs, releaseTextureCallback);
        inputSource.frameInfos.add(inputFrameInfo);
        if (inputId == 0) {
            this.releaseExcessFramesInAllSecondaryStreams();
        } else {
            this.releaseExcessFramesInSecondaryStream(inputSource);
        }
        this.videoFrameProcessingTaskExecutor.submit(this::maybeComposite);
    }

    @Override
    public void release() {
        try {
            this.videoFrameProcessingTaskExecutor.release(this::releaseGlObjects);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private synchronized void releaseExcessFramesInAllSecondaryStreams() {
        for (int i = 0; i < this.inputSources.size(); ++i) {
            if (i == 0) continue;
            this.releaseExcessFramesInSecondaryStream(this.inputSources.get(i));
        }
    }

    private synchronized void releaseExcessFramesInSecondaryStream(InputSource secondaryInputSource) {
        InputSource primaryInputSource = this.inputSources.get(0);
        if (primaryInputSource.frameInfos.isEmpty() && primaryInputSource.isInputEnded) {
            this.releaseFrames(secondaryInputSource, secondaryInputSource.frameInfos.size());
            return;
        }
        InputFrameInfo nextPrimaryFrame = primaryInputSource.frameInfos.peek();
        long nextTimestampToComposite = nextPrimaryFrame != null ? nextPrimaryFrame.presentationTimeUs : -9223372036854775807L;
        int numberOfSecondaryFramesBeforeOrAtNextTargetTimestamp = Iterables.size((Iterable)Iterables.filter(secondaryInputSource.frameInfos, frame -> frame.presentationTimeUs <= nextTimestampToComposite));
        this.releaseFrames(secondaryInputSource, Math.max(numberOfSecondaryFramesBeforeOrAtNextTargetTimestamp - 1, 0));
    }

    private synchronized void releaseFrames(InputSource inputSource, int numberOfFramesToRelease) {
        for (int i = 0; i < numberOfFramesToRelease; ++i) {
            InputFrameInfo frameInfoToRelease = inputSource.frameInfos.remove();
            frameInfoToRelease.releaseCallback.release(frameInfoToRelease.presentationTimeUs);
        }
    }

    private void setupGlObjects() throws GlUtil.GlException {
        this.eglDisplay = GlUtil.getDefaultEglDisplay();
        this.eglContext = this.glObjectsProvider.createEglContext(this.eglDisplay, 2, GlUtil.EGL_CONFIG_ATTRIBUTES_RGBA_8888);
        this.placeholderEglSurface = this.glObjectsProvider.createFocusedPlaceholderEglSurface(this.eglContext, this.eglDisplay);
    }

    private synchronized void maybeComposite() throws VideoFrameProcessingException, GlUtil.GlException {
        ImmutableList<InputFrameInfo> framesToComposite = this.getFramesToComposite();
        if (framesToComposite.isEmpty()) {
            return;
        }
        this.ensureGlProgramConfigured();
        InputFrameInfo inputFrame1 = (InputFrameInfo)framesToComposite.get(0);
        InputFrameInfo inputFrame2 = (InputFrameInfo)framesToComposite.get(1);
        Assertions.checkState((inputFrame1.texture.width == inputFrame2.texture.width ? 1 : 0) != 0);
        Assertions.checkState((inputFrame1.texture.height == inputFrame2.texture.height ? 1 : 0) != 0);
        this.outputTexturePool.ensureConfigured(this.glObjectsProvider, inputFrame1.texture.width, inputFrame1.texture.height);
        GlTextureInfo outputTexture = this.outputTexturePool.useTexture();
        long outputPresentationTimestampUs = ((InputFrameInfo)framesToComposite.get((int)0)).presentationTimeUs;
        this.outputTextureTimestamps.add(outputPresentationTimestampUs);
        this.drawFrame(inputFrame1.texture, inputFrame2.texture, outputTexture);
        long syncObject = GlUtil.createGlSyncFence();
        this.syncObjects.add(syncObject);
        this.textureOutputListener.onTextureRendered(outputTexture, outputPresentationTimestampUs, this::releaseOutputFrame, syncObject);
        InputSource primaryInputSource = this.inputSources.get(0);
        this.releaseFrames(primaryInputSource, 1);
        this.releaseExcessFramesInAllSecondaryStreams();
        if (this.allInputsEnded && this.inputSources.get((int)0).frameInfos.isEmpty()) {
            this.listener.onEnded();
        }
    }

    private synchronized ImmutableList<InputFrameInfo> getFramesToComposite() {
        if (this.outputTexturePool.freeTextureCount() == 0) {
            return ImmutableList.of();
        }
        for (int inputId = 0; inputId < this.inputSources.size(); ++inputId) {
            if (!this.inputSources.get((int)inputId).frameInfos.isEmpty()) continue;
            return ImmutableList.of();
        }
        ImmutableList.Builder framesToComposite = new ImmutableList.Builder();
        InputFrameInfo primaryFrameToComposite = this.inputSources.get((int)0).frameInfos.element();
        framesToComposite.add((Object)primaryFrameToComposite);
        block1: for (int inputId = 0; inputId < this.inputSources.size(); ++inputId) {
            if (inputId == 0) continue;
            InputSource secondaryInputSource = this.inputSources.get(inputId);
            if (secondaryInputSource.frameInfos.size() == 1 && !secondaryInputSource.isInputEnded) {
                return ImmutableList.of();
            }
            long minTimeDiffFromPrimaryUs = Long.MAX_VALUE;
            InputFrameInfo secondaryFrameToComposite = null;
            Iterator frameInfosIterator = secondaryInputSource.frameInfos.iterator();
            while (frameInfosIterator.hasNext()) {
                InputFrameInfo candidateFrame = (InputFrameInfo)frameInfosIterator.next();
                long candidateTimestampUs = candidateFrame.presentationTimeUs;
                long candidateAbsDistance = Math.abs(candidateTimestampUs - primaryFrameToComposite.presentationTimeUs);
                if (candidateAbsDistance < minTimeDiffFromPrimaryUs) {
                    minTimeDiffFromPrimaryUs = candidateAbsDistance;
                    secondaryFrameToComposite = candidateFrame;
                }
                if (candidateTimestampUs <= primaryFrameToComposite.presentationTimeUs && (frameInfosIterator.hasNext() || !secondaryInputSource.isInputEnded)) continue;
                framesToComposite.add((Object)((InputFrameInfo)Assertions.checkNotNull((Object)secondaryFrameToComposite)));
                continue block1;
            }
        }
        ImmutableList framesToCompositeList = framesToComposite.build();
        if (framesToCompositeList.size() != this.inputSources.size()) {
            return ImmutableList.of();
        }
        return framesToCompositeList;
    }

    private void releaseOutputFrame(long presentationTimeUs) {
        this.videoFrameProcessingTaskExecutor.submit(() -> this.releaseOutputFrameInternal(presentationTimeUs));
    }

    private synchronized void releaseOutputFrameInternal(long presentationTimeUs) throws VideoFrameProcessingException, GlUtil.GlException {
        while (this.outputTexturePool.freeTextureCount() < this.outputTexturePool.capacity() && (Long)Assertions.checkNotNull((Object)this.outputTextureTimestamps.peek()) <= presentationTimeUs) {
            this.outputTexturePool.freeTexture();
            this.outputTextureTimestamps.remove();
            GlUtil.deleteSyncObject((long)this.syncObjects.remove());
        }
        this.maybeComposite();
    }

    private void ensureGlProgramConfigured() throws VideoFrameProcessingException, GlUtil.GlException {
        if (this.glProgram != null) {
            return;
        }
        try {
            this.glProgram = new GlProgram(this.context, VERTEX_SHADER_PATH, FRAGMENT_SHADER_PATH);
            this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
        }
        catch (IOException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }

    private void drawFrame(GlTextureInfo inputTexture1, GlTextureInfo inputTexture2, GlTextureInfo outputTexture) throws GlUtil.GlException {
        GlUtil.focusFramebufferUsingCurrentContext((int)outputTexture.fboId, (int)outputTexture.width, (int)outputTexture.height);
        GlUtil.clearFocusedBuffers();
        GlProgram glProgram = (GlProgram)Assertions.checkNotNull((Object)this.glProgram);
        glProgram.use();
        glProgram.setSamplerTexIdUniform("uTexSampler1", inputTexture1.texId, 0);
        glProgram.setSamplerTexIdUniform("uTexSampler2", inputTexture2.texId, 1);
        glProgram.setFloatsUniform("uTexTransformationMatrix", GlUtil.create4x4IdentityMatrix());
        glProgram.setFloatsUniform("uTransformationMatrix", GlUtil.create4x4IdentityMatrix());
        glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
        glProgram.bindAttributesAndUniforms();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError();
    }

    private synchronized void releaseGlObjects() {
        try {
            Assertions.checkState((boolean)this.allInputsEnded);
            this.outputTexturePool.deleteAllTextures();
            GlUtil.destroyEglSurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.placeholderEglSurface);
            if (this.glProgram != null) {
                this.glProgram.delete();
            }
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Error releasing GL resources", (Throwable)e);
        }
        finally {
            try {
                GlUtil.destroyEglContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            }
            catch (GlUtil.GlException e) {
                Log.e((String)TAG, (String)"Error releasing GL context", (Throwable)e);
            }
        }
    }

    private static final class InputSource {
        public final Queue<InputFrameInfo> frameInfos = new ArrayDeque<InputFrameInfo>();
        public boolean isInputEnded;
    }

    private static final class InputFrameInfo {
        public final GlTextureInfo texture;
        public final long presentationTimeUs;
        public final DefaultVideoFrameProcessor.ReleaseOutputTextureCallback releaseCallback;

        public InputFrameInfo(GlTextureInfo texture, long presentationTimeUs, DefaultVideoFrameProcessor.ReleaseOutputTextureCallback releaseCallback) {
            this.texture = texture;
            this.presentationTimeUs = presentationTimeUs;
            this.releaseCallback = releaseCallback;
        }
    }
}

