/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DebugViewProvider;
import androidx.media3.common.Effect;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.OnInputFrameProcessedListener;
import androidx.media3.common.SurfaceInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.VideoFrameProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.ChainingGlShaderProgramListener;
import androidx.media3.effect.DebugTraceUtil;
import androidx.media3.effect.DefaultGlObjectsProvider;
import androidx.media3.effect.DefaultShaderProgram;
import androidx.media3.effect.FinalShaderProgramWrapper;
import androidx.media3.effect.GlEffect;
import androidx.media3.effect.GlMatrixTransformation;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.InputSwitcher;
import androidx.media3.effect.RgbMatrix;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class DefaultVideoFrameProcessor
implements VideoFrameProcessor {
    private static final String TAG = "DefaultFrameProcessor";
    private final Context context;
    private final GlObjectsProvider glObjectsProvider;
    private final EGLDisplay eglDisplay;
    private final EGLContext eglContext;
    private final InputSwitcher inputSwitcher;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    private final VideoFrameProcessor.Listener listener;
    private final Executor listenerExecutor;
    private final boolean renderFramesAutomatically;
    private final FinalShaderProgramWrapper finalShaderProgramWrapper;
    private final List<GlShaderProgram> intermediateGlShaderPrograms;
    @GuardedBy(value="lock")
    private boolean processingInput;
    private final List<Effect> activeEffects;
    private final Object lock;
    private final ColorInfo outputColorInfo;
    private volatile @MonotonicNonNull CountDownLatch latch;
    private volatile @MonotonicNonNull FrameInfo nextInputFrameInfo;
    private volatile boolean inputStreamEnded;
    private volatile boolean hasRefreshedNextInputFrameInfo;

    private DefaultVideoFrameProcessor(Context context, GlObjectsProvider glObjectsProvider, EGLDisplay eglDisplay, EGLContext eglContext, InputSwitcher inputSwitcher, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor, VideoFrameProcessor.Listener listener, Executor listenerExecutor, FinalShaderProgramWrapper finalShaderProgramWrapper, boolean renderFramesAutomatically, ColorInfo outputColorInfo) {
        this.context = context;
        this.glObjectsProvider = glObjectsProvider;
        this.eglDisplay = eglDisplay;
        this.eglContext = eglContext;
        this.inputSwitcher = inputSwitcher;
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
        this.listener = listener;
        this.listenerExecutor = listenerExecutor;
        this.renderFramesAutomatically = renderFramesAutomatically;
        this.activeEffects = new ArrayList<Effect>();
        this.lock = new Object();
        this.outputColorInfo = outputColorInfo;
        this.finalShaderProgramWrapper = finalShaderProgramWrapper;
        finalShaderProgramWrapper.setOnInputStreamProcessedListener(() -> {
            boolean inputEndedAfterThisInputStream;
            DebugTraceUtil.logEvent("VFP-FinishOneInputStream", Long.MIN_VALUE);
            Object object = this.lock;
            synchronized (object) {
                this.processingInput = false;
                inputEndedAfterThisInputStream = this.inputStreamEnded;
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
            if (inputEndedAfterThisInputStream) {
                listenerExecutor.execute(() -> ((VideoFrameProcessor.Listener)listener).onEnded());
                DebugTraceUtil.logEvent("VFP-SignalEnded", Long.MIN_VALUE);
            }
        });
        this.intermediateGlShaderPrograms = new ArrayList<GlShaderProgram>();
    }

    @VisibleForTesting
    public VideoFrameProcessingTaskExecutor getTaskExecutor() {
        return this.videoFrameProcessingTaskExecutor;
    }

    public void setInputDefaultBufferSize(int width, int height) {
        this.inputSwitcher.activeTextureManager().setDefaultBufferSize(width, height);
    }

    public void queueInputBitmap(Bitmap inputBitmap, long durationUs, float frameRate) {
        Assertions.checkState((boolean)this.hasRefreshedNextInputFrameInfo, (Object)"registerInputStream must be called before queueing another bitmap");
        this.inputSwitcher.activeTextureManager().queueInputBitmap(inputBitmap, durationUs, (FrameInfo)Assertions.checkNotNull((Object)this.nextInputFrameInfo), frameRate, false);
        this.hasRefreshedNextInputFrameInfo = false;
    }

    public void queueInputBitmap(Bitmap inputBitmap, Iterator<Long> inStreamOffsetsUs) {
        FrameInfo frameInfo = (FrameInfo)Assertions.checkNotNull((Object)this.nextInputFrameInfo);
        while (inStreamOffsetsUs.hasNext()) {
            long inStreamOffsetUs = inStreamOffsetsUs.next();
            this.inputSwitcher.activeTextureManager().queueInputBitmap(inputBitmap, 1000000L, new FrameInfo.Builder(frameInfo).setOffsetToAddUs(frameInfo.offsetToAddUs + inStreamOffsetUs).build(), 1.0f, false);
        }
    }

    public void queueInputTexture(int textureId, long presentationTimeUs) {
        this.inputSwitcher.activeTextureManager().queueInputTexture(textureId, presentationTimeUs);
    }

    public void setOnInputFrameProcessedListener(OnInputFrameProcessedListener listener) {
        this.inputSwitcher.activeTextureManager().setOnInputFrameProcessedListener(listener);
    }

    public Surface getInputSurface() {
        return this.inputSwitcher.getInputSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInputStream(int inputType, List<Effect> effects, FrameInfo frameInfo) {
        DebugTraceUtil.logEvent("VFP-RegisterNewInputStream", frameInfo.offsetToAddUs, Util.formatInvariant((String)"InputType %s - %dx%d", (Object[])new Object[]{DefaultVideoFrameProcessor.getInputTypeString(inputType), frameInfo.width, frameInfo.height}));
        this.nextInputFrameInfo = this.adjustForPixelWidthHeightRatio(frameInfo);
        this.hasRefreshedNextInputFrameInfo = true;
        Object object = this.lock;
        synchronized (object) {
            if (!this.processingInput) {
                this.videoFrameProcessingTaskExecutor.submitAndBlock(() -> this.configureEffects(effects));
                this.inputSwitcher.switchToInput(inputType, this.nextInputFrameInfo);
                this.inputSwitcher.activeTextureManager().setInputFrameInfo(this.nextInputFrameInfo);
                this.processingInput = true;
                return;
            }
        }
        this.latch = new CountDownLatch(1);
        this.inputSwitcher.activeTextureManager().signalEndOfCurrentInputStream();
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.listenerExecutor.execute(() -> this.listener.onError(VideoFrameProcessingException.from((Exception)e)));
        }
        object = this.lock;
        synchronized (object) {
            this.processingInput = true;
        }
        if (!this.activeEffects.equals(effects)) {
            this.videoFrameProcessingTaskExecutor.submitAndBlock(() -> this.configureEffects(effects));
        }
        this.inputSwitcher.switchToInput(inputType, this.nextInputFrameInfo);
    }

    public void registerInputFrame() {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0);
        Assertions.checkStateNotNull((Object)this.nextInputFrameInfo, (Object)"registerInputStream must be called before registering input frames");
        this.inputSwitcher.activeTextureManager().registerInputFrame(this.nextInputFrameInfo);
        this.hasRefreshedNextInputFrameInfo = false;
    }

    public int getPendingInputFrameCount() {
        return this.inputSwitcher.activeTextureManager().getPendingFrameCount();
    }

    public void setOutputSurfaceInfo(@Nullable SurfaceInfo outputSurfaceInfo) {
        this.finalShaderProgramWrapper.setOutputSurfaceInfo(outputSurfaceInfo);
    }

    public void renderOutputFrame(long renderTimeNs) {
        Assertions.checkState((!this.renderFramesAutomatically ? 1 : 0) != 0, (Object)"Calling this method is not allowed when renderFramesAutomatically is enabled");
        this.videoFrameProcessingTaskExecutor.submitWithHighPriority(() -> this.finalShaderProgramWrapper.renderOutputFrame(this.glObjectsProvider, renderTimeNs));
    }

    public void signalEndOfInput() {
        DebugTraceUtil.logEvent("VFP-ReceiveEndOfAllInput", Long.MIN_VALUE);
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0);
        this.inputStreamEnded = true;
        this.inputSwitcher.signalEndOfCurrentInputStream();
    }

    public void flush() {
        try {
            this.videoFrameProcessingTaskExecutor.flush();
            CountDownLatch latch = new CountDownLatch(1);
            this.inputSwitcher.activeTextureManager().setOnFlushCompleteListener(latch::countDown);
            this.videoFrameProcessingTaskExecutor.submit(this.finalShaderProgramWrapper::flush);
            latch.await();
            this.inputSwitcher.activeTextureManager().setOnFlushCompleteListener(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void release() {
        try {
            this.videoFrameProcessingTaskExecutor.release(this::releaseGlObjects);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private FrameInfo adjustForPixelWidthHeightRatio(FrameInfo frameInfo) {
        if (frameInfo.pixelWidthHeightRatio > 1.0f) {
            return new FrameInfo.Builder(frameInfo).setWidth((int)((float)frameInfo.width * frameInfo.pixelWidthHeightRatio)).setPixelWidthHeightRatio(1.0f).build();
        }
        if (frameInfo.pixelWidthHeightRatio < 1.0f) {
            return new FrameInfo.Builder(frameInfo).setHeight((int)((float)frameInfo.height / frameInfo.pixelWidthHeightRatio)).setPixelWidthHeightRatio(1.0f).build();
        }
        return frameInfo;
    }

    private static DefaultVideoFrameProcessor createOpenGlObjectsAndFrameProcessor(Context context, DebugViewProvider debugViewProvider, ColorInfo inputColorInfo, ColorInfo outputColorInfo, boolean enableColorTransfers, boolean renderFramesAutomatically, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor, Executor videoFrameProcessorListenerExecutor, VideoFrameProcessor.Listener listener, GlObjectsProvider glObjectsProvider, @Nullable TextureOutputListener textureOutputListener, int textureOutputCapacity) throws GlUtil.GlException, VideoFrameProcessingException {
        EGLDisplay eglDisplay = GlUtil.getDefaultEglDisplay();
        int[] configAttributes = ColorInfo.isTransferHdr((ColorInfo)outputColorInfo) ? GlUtil.EGL_CONFIG_ATTRIBUTES_RGBA_1010102 : GlUtil.EGL_CONFIG_ATTRIBUTES_RGBA_8888;
        int openGlVersion = ColorInfo.isTransferHdr((ColorInfo)inputColorInfo) || ColorInfo.isTransferHdr((ColorInfo)outputColorInfo) ? 3 : 2;
        EGLContext eglContext = glObjectsProvider.createEglContext(eglDisplay, openGlVersion, configAttributes);
        glObjectsProvider.createFocusedPlaceholderEglSurface(eglContext, eglDisplay);
        if (!renderFramesAutomatically && ColorInfo.isTransferHdr((ColorInfo)outputColorInfo)) {
            Assertions.checkArgument((outputColorInfo.colorTransfer == 6 ? 1 : 0) != 0);
            if (Util.SDK_INT < 33 || !GlUtil.isBt2020PqExtensionSupported()) {
                GlUtil.destroyEglContext((EGLDisplay)eglDisplay, (EGLContext)eglContext);
                throw new VideoFrameProcessingException("BT.2020 PQ OpenGL output isn't supported.");
            }
        }
        ColorInfo linearColorInfo = outputColorInfo.buildUpon().setColorTransfer(1).setHdrStaticInfo(null).build();
        InputSwitcher inputSwitcher = new InputSwitcher(context, linearColorInfo, glObjectsProvider, videoFrameProcessingTaskExecutor, enableColorTransfers);
        FinalShaderProgramWrapper finalShaderProgramWrapper = new FinalShaderProgramWrapper(context, eglDisplay, eglContext, debugViewProvider, outputColorInfo, enableColorTransfers, renderFramesAutomatically, videoFrameProcessingTaskExecutor, videoFrameProcessorListenerExecutor, listener, textureOutputListener, textureOutputCapacity);
        inputSwitcher.registerInput(inputColorInfo, 1);
        if (!ColorInfo.isTransferHdr((ColorInfo)inputColorInfo)) {
            inputSwitcher.registerInput(ColorInfo.SRGB_BT709_FULL, 2);
        }
        if (inputColorInfo.colorTransfer != 2) {
            inputSwitcher.registerInput(inputColorInfo, 3);
        }
        return new DefaultVideoFrameProcessor(context, glObjectsProvider, eglDisplay, eglContext, inputSwitcher, videoFrameProcessingTaskExecutor, listener, videoFrameProcessorListenerExecutor, finalShaderProgramWrapper, renderFramesAutomatically, outputColorInfo);
    }

    private static ImmutableList<GlShaderProgram> createGlShaderPrograms(Context context, List<Effect> effects, ColorInfo outputColorInfo, FinalShaderProgramWrapper finalShaderProgramWrapper) throws VideoFrameProcessingException {
        ImmutableList.Builder shaderProgramListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder matrixTransformationListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder rgbMatrixListBuilder = new ImmutableList.Builder();
        for (int i = 0; i < effects.size(); ++i) {
            Effect effect = effects.get(i);
            Assertions.checkArgument((boolean)(effect instanceof GlEffect), (Object)"DefaultVideoFrameProcessor only supports GlEffects");
            GlEffect glEffect = (GlEffect)effect;
            if (glEffect instanceof GlMatrixTransformation) {
                matrixTransformationListBuilder.add((Object)((GlMatrixTransformation)glEffect));
                continue;
            }
            if (glEffect instanceof RgbMatrix) {
                rgbMatrixListBuilder.add((Object)((RgbMatrix)glEffect));
                continue;
            }
            ImmutableList matrixTransformations = matrixTransformationListBuilder.build();
            ImmutableList rgbMatrices = rgbMatrixListBuilder.build();
            boolean isOutputTransferHdr = ColorInfo.isTransferHdr((ColorInfo)outputColorInfo);
            if (!matrixTransformations.isEmpty() || !rgbMatrices.isEmpty()) {
                DefaultShaderProgram defaultShaderProgram = DefaultShaderProgram.create(context, (List<GlMatrixTransformation>)matrixTransformations, (List<RgbMatrix>)rgbMatrices, isOutputTransferHdr);
                shaderProgramListBuilder.add((Object)defaultShaderProgram);
                matrixTransformationListBuilder = new ImmutableList.Builder();
                rgbMatrixListBuilder = new ImmutableList.Builder();
            }
            shaderProgramListBuilder.add((Object)glEffect.toGlShaderProgram(context, isOutputTransferHdr));
        }
        finalShaderProgramWrapper.setMatrixTransformations((List<GlMatrixTransformation>)matrixTransformationListBuilder.build(), (List<RgbMatrix>)rgbMatrixListBuilder.build());
        return shaderProgramListBuilder.build();
    }

    private static void chainShaderProgramsWithListeners(GlObjectsProvider glObjectsProvider, List<GlShaderProgram> shaderPrograms, FinalShaderProgramWrapper finalShaderProgramWrapper, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor, VideoFrameProcessor.Listener videoFrameProcessorListener, Executor videoFrameProcessorListenerExecutor) {
        ArrayList<GlShaderProgram> shaderProgramsToChain = new ArrayList<GlShaderProgram>(shaderPrograms);
        shaderProgramsToChain.add(finalShaderProgramWrapper);
        for (int i = 0; i < shaderProgramsToChain.size() - 1; ++i) {
            GlShaderProgram producingGlShaderProgram = shaderProgramsToChain.get(i);
            GlShaderProgram consumingGlShaderProgram = shaderProgramsToChain.get(i + 1);
            ChainingGlShaderProgramListener chainingGlShaderProgramListener = new ChainingGlShaderProgramListener(glObjectsProvider, producingGlShaderProgram, consumingGlShaderProgram, videoFrameProcessingTaskExecutor);
            producingGlShaderProgram.setOutputListener(chainingGlShaderProgramListener);
            producingGlShaderProgram.setErrorListener(videoFrameProcessorListenerExecutor, arg_0 -> ((VideoFrameProcessor.Listener)videoFrameProcessorListener).onError(arg_0));
            consumingGlShaderProgram.setInputListener(chainingGlShaderProgramListener);
        }
    }

    private static String getInputTypeString(int inputType) {
        switch (inputType) {
            case 1: {
                return "Surface";
            }
            case 2: {
                return "Bitmap";
            }
            case 3: {
                return "Texture ID";
            }
        }
        throw new IllegalArgumentException(String.valueOf(inputType));
    }

    private void configureEffects(List<Effect> effects) throws VideoFrameProcessingException {
        if (!this.intermediateGlShaderPrograms.isEmpty()) {
            for (int i = 0; i < this.intermediateGlShaderPrograms.size(); ++i) {
                this.intermediateGlShaderPrograms.get(i).release();
            }
            this.intermediateGlShaderPrograms.clear();
        }
        this.intermediateGlShaderPrograms.addAll((Collection<GlShaderProgram>)DefaultVideoFrameProcessor.createGlShaderPrograms(this.context, effects, this.outputColorInfo, this.finalShaderProgramWrapper));
        this.inputSwitcher.setDownstreamShaderProgram((GlShaderProgram)Iterables.getFirst(this.intermediateGlShaderPrograms, (Object)this.finalShaderProgramWrapper));
        DefaultVideoFrameProcessor.chainShaderProgramsWithListeners(this.glObjectsProvider, this.intermediateGlShaderPrograms, this.finalShaderProgramWrapper, this.videoFrameProcessingTaskExecutor, this.listener, this.listenerExecutor);
        this.activeEffects.clear();
        this.activeEffects.addAll(effects);
    }

    private void releaseGlObjects() {
        try {
            try {
                this.inputSwitcher.release();
                for (int i = 0; i < this.intermediateGlShaderPrograms.size(); ++i) {
                    this.intermediateGlShaderPrograms.get(i).release();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error releasing shader program", (Throwable)e);
            }
        }
        finally {
            try {
                GlUtil.destroyEglContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            }
            catch (GlUtil.GlException e) {
                Log.e((String)TAG, (String)"Error releasing GL context", (Throwable)e);
            }
        }
    }

    @VisibleForTesting(otherwise=3)
    public static interface TextureOutputListener {
        public void onTextureRendered(GlTextureInfo var1, long var2, ReleaseOutputTextureCallback var4, long var5) throws VideoFrameProcessingException, GlUtil.GlException;
    }

    public static final class Factory
    implements VideoFrameProcessor.Factory {
        private static final String THREAD_NAME = "Effect:DefaultVideoFrameProcessor:GlThread";
        private final boolean enableColorTransfers;
        private final GlObjectsProvider glObjectsProvider;
        @Nullable
        private final ExecutorService executorService;
        @Nullable
        private final TextureOutputListener textureOutputListener;
        private final int textureOutputCapacity;

        private Factory(boolean enableColorTransfers, GlObjectsProvider glObjectsProvider, @Nullable ExecutorService executorService, @Nullable TextureOutputListener textureOutputListener, int textureOutputCapacity) {
            this.enableColorTransfers = enableColorTransfers;
            this.glObjectsProvider = glObjectsProvider;
            this.executorService = executorService;
            this.textureOutputListener = textureOutputListener;
            this.textureOutputCapacity = textureOutputCapacity;
        }

        public DefaultVideoFrameProcessor create(Context context, DebugViewProvider debugViewProvider, ColorInfo inputColorInfo, ColorInfo outputColorInfo, boolean renderFramesAutomatically, Executor listenerExecutor, VideoFrameProcessor.Listener listener) throws VideoFrameProcessingException {
            Assertions.checkArgument((boolean)inputColorInfo.isValid());
            Assertions.checkArgument((inputColorInfo.colorTransfer != 1 ? 1 : 0) != 0);
            Assertions.checkArgument((boolean)outputColorInfo.isValid());
            Assertions.checkArgument((outputColorInfo.colorTransfer != 1 ? 1 : 0) != 0);
            if (ColorInfo.isTransferHdr((ColorInfo)inputColorInfo) || ColorInfo.isTransferHdr((ColorInfo)outputColorInfo)) {
                Assertions.checkArgument((boolean)this.enableColorTransfers);
            }
            if (inputColorInfo.colorSpace != outputColorInfo.colorSpace || ColorInfo.isTransferHdr((ColorInfo)inputColorInfo) != ColorInfo.isTransferHdr((ColorInfo)outputColorInfo)) {
                Assertions.checkArgument((inputColorInfo.colorSpace == 6 ? 1 : 0) != 0);
                Assertions.checkArgument((outputColorInfo.colorSpace != 6 ? 1 : 0) != 0);
                Assertions.checkArgument((boolean)ColorInfo.isTransferHdr((ColorInfo)inputColorInfo));
                Assertions.checkArgument((outputColorInfo.colorTransfer == 10 ? 1 : 0) != 0);
            }
            boolean shouldShutdownExecutorService = this.executorService == null;
            ExecutorService instanceExecutorService = this.executorService == null ? Util.newSingleThreadExecutor((String)THREAD_NAME) : this.executorService;
            VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor = new VideoFrameProcessingTaskExecutor(instanceExecutorService, shouldShutdownExecutorService, arg_0 -> ((VideoFrameProcessor.Listener)listener).onError(arg_0));
            Future<DefaultVideoFrameProcessor> defaultVideoFrameProcessorFuture = instanceExecutorService.submit(() -> DefaultVideoFrameProcessor.createOpenGlObjectsAndFrameProcessor(context, debugViewProvider, inputColorInfo, outputColorInfo, this.enableColorTransfers, renderFramesAutomatically, videoFrameProcessingTaskExecutor, listenerExecutor, listener, this.glObjectsProvider, this.textureOutputListener, this.textureOutputCapacity));
            try {
                return defaultVideoFrameProcessorFuture.get();
            }
            catch (ExecutionException e) {
                throw new VideoFrameProcessingException((Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new VideoFrameProcessingException((Throwable)e);
            }
        }

        public static final class Builder {
            private boolean enableColorTransfers = true;
            private @MonotonicNonNull GlObjectsProvider glObjectsProvider;
            private @MonotonicNonNull ExecutorService executorService;
            private @MonotonicNonNull TextureOutputListener textureOutputListener;
            private int textureOutputCapacity;

            @CanIgnoreReturnValue
            public Builder setEnableColorTransfers(boolean enableColorTransfers) {
                this.enableColorTransfers = enableColorTransfers;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setGlObjectsProvider(GlObjectsProvider glObjectsProvider) {
                this.glObjectsProvider = glObjectsProvider;
                return this;
            }

            @CanIgnoreReturnValue
            @VisibleForTesting(otherwise=3)
            public Builder setExecutorService(ExecutorService executorService) {
                this.executorService = executorService;
                return this;
            }

            @VisibleForTesting
            @CanIgnoreReturnValue
            public Builder setTextureOutput(TextureOutputListener textureOutputListener, @IntRange(from=1L) int textureOutputCapacity) {
                this.textureOutputListener = textureOutputListener;
                Assertions.checkArgument((textureOutputCapacity >= 1 ? 1 : 0) != 0);
                this.textureOutputCapacity = textureOutputCapacity;
                return this;
            }

            public Factory build() {
                return new Factory(this.enableColorTransfers, this.glObjectsProvider == null ? new DefaultGlObjectsProvider() : this.glObjectsProvider, this.executorService, this.textureOutputListener, this.textureOutputCapacity);
            }
        }
    }

    public static interface ReleaseOutputTextureCallback {
        public void release(long var1);
    }
}

