/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.GLES20;
import androidx.annotation.CallSuper;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.effect.BaseGlShaderProgram;
import java.io.IOException;

class FrameCacheGlShaderProgram
extends BaseGlShaderProgram {
    private static final String VERTEX_SHADER_TRANSFORMATION_ES2_PATH = "shaders/vertex_shader_transformation_es2.glsl";
    private static final String FRAGMENT_SHADER_TRANSFORMATION_ES2_PATH = "shaders/fragment_shader_transformation_es2.glsl";
    private final GlProgram copyProgram;

    public FrameCacheGlShaderProgram(Context context, int capacity, boolean useHdr) throws VideoFrameProcessingException {
        super(useHdr, capacity);
        try {
            this.copyProgram = new GlProgram(context, VERTEX_SHADER_TRANSFORMATION_ES2_PATH, FRAGMENT_SHADER_TRANSFORMATION_ES2_PATH);
        }
        catch (GlUtil.GlException | IOException e) {
            throw VideoFrameProcessingException.from((Exception)e);
        }
        float[] identityMatrix = GlUtil.create4x4IdentityMatrix();
        this.copyProgram.setFloatsUniform("uTexTransformationMatrix", identityMatrix);
        this.copyProgram.setFloatsUniform("uTransformationMatrix", identityMatrix);
        this.copyProgram.setFloatsUniform("uRgbMatrix", identityMatrix);
        this.copyProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        return new Size(inputWidth, inputHeight);
    }

    @Override
    public void drawFrame(int inputTexId, long presentationTimeUs) throws VideoFrameProcessingException {
        try {
            this.copyProgram.use();
            this.copyProgram.setSamplerTexIdUniform("uTexSampler", inputTexId, 0);
            this.copyProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
        catch (GlUtil.GlException e) {
            throw VideoFrameProcessingException.from((Exception)((Object)e));
        }
    }

    @Override
    @CallSuper
    public void release() throws VideoFrameProcessingException {
        super.release();
        try {
            this.copyProgram.delete();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }
}

