/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.DefaultFrameDroppingShaderProgram;
import androidx.media3.effect.GlEffect;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.SimpleFrameDroppingShaderProgram;

@UnstableApi
public final class FrameDropEffect
implements GlEffect {
    private final float inputFrameRate;
    private final float targetFrameRate;

    public static FrameDropEffect createDefaultFrameDropEffect(float targetFrameRate) {
        return new FrameDropEffect(-3.4028235E38f, targetFrameRate);
    }

    public static FrameDropEffect createSimpleFrameDropEffect(float expectedFrameRate, float targetFrameRate) {
        return new FrameDropEffect(expectedFrameRate, targetFrameRate);
    }

    @Override
    public GlShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        if (this.inputFrameRate == -3.4028235E38f) {
            return new DefaultFrameDroppingShaderProgram(context, useHdr, this.targetFrameRate);
        }
        return new SimpleFrameDroppingShaderProgram(context, useHdr, this.inputFrameRate, this.targetFrameRate);
    }

    private FrameDropEffect(float inputFrameRate, float targetFrameRate) {
        this.inputFrameRate = inputFrameRate;
        this.targetFrameRate = targetFrameRate;
    }
}

