/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.GLES20;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.HslAdjustment;
import java.io.IOException;

final class HslShaderProgram
extends BaseGlShaderProgram {
    private static final String VERTEX_SHADER_PATH = "shaders/vertex_shader_transformation_es2.glsl";
    private static final String FRAGMENT_SHADER_PATH = "shaders/fragment_shader_hsl_es2.glsl";
    private final GlProgram glProgram;

    public HslShaderProgram(Context context, HslAdjustment hslAdjustment, boolean useHdr) throws VideoFrameProcessingException {
        super(useHdr, 1);
        Assertions.checkArgument((!useHdr ? 1 : 0) != 0, (Object)"HDR is not yet supported.");
        try {
            this.glProgram = new GlProgram(context, VERTEX_SHADER_PATH, FRAGMENT_SHADER_PATH);
        }
        catch (GlUtil.GlException | IOException e) {
            throw new VideoFrameProcessingException(e);
        }
        this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
        float[] identityMatrix = GlUtil.create4x4IdentityMatrix();
        this.glProgram.setFloatsUniform("uTransformationMatrix", identityMatrix);
        this.glProgram.setFloatsUniform("uTexTransformationMatrix", identityMatrix);
        this.glProgram.setFloatUniform("uHueAdjustmentDegrees", hslAdjustment.hueAdjustmentDegrees / 360.0f);
        this.glProgram.setFloatUniform("uSaturationAdjustment", hslAdjustment.saturationAdjustment / 100.0f);
        this.glProgram.setFloatUniform("uLightnessAdjustment", hslAdjustment.lightnessAdjustment / 100.0f);
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        return new Size(inputWidth, inputHeight);
    }

    @Override
    public void drawFrame(int inputTexId, long presentationTimeUs) throws VideoFrameProcessingException {
        try {
            this.glProgram.use();
            this.glProgram.setSamplerTexIdUniform("uTexSampler", inputTexId, 0);
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e, presentationTimeUs);
        }
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        super.release();
        try {
            this.glProgram.delete();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }
}

