/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.util.SparseArray;
import android.view.Surface;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.effect.BitmapTextureManager;
import androidx.media3.effect.ChainingGlShaderProgramListener;
import androidx.media3.effect.DefaultShaderProgram;
import androidx.media3.effect.ExternalTextureManager;
import androidx.media3.effect.GlMatrixTransformation;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.RgbMatrix;
import androidx.media3.effect.TexIdTextureManager;
import androidx.media3.effect.TextureManager;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class InputSwitcher {
    private final Context context;
    private final ColorInfo outputColorInfo;
    private final GlObjectsProvider glObjectsProvider;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    private final SparseArray<Input> inputs;
    private final boolean enableColorTransfers;
    private @MonotonicNonNull GlShaderProgram downstreamShaderProgram;
    private @MonotonicNonNull TextureManager activeTextureManager;

    public InputSwitcher(Context context, ColorInfo outputColorInfo, GlObjectsProvider glObjectsProvider, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor, boolean enableColorTransfers) {
        this.context = context;
        this.outputColorInfo = outputColorInfo;
        this.glObjectsProvider = glObjectsProvider;
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
        this.inputs = new SparseArray();
        this.enableColorTransfers = enableColorTransfers;
    }

    public void registerInput(ColorInfo inputColorInfo, int inputType) throws VideoFrameProcessingException {
        switch (inputType) {
            case 1: {
                DefaultShaderProgram samplingShaderProgram = DefaultShaderProgram.createWithExternalSampler(this.context, (List<GlMatrixTransformation>)ImmutableList.of(), (List<RgbMatrix>)ImmutableList.of(), inputColorInfo, this.outputColorInfo, this.enableColorTransfers);
                ExternalTextureManager textureManager = new ExternalTextureManager(this.glObjectsProvider, samplingShaderProgram, this.videoFrameProcessingTaskExecutor);
                this.inputs.put(inputType, (Object)new Input(textureManager, samplingShaderProgram));
                break;
            }
            case 2: {
                DefaultShaderProgram samplingShaderProgram = DefaultShaderProgram.createWithInternalSampler(this.context, (List<GlMatrixTransformation>)ImmutableList.of(), (List<RgbMatrix>)ImmutableList.of(), inputColorInfo, this.outputColorInfo, this.enableColorTransfers, inputType);
                BitmapTextureManager textureManager = new BitmapTextureManager(this.glObjectsProvider, samplingShaderProgram, this.videoFrameProcessingTaskExecutor);
                this.inputs.put(inputType, (Object)new Input(textureManager, samplingShaderProgram));
                break;
            }
            case 3: {
                DefaultShaderProgram samplingShaderProgram = DefaultShaderProgram.createWithInternalSampler(this.context, (List<GlMatrixTransformation>)ImmutableList.of(), (List<RgbMatrix>)ImmutableList.of(), inputColorInfo, this.outputColorInfo, this.enableColorTransfers, inputType);
                TexIdTextureManager textureManager = new TexIdTextureManager(this.glObjectsProvider, samplingShaderProgram, this.videoFrameProcessingTaskExecutor);
                this.inputs.put(inputType, (Object)new Input(textureManager, samplingShaderProgram));
                break;
            }
            default: {
                throw new VideoFrameProcessingException("Unsupported input type " + inputType);
            }
        }
    }

    public void setDownstreamShaderProgram(GlShaderProgram downstreamShaderProgram) {
        this.downstreamShaderProgram = downstreamShaderProgram;
    }

    public void switchToInput(int newInputType, FrameInfo inputFrameInfo) {
        Assertions.checkStateNotNull((Object)this.downstreamShaderProgram);
        Assertions.checkState((boolean)Util.containsKey(this.inputs, (int)newInputType), (Object)("Input type not registered: " + newInputType));
        for (int i = 0; i < this.inputs.size(); ++i) {
            int inputType = this.inputs.keyAt(i);
            Input input = (Input)this.inputs.get(inputType);
            if (inputType == newInputType) {
                input.setChainingListener(new GatedChainingListenerWrapper(this.glObjectsProvider, input.samplingGlShaderProgram, this.downstreamShaderProgram, this.videoFrameProcessingTaskExecutor));
                input.setActive(true);
                this.downstreamShaderProgram.setInputListener((GlShaderProgram.InputListener)Assertions.checkNotNull((Object)input.gatedChainingListenerWrapper));
                this.activeTextureManager = input.textureManager;
                continue;
            }
            input.setActive(false);
        }
        ((TextureManager)Assertions.checkNotNull((Object)this.activeTextureManager)).setInputFrameInfo(inputFrameInfo);
    }

    public TextureManager activeTextureManager() {
        return (TextureManager)Assertions.checkNotNull((Object)this.activeTextureManager);
    }

    public void signalEndOfCurrentInputStream() {
        ((TextureManager)Assertions.checkNotNull((Object)this.activeTextureManager)).signalEndOfCurrentInputStream();
    }

    public Surface getInputSurface() {
        Assertions.checkState((boolean)Util.containsKey(this.inputs, (int)1));
        return ((Input)this.inputs.get((int)1)).textureManager.getInputSurface();
    }

    public void release() throws VideoFrameProcessingException {
        for (int i = 0; i < this.inputs.size(); ++i) {
            ((Input)this.inputs.get(this.inputs.keyAt(i))).release();
        }
    }

    private static final class Input {
        public final TextureManager textureManager;
        public final GlShaderProgram samplingGlShaderProgram;
        private @MonotonicNonNull GatedChainingListenerWrapper gatedChainingListenerWrapper;

        public Input(TextureManager textureManager, GlShaderProgram samplingGlShaderProgram) {
            this.textureManager = textureManager;
            this.samplingGlShaderProgram = samplingGlShaderProgram;
            samplingGlShaderProgram.setInputListener(textureManager);
        }

        public void setChainingListener(GatedChainingListenerWrapper gatedChainingListenerWrapper) {
            this.gatedChainingListenerWrapper = gatedChainingListenerWrapper;
            this.samplingGlShaderProgram.setOutputListener(gatedChainingListenerWrapper);
        }

        public void setActive(boolean active) {
            if (this.gatedChainingListenerWrapper == null) {
                return;
            }
            this.gatedChainingListenerWrapper.setActive(active);
        }

        public void release() throws VideoFrameProcessingException {
            this.textureManager.release();
            this.samplingGlShaderProgram.release();
        }
    }

    private static final class GatedChainingListenerWrapper
    implements GlShaderProgram.OutputListener,
    GlShaderProgram.InputListener {
        private final ChainingGlShaderProgramListener chainingGlShaderProgramListener;
        private boolean isActive;

        public GatedChainingListenerWrapper(GlObjectsProvider glObjectsProvider, GlShaderProgram producingGlShaderProgram, GlShaderProgram consumingGlShaderProgram, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor) {
            this.chainingGlShaderProgramListener = new ChainingGlShaderProgramListener(glObjectsProvider, producingGlShaderProgram, consumingGlShaderProgram, videoFrameProcessingTaskExecutor);
        }

        @Override
        public void onReadyToAcceptInputFrame() {
            if (this.isActive) {
                this.chainingGlShaderProgramListener.onReadyToAcceptInputFrame();
            }
        }

        @Override
        public void onInputFrameProcessed(GlTextureInfo inputTexture) {
            if (this.isActive) {
                this.chainingGlShaderProgramListener.onInputFrameProcessed(inputTexture);
            }
        }

        @Override
        public synchronized void onFlush() {
            if (this.isActive) {
                this.chainingGlShaderProgramListener.onFlush();
            }
        }

        @Override
        public synchronized void onOutputFrameAvailable(GlTextureInfo outputTexture, long presentationTimeUs) {
            if (this.isActive) {
                this.chainingGlShaderProgramListener.onOutputFrameAvailable(outputTexture, presentationTimeUs);
            }
        }

        @Override
        public synchronized void onCurrentOutputStreamEnded() {
            if (this.isActive) {
                this.chainingGlShaderProgramListener.onCurrentOutputStreamEnded();
            }
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }
}

