/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.util.Pair;
import androidx.annotation.FloatRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class OverlaySettings {
    public final boolean useHdr;
    public final float alpha;
    public final Pair<Float, Float> videoFrameAnchor;
    public final Pair<Float, Float> overlayAnchor;
    public final Pair<Float, Float> scale;
    public final float rotationDegrees;

    private OverlaySettings(boolean useHdr, float alpha, Pair<Float, Float> videoFrameAnchor, Pair<Float, Float> overlayAnchor, Pair<Float, Float> scale, float rotationDegrees) {
        this.useHdr = useHdr;
        this.alpha = alpha;
        this.videoFrameAnchor = videoFrameAnchor;
        this.overlayAnchor = overlayAnchor;
        this.scale = scale;
        this.rotationDegrees = rotationDegrees;
    }

    public static final class Builder {
        private boolean useHdr;
        private float alpha = 1.0f;
        private Pair<Float, Float> videoFrameAnchor = Pair.create((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        private Pair<Float, Float> overlayAnchor = Pair.create((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        private Pair<Float, Float> scale = Pair.create((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
        private float rotationDegrees = 0.0f;

        @CanIgnoreReturnValue
        public Builder setUsesHdr(boolean useHdr) {
            this.useHdr = useHdr;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            Assertions.checkArgument((0.0f <= alpha && alpha <= 1.0f ? 1 : 0) != 0, (Object)"Alpha needs to be in the interval [0, 1].");
            this.alpha = alpha;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoFrameAnchor(@FloatRange(from=-1.0, to=1.0) float x, @FloatRange(from=-1.0, to=1.0) float y) {
            Assertions.checkArgument((-1.0f <= x && x <= 1.0f ? 1 : 0) != 0);
            Assertions.checkArgument((-1.0f <= y && y <= 1.0f ? 1 : 0) != 0);
            this.videoFrameAnchor = Pair.create((Object)Float.valueOf(x), (Object)Float.valueOf(y));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOverlayAnchor(@FloatRange(from=-1.0, to=1.0) float x, @FloatRange(from=-1.0, to=1.0) float y) {
            Assertions.checkArgument((-1.0f <= x && x <= 1.0f ? 1 : 0) != 0);
            Assertions.checkArgument((-1.0f <= y && y <= 1.0f ? 1 : 0) != 0);
            this.overlayAnchor = Pair.create((Object)Float.valueOf(x), (Object)Float.valueOf(y));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScale(float x, float y) {
            this.scale = Pair.create((Object)Float.valueOf(x), (Object)Float.valueOf(y));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRotationDegrees(float rotationDegree) {
            this.rotationDegrees = rotationDegree;
            return this;
        }

        public OverlaySettings build() {
            return new OverlaySettings(this.useHdr, this.alpha, this.videoFrameAnchor, this.overlayAnchor, this.scale, this.rotationDegrees);
        }
    }
}

