/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Pair;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.Util;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.TextureOverlay;
import com.google.common.collect.ImmutableList;

final class OverlayShaderProgram
extends BaseGlShaderProgram {
    private static final int MATRIX_OFFSET = 0;
    private final GlProgram glProgram;
    private final ImmutableList<TextureOverlay> overlays;
    private final float[] videoFrameAnchorMatrix;
    private final float[] videoFrameAnchorMatrixInv;
    private final float[] aspectRatioMatrix;
    private final float[] scaleMatrix;
    private final float[] scaleMatrixInv;
    private final float[] overlayAnchorMatrix;
    private final float[] overlayAnchorMatrixInv;
    private final float[] rotateMatrix;
    private final float[] overlayAspectRatioMatrix;
    private final float[] overlayAspectRatioMatrixInv;
    private final float[] transformationMatrix;
    private int videoWidth;
    private int videoHeight;

    public OverlayShaderProgram(Context context, boolean useHdr, ImmutableList<TextureOverlay> overlays) throws VideoFrameProcessingException {
        super(useHdr, 1);
        Assertions.checkArgument((!useHdr ? 1 : 0) != 0, (Object)"OverlayShaderProgram does not support HDR colors yet.");
        Assertions.checkArgument((overlays.size() <= 15 ? 1 : 0) != 0, (Object)"OverlayShaderProgram does not support more than 15 overlays in the same instance.");
        this.overlays = overlays;
        this.aspectRatioMatrix = GlUtil.create4x4IdentityMatrix();
        this.videoFrameAnchorMatrix = GlUtil.create4x4IdentityMatrix();
        this.videoFrameAnchorMatrixInv = GlUtil.create4x4IdentityMatrix();
        this.overlayAnchorMatrix = GlUtil.create4x4IdentityMatrix();
        this.overlayAnchorMatrixInv = GlUtil.create4x4IdentityMatrix();
        this.rotateMatrix = GlUtil.create4x4IdentityMatrix();
        this.scaleMatrix = GlUtil.create4x4IdentityMatrix();
        this.scaleMatrixInv = GlUtil.create4x4IdentityMatrix();
        this.overlayAspectRatioMatrix = GlUtil.create4x4IdentityMatrix();
        this.overlayAspectRatioMatrixInv = GlUtil.create4x4IdentityMatrix();
        this.transformationMatrix = GlUtil.create4x4IdentityMatrix();
        try {
            this.glProgram = new GlProgram(OverlayShaderProgram.createVertexShader(overlays.size()), OverlayShaderProgram.createFragmentShader(overlays.size()));
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
        this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        this.videoWidth = inputWidth;
        this.videoHeight = inputHeight;
        Size videoSize = new Size(inputWidth, inputHeight);
        for (TextureOverlay overlay : this.overlays) {
            overlay.configure(videoSize);
        }
        return videoSize;
    }

    @Override
    public void drawFrame(int inputTexId, long presentationTimeUs) throws VideoFrameProcessingException {
        try {
            this.glProgram.use();
            if (!this.overlays.isEmpty()) {
                for (int texUnitIndex = 1; texUnitIndex <= this.overlays.size(); ++texUnitIndex) {
                    TextureOverlay overlay = (TextureOverlay)this.overlays.get(texUnitIndex - 1);
                    this.glProgram.setSamplerTexIdUniform(Util.formatInvariant((String)"uOverlayTexSampler%d", (Object[])new Object[]{texUnitIndex}), overlay.getTextureId(presentationTimeUs), texUnitIndex);
                    GlUtil.setToIdentity((float[])this.aspectRatioMatrix);
                    GlUtil.setToIdentity((float[])this.videoFrameAnchorMatrix);
                    GlUtil.setToIdentity((float[])this.videoFrameAnchorMatrixInv);
                    GlUtil.setToIdentity((float[])this.overlayAnchorMatrix);
                    GlUtil.setToIdentity((float[])this.overlayAnchorMatrixInv);
                    GlUtil.setToIdentity((float[])this.scaleMatrix);
                    GlUtil.setToIdentity((float[])this.scaleMatrixInv);
                    GlUtil.setToIdentity((float[])this.rotateMatrix);
                    GlUtil.setToIdentity((float[])this.overlayAspectRatioMatrix);
                    GlUtil.setToIdentity((float[])this.overlayAspectRatioMatrixInv);
                    GlUtil.setToIdentity((float[])this.transformationMatrix);
                    Pair<Float, Float> videoFrameAnchor = overlay.getOverlaySettings((long)presentationTimeUs).videoFrameAnchor;
                    Matrix.translateM((float[])this.videoFrameAnchorMatrix, (int)0, (float)((Float)videoFrameAnchor.first).floatValue(), (float)((Float)videoFrameAnchor.second).floatValue(), (float)0.0f);
                    Matrix.invertM((float[])this.videoFrameAnchorMatrixInv, (int)0, (float[])this.videoFrameAnchorMatrix, (int)0);
                    Matrix.scaleM((float[])this.aspectRatioMatrix, (int)0, (float)((float)this.videoWidth / (float)overlay.getTextureSize(presentationTimeUs).getWidth()), (float)((float)this.videoHeight / (float)overlay.getTextureSize(presentationTimeUs).getHeight()), (float)1.0f);
                    Pair<Float, Float> scale = overlay.getOverlaySettings((long)presentationTimeUs).scale;
                    Matrix.scaleM((float[])this.scaleMatrix, (int)0, (float[])this.scaleMatrix, (int)0, (float)((Float)scale.first).floatValue(), (float)((Float)scale.second).floatValue(), (float)1.0f);
                    Matrix.invertM((float[])this.scaleMatrixInv, (int)0, (float[])this.scaleMatrix, (int)0);
                    Pair<Float, Float> overlayAnchor = overlay.getOverlaySettings((long)presentationTimeUs).overlayAnchor;
                    Matrix.translateM((float[])this.overlayAnchorMatrix, (int)0, (float)((Float)overlayAnchor.first).floatValue(), (float)((Float)overlayAnchor.second).floatValue(), (float)0.0f);
                    Matrix.invertM((float[])this.overlayAnchorMatrixInv, (int)0, (float[])this.overlayAnchorMatrix, (int)0);
                    Matrix.rotateM((float[])this.rotateMatrix, (int)0, (float[])this.rotateMatrix, (int)0, (float)overlay.getOverlaySettings((long)presentationTimeUs).rotationDegrees, (float)0.0f, (float)0.0f, (float)1.0f);
                    Matrix.invertM((float[])this.rotateMatrix, (int)0, (float[])this.rotateMatrix, (int)0);
                    Matrix.scaleM((float[])this.overlayAspectRatioMatrix, (int)0, (float)((float)overlay.getTextureSize(presentationTimeUs).getHeight() / (float)overlay.getTextureSize(presentationTimeUs).getWidth()), (float)1.0f, (float)1.0f);
                    Matrix.invertM((float[])this.overlayAspectRatioMatrixInv, (int)0, (float[])this.overlayAspectRatioMatrix, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.scaleMatrixInv, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.overlayAspectRatioMatrix, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.rotateMatrix, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.overlayAspectRatioMatrixInv, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.scaleMatrix, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.overlayAnchorMatrixInv, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.scaleMatrixInv, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.aspectRatioMatrix, (int)0);
                    Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.videoFrameAnchorMatrixInv, (int)0);
                    this.glProgram.setFloatsUniform(Util.formatInvariant((String)"uTransformationMatrix%d", (Object[])new Object[]{texUnitIndex}), this.transformationMatrix);
                    this.glProgram.setFloatUniform(Util.formatInvariant((String)"uOverlayAlpha%d", (Object[])new Object[]{texUnitIndex}), overlay.getOverlaySettings((long)presentationTimeUs).alpha);
                }
            }
            this.glProgram.setSamplerTexIdUniform("uVideoTexSampler0", inputTexId, 0);
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e, presentationTimeUs);
        }
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        super.release();
        try {
            this.glProgram.delete();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
        for (int i = 0; i < this.overlays.size(); ++i) {
            ((TextureOverlay)this.overlays.get(i)).release();
        }
    }

    private static String createVertexShader(int numOverlays) {
        int texUnitIndex;
        StringBuilder shader = new StringBuilder().append("#version 100\n").append("attribute vec4 aFramePosition;\n").append("varying vec2 vVideoTexSamplingCoord0;\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"uniform mat4 uTransformationMatrix%s;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"varying vec2 vOverlayTexSamplingCoord%s;\n", (Object[])new Object[]{texUnitIndex}));
        }
        shader.append("vec2 getTexSamplingCoord(vec2 ndcPosition){\n").append("  return vec2(ndcPosition.x * 0.5 + 0.5, ndcPosition.y * 0.5 + 0.5);\n").append("}\n").append("void main() {\n").append("  gl_Position = aFramePosition;\n").append("  vVideoTexSamplingCoord0 = getTexSamplingCoord(aFramePosition.xy);\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"  vec4 aOverlayPosition%d = \n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"  uTransformationMatrix%s * aFramePosition;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"  vOverlayTexSamplingCoord%d = getTexSamplingCoord(aOverlayPosition%d.xy);\n", (Object[])new Object[]{texUnitIndex, texUnitIndex}));
        }
        shader.append("}\n");
        return shader.toString();
    }

    private static String createFragmentShader(int numOverlays) {
        int texUnitIndex;
        StringBuilder shader = new StringBuilder().append("#version 100\n").append("precision mediump float;\n").append("uniform sampler2D uVideoTexSampler0;\n").append("varying vec2 vVideoTexSamplingCoord0;\n").append("// Manually implementing the CLAMP_TO_BORDER texture wrapping option\n").append("// (https://open.gl/textures) since it's not implemented until OpenGL ES 3.2.\n").append("vec4 getClampToBorderOverlayColor(\n").append("    sampler2D texSampler, vec2 texSamplingCoord, float alpha){\n").append("  if (texSamplingCoord.x > 1.0 || texSamplingCoord.x < 0.0\n").append("      || texSamplingCoord.y > 1.0 || texSamplingCoord.y < 0.0) {\n").append("    return vec4(0.0, 0.0, 0.0, 0.0);\n").append("  } else {\n").append("    vec4 overlayColor = vec4(texture2D(texSampler, texSamplingCoord));\n").append("    overlayColor.a = alpha * overlayColor.a;\n").append("    return overlayColor;\n").append("  }\n").append("}\n").append("\n").append("float getMixAlpha(float videoAlpha, float overlayAlpha) {\n").append("  if (videoAlpha == 0.0) {\n").append("    return 1.0;\n").append("  } else {\n").append("    return clamp(overlayAlpha/videoAlpha, 0.0, 1.0);\n").append("  }\n").append("}\n").append("").append("float srgbEotfSingleChannel(float srgb) {\n").append("  return srgb <= 0.04045 ? srgb / 12.92 : pow((srgb + 0.055) / 1.055, 2.4);\n").append("}\n").append("// sRGB EOTF.\n").append("vec3 applyEotf(const vec3 srgb) {\n").append("// Reference implementation:\n").append("// https://cs.android.com/android/platform/superproject/+/master:frameworks/native/libs/renderengine/gl/ProgramCache.cpp;drc=de09f10aa504fd8066370591a00c9ff1cafbb7fa;l=235\n").append("  return vec3(\n").append("    srgbEotfSingleChannel(srgb.r),\n").append("    srgbEotfSingleChannel(srgb.g),\n").append("    srgbEotfSingleChannel(srgb.b)\n").append("  );\n").append("}\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"uniform sampler2D uOverlayTexSampler%d;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"uniform float uOverlayAlpha%d;\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"varying vec2 vOverlayTexSamplingCoord%d;\n", (Object[])new Object[]{texUnitIndex}));
        }
        shader.append("void main() {\n").append("  vec4 videoColor = vec4(texture2D(uVideoTexSampler0, vVideoTexSamplingCoord0));\n").append("  vec4 fragColor = videoColor;\n");
        for (texUnitIndex = 1; texUnitIndex <= numOverlays; ++texUnitIndex) {
            shader.append(Util.formatInvariant((String)"  vec4 electricalOverlayColor%d = getClampToBorderOverlayColor(\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"    uOverlayTexSampler%d, vOverlayTexSamplingCoord%d, uOverlayAlpha%d);\n", (Object[])new Object[]{texUnitIndex, texUnitIndex, texUnitIndex})).append(Util.formatInvariant((String)"  vec4 opticalOverlayColor%d = vec4(\n", (Object[])new Object[]{texUnitIndex})).append(Util.formatInvariant((String)"    applyEotf(electricalOverlayColor%d.rgb), electricalOverlayColor%d.a);\n", (Object[])new Object[]{texUnitIndex, texUnitIndex})).append("  fragColor = mix(\n").append(Util.formatInvariant((String)"    fragColor, opticalOverlayColor%d, getMixAlpha(videoColor.a, opticalOverlayColor%d.a));\n", (Object[])new Object[]{texUnitIndex, texUnitIndex}));
        }
        shader.append("  gl_FragColor = fragColor;\n").append("}\n");
        return shader.toString();
    }
}

