/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.annotation.FloatRange;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.GlEffect;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.SpeedChangeShaderProgram;

@UnstableApi
public final class SpeedChangeEffect
implements GlEffect {
    private final float speed;

    public SpeedChangeEffect(@FloatRange(from=0.0, fromInclusive=false) float speed) {
        Assertions.checkArgument((speed > 0.0f ? 1 : 0) != 0);
        this.speed = speed;
    }

    @Override
    public GlShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        return new SpeedChangeShaderProgram(context, this.speed, useHdr);
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        return this.speed == 1.0f;
    }
}

