/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.SpannableString;
import android.text.StaticLayout;
import android.text.TextPaint;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.BitmapOverlay;
import androidx.media3.effect.OverlaySettings;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public abstract class TextOverlay
extends BitmapOverlay {
    public static final int TEXT_SIZE_PIXELS = 100;
    private @MonotonicNonNull Bitmap lastBitmap;
    private @MonotonicNonNull SpannableString lastText;

    public static TextOverlay createStaticTextOverlay(final SpannableString overlayText) {
        return new TextOverlay(){

            @Override
            public SpannableString getText(long presentationTimeUs) {
                return overlayText;
            }
        };
    }

    public static TextOverlay createStaticTextOverlay(final SpannableString overlayText, final OverlaySettings overlaySettings) {
        return new TextOverlay(){

            @Override
            public SpannableString getText(long presentationTimeUs) {
                return overlayText;
            }

            @Override
            public OverlaySettings getOverlaySettings(long presentationTimeUs) {
                return overlaySettings;
            }
        };
    }

    public abstract SpannableString getText(long var1);

    @Override
    public Bitmap getBitmap(long presentationTimeUs) {
        SpannableString overlayText = this.getText(presentationTimeUs);
        if (!overlayText.equals((Object)this.lastText)) {
            this.lastText = overlayText;
            TextPaint textPaint = new TextPaint();
            textPaint.setTextSize(100.0f);
            StaticLayout staticLayout = this.createStaticLayout(overlayText, textPaint, this.getSpannedTextWidth(overlayText, textPaint));
            this.lastBitmap = Bitmap.createBitmap((int)staticLayout.getWidth(), (int)staticLayout.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas((Bitmap)Assertions.checkNotNull((Object)this.lastBitmap));
            staticLayout.draw(canvas);
        }
        return (Bitmap)Assertions.checkNotNull((Object)this.lastBitmap);
    }

    private int getSpannedTextWidth(SpannableString text, TextPaint textPaint) {
        int measureTextWidth = (int)textPaint.measureText((CharSequence)text, 0, text.length());
        StaticLayout widthMeasuringLayout = this.createStaticLayout(text, textPaint, measureTextWidth);
        int lineCount = widthMeasuringLayout.getLineCount();
        float realTextWidth = 0.0f;
        for (int i = 0; i < lineCount; ++i) {
            realTextWidth += widthMeasuringLayout.getLineWidth(i);
        }
        return (int)Math.ceil(realTextWidth);
    }

    @SuppressLint(value={"InlinedApi"})
    private StaticLayout createStaticLayout(SpannableString text, TextPaint textPaint, int width) {
        return Util.SDK_INT >= 23 ? Api23.getStaticLayout(text, textPaint, width) : new StaticLayout((CharSequence)text, textPaint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
    }

    @RequiresApi(value=23)
    private static final class Api23 {
        private Api23() {
        }

        @DoNotInline
        public static StaticLayout getStaticLayout(SpannableString text, TextPaint textPaint, int width) {
            return StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)width).build();
        }
    }
}

