/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.FrameCache;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.TimestampWrapper;
import java.util.concurrent.Executor;

@UnstableApi
final class TimestampWrapperShaderProgram
implements GlShaderProgram {
    private final GlShaderProgram copyGlShaderProgram;
    private int pendingCopyGlShaderProgramFrames;
    private final GlShaderProgram wrappedGlShaderProgram;
    private int pendingWrappedGlShaderProgramFrames;
    private final long startTimeUs;
    private final long endTimeUs;

    public TimestampWrapperShaderProgram(Context context, boolean useHdr, TimestampWrapper timestampWrapper) throws VideoFrameProcessingException {
        this.copyGlShaderProgram = new FrameCache(1).toGlShaderProgram(context, useHdr);
        this.wrappedGlShaderProgram = timestampWrapper.glEffect.toGlShaderProgram(context, useHdr);
        this.startTimeUs = timestampWrapper.startTimeUs;
        this.endTimeUs = timestampWrapper.endTimeUs;
    }

    @Override
    public void setInputListener(GlShaderProgram.InputListener inputListener) {
        this.copyGlShaderProgram.setInputListener(inputListener);
        this.wrappedGlShaderProgram.setInputListener(inputListener);
    }

    @Override
    public void setOutputListener(GlShaderProgram.OutputListener outputListener) {
        this.copyGlShaderProgram.setOutputListener(outputListener);
        this.wrappedGlShaderProgram.setOutputListener(outputListener);
    }

    @Override
    public void setErrorListener(Executor errorListenerExecutor, GlShaderProgram.ErrorListener errorListener) {
        this.copyGlShaderProgram.setErrorListener(errorListenerExecutor, errorListener);
        this.wrappedGlShaderProgram.setErrorListener(errorListenerExecutor, errorListener);
    }

    @Override
    public void queueInputFrame(GlObjectsProvider glObjectsProvider, GlTextureInfo inputTexture, long presentationTimeUs) {
        if (presentationTimeUs >= this.startTimeUs && presentationTimeUs <= this.endTimeUs) {
            ++this.pendingWrappedGlShaderProgramFrames;
            this.wrappedGlShaderProgram.queueInputFrame(glObjectsProvider, inputTexture, presentationTimeUs);
        } else {
            ++this.pendingCopyGlShaderProgramFrames;
            this.copyGlShaderProgram.queueInputFrame(glObjectsProvider, inputTexture, presentationTimeUs);
        }
    }

    @Override
    public void releaseOutputFrame(GlTextureInfo outputTexture) {
        if (this.pendingCopyGlShaderProgramFrames > 0) {
            this.copyGlShaderProgram.releaseOutputFrame(outputTexture);
            --this.pendingCopyGlShaderProgramFrames;
        } else if (this.pendingWrappedGlShaderProgramFrames > 0) {
            this.wrappedGlShaderProgram.releaseOutputFrame(outputTexture);
            --this.pendingWrappedGlShaderProgramFrames;
        } else {
            throw new IllegalArgumentException("Output texture not contained in either shader.");
        }
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        this.wrappedGlShaderProgram.signalEndOfCurrentInputStream();
    }

    @Override
    public void flush() {
        this.copyGlShaderProgram.flush();
        this.wrappedGlShaderProgram.flush();
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        this.copyGlShaderProgram.release();
        this.wrappedGlShaderProgram.release();
    }
}

