/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import androidx.annotation.GuardedBy;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

@UnstableApi
final class VideoFrameProcessingTaskExecutor {
    private static final long RELEASE_WAIT_TIME_MS = 500L;
    private final boolean shouldShutdownExecutorService;
    private final ExecutorService singleThreadExecutorService;
    private final ErrorListener errorListener;
    private final Object lock;
    @GuardedBy(value="lock")
    private final Queue<Task> highPriorityTasks;
    @GuardedBy(value="lock")
    private boolean shouldCancelTasks;

    public VideoFrameProcessingTaskExecutor(ExecutorService singleThreadExecutorService, boolean shouldShutdownExecutorService, ErrorListener errorListener) {
        this.singleThreadExecutorService = singleThreadExecutorService;
        this.shouldShutdownExecutorService = shouldShutdownExecutorService;
        this.errorListener = errorListener;
        this.lock = new Object();
        this.highPriorityTasks = new ArrayDeque<Task>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Task task) {
        RejectedExecutionException executionException = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldCancelTasks) {
                return;
            }
            try {
                this.wrapTaskAndSubmitToExecutorService(task, false);
            }
            catch (RejectedExecutionException e) {
                executionException = e;
            }
        }
        if (executionException != null) {
            this.handleException(executionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitAndBlock(Task task) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldCancelTasks) {
                return;
            }
        }
        Future<?> future = this.wrapTaskAndSubmitToExecutorService(task, false);
        try {
            future.get();
        }
        catch (ExecutionException e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitWithHighPriority(Task task) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldCancelTasks) {
                return;
            }
            this.highPriorityTasks.add(task);
        }
        this.submit(() -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.shouldCancelTasks = true;
            this.highPriorityTasks.clear();
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.wrapTaskAndSubmitToExecutorService(() -> {
            Object object = this.lock;
            synchronized (object) {
                this.shouldCancelTasks = false;
            }
            latch.countDown();
        }, true);
        latch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Task releaseTask) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.shouldCancelTasks = true;
            this.highPriorityTasks.clear();
        }
        Future<?> unused = this.wrapTaskAndSubmitToExecutorService(releaseTask, true);
        if (this.shouldShutdownExecutorService) {
            this.singleThreadExecutorService.shutdown();
            if (!this.singleThreadExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.errorListener.onError(new VideoFrameProcessingException("Release timed out. OpenGL resources may not be cleaned up properly."));
            }
        }
    }

    private Future<?> wrapTaskAndSubmitToExecutorService(Task defaultPriorityTask, boolean isFlushOrReleaseTask) {
        return this.singleThreadExecutorService.submit(() -> {
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.shouldCancelTasks && !isFlushOrReleaseTask) {
                        return;
                    }
                }
                while (true) {
                    Task nextHighPriorityTask;
                    Object object2 = this.lock;
                    synchronized (object2) {
                        nextHighPriorityTask = this.highPriorityTasks.poll();
                    }
                    if (nextHighPriorityTask == null) break;
                    nextHighPriorityTask.run();
                }
                defaultPriorityTask.run();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception exception) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldCancelTasks) {
                return;
            }
            this.shouldCancelTasks = true;
        }
        this.errorListener.onError(VideoFrameProcessingException.from((Exception)exception));
    }

    static interface ErrorListener {
        public void onError(VideoFrameProcessingException var1);
    }

    static interface Task {
        public void run() throws VideoFrameProcessingException, GlUtil.GlException;
    }
}

