/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import androidx.annotation.CallSuper;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.TexturePool;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;

@UnstableApi
public abstract class BaseGlShaderProgram
implements GlShaderProgram {
    protected final TexturePool outputTexturePool;
    private GlShaderProgram.InputListener inputListener;
    private GlShaderProgram.OutputListener outputListener;
    private GlShaderProgram.ErrorListener errorListener;
    private Executor errorListenerExecutor;
    private int inputWidth;
    private int inputHeight;

    public BaseGlShaderProgram(boolean useHighPrecisionColorComponents, int texturePoolCapacity) {
        this.outputTexturePool = new TexturePool(useHighPrecisionColorComponents, texturePoolCapacity);
        this.inputListener = new GlShaderProgram.InputListener(){};
        this.outputListener = new GlShaderProgram.OutputListener(){};
        this.errorListener = frameProcessingException -> {};
        this.errorListenerExecutor = MoreExecutors.directExecutor();
        this.inputWidth = -1;
        this.inputHeight = -1;
    }

    public abstract Size configure(int var1, int var2) throws VideoFrameProcessingException;

    public abstract void drawFrame(int var1, long var2) throws VideoFrameProcessingException;

    @Override
    public void setInputListener(GlShaderProgram.InputListener inputListener) {
        this.inputListener = inputListener;
        for (int i = 0; i < this.outputTexturePool.freeTextureCount(); ++i) {
            inputListener.onReadyToAcceptInputFrame();
        }
    }

    @Override
    public void setOutputListener(GlShaderProgram.OutputListener outputListener) {
        this.outputListener = outputListener;
    }

    @Override
    public void setErrorListener(Executor errorListenerExecutor, GlShaderProgram.ErrorListener errorListener) {
        this.errorListenerExecutor = errorListenerExecutor;
        this.errorListener = errorListener;
    }

    public boolean shouldClearTextureBuffer() {
        return true;
    }

    @Override
    public void queueInputFrame(GlObjectsProvider glObjectsProvider, GlTextureInfo inputTexture, long presentationTimeUs) {
        try {
            if (this.inputWidth != inputTexture.width || this.inputHeight != inputTexture.height || !this.outputTexturePool.isConfigured()) {
                this.inputWidth = inputTexture.width;
                this.inputHeight = inputTexture.height;
                Size outputTextureSize = this.configure(inputTexture.width, inputTexture.height);
                this.outputTexturePool.ensureConfigured(glObjectsProvider, outputTextureSize.getWidth(), outputTextureSize.getHeight());
            }
            GlTextureInfo outputTexture = this.outputTexturePool.useTexture();
            GlUtil.focusFramebufferUsingCurrentContext((int)outputTexture.fboId, (int)outputTexture.width, (int)outputTexture.height);
            if (this.shouldClearTextureBuffer()) {
                GlUtil.clearFocusedBuffers();
            }
            this.drawFrame(inputTexture.texId, presentationTimeUs);
            this.inputListener.onInputFrameProcessed(inputTexture);
            this.outputListener.onOutputFrameAvailable(outputTexture, presentationTimeUs);
        }
        catch (VideoFrameProcessingException | GlUtil.GlException | NoSuchElementException e) {
            this.errorListenerExecutor.execute(() -> this.lambda$queueInputFrame$1((Exception)e));
        }
    }

    @Override
    public void releaseOutputFrame(GlTextureInfo outputTexture) {
        this.outputTexturePool.freeTexture(outputTexture);
        this.inputListener.onReadyToAcceptInputFrame();
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        this.outputListener.onCurrentOutputStreamEnded();
    }

    @Override
    @CallSuper
    public void flush() {
        this.outputTexturePool.freeAllTextures();
        this.inputListener.onFlush();
        for (int i = 0; i < this.outputTexturePool.capacity(); ++i) {
            this.inputListener.onReadyToAcceptInputFrame();
        }
    }

    @Override
    @CallSuper
    public void release() throws VideoFrameProcessingException {
        try {
            this.outputTexturePool.deleteAllTextures();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }

    protected final GlShaderProgram.InputListener getInputListener() {
        return this.inputListener;
    }

    protected final GlShaderProgram.OutputListener getOutputListener() {
        return this.outputListener;
    }

    protected final void onError(Exception e) {
        this.errorListenerExecutor.execute(() -> this.errorListener.onError(VideoFrameProcessingException.from((Exception)e)));
    }

    private /* synthetic */ void lambda$queueInputFrame$1(Exception e) {
        this.errorListener.onError(VideoFrameProcessingException.from((Exception)e));
    }
}

