/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSourceBitmapLoader;
import androidx.media3.effect.BitmapUtil;
import androidx.media3.effect.OverlaySettings;
import androidx.media3.effect.TextureOverlay;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@UnstableApi
public abstract class BitmapOverlay
extends TextureOverlay {
    private int lastTextureId = -1;
    private @Nullable Bitmap lastBitmap;

    BitmapOverlay() {
    }

    public abstract Bitmap getBitmap(long var1) throws VideoFrameProcessingException;

    @Override
    public Size getTextureSize(long presentationTimeUs) {
        return new Size(((Bitmap)Assertions.checkNotNull((Object)this.lastBitmap)).getWidth(), ((Bitmap)Assertions.checkNotNull((Object)this.lastBitmap)).getHeight());
    }

    @Override
    public int getTextureId(long presentationTimeUs) throws VideoFrameProcessingException {
        Bitmap bitmap = this.getBitmap(presentationTimeUs);
        if (bitmap != this.lastBitmap) {
            try {
                this.lastBitmap = bitmap;
                if (this.lastTextureId != -1) {
                    GlUtil.deleteTexture((int)this.lastTextureId);
                }
                this.lastTextureId = GlUtil.createTexture((int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)false);
                GLES20.glBindTexture((int)3553, (int)this.lastTextureId);
                GLUtils.texImage2D((int)3553, (int)0, (Bitmap)BitmapUtil.flipBitmapVertically((Bitmap)Assertions.checkNotNull((Object)this.lastBitmap)), (int)0);
                GlUtil.checkGlError();
            }
            catch (GlUtil.GlException e) {
                throw new VideoFrameProcessingException((Throwable)e);
            }
        }
        return this.lastTextureId;
    }

    public static BitmapOverlay createStaticBitmapOverlay(final Bitmap overlayBitmap) {
        return new BitmapOverlay(){

            @Override
            public Bitmap getBitmap(long presentationTimeUs) {
                return overlayBitmap;
            }
        };
    }

    public static BitmapOverlay createStaticBitmapOverlay(final Bitmap overlayBitmap, final OverlaySettings overlaySettings) {
        return new BitmapOverlay(){

            @Override
            public Bitmap getBitmap(long presentationTimeUs) {
                return overlayBitmap;
            }

            @Override
            public OverlaySettings getOverlaySettings(long presentationTimeUs) {
                return overlaySettings;
            }
        };
    }

    public static BitmapOverlay createStaticBitmapOverlay(final Context context, final Uri overlayBitmapUri, final OverlaySettings overlaySettings) {
        return new BitmapOverlay(){
            private @MonotonicNonNull Bitmap lastBitmap;

            @Override
            public Bitmap getBitmap(long presentationTimeUs) throws VideoFrameProcessingException {
                if (this.lastBitmap == null) {
                    DataSourceBitmapLoader bitmapLoader = new DataSourceBitmapLoader(context);
                    ListenableFuture future = bitmapLoader.loadBitmap(overlayBitmapUri);
                    try {
                        this.lastBitmap = (Bitmap)future.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new VideoFrameProcessingException((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        throw new VideoFrameProcessingException((Throwable)e);
                    }
                }
                return this.lastBitmap;
            }

            @Override
            public OverlaySettings getOverlaySettings(long presentationTimeUs) {
                return overlaySettings;
            }
        };
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        super.release();
        this.lastBitmap = null;
        if (this.lastTextureId != -1) {
            try {
                GlUtil.deleteTexture((int)this.lastTextureId);
            }
            catch (GlUtil.GlException e) {
                throw new VideoFrameProcessingException((Throwable)e);
            }
        }
        this.lastTextureId = -1;
    }
}

