/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.TimestampIterator;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.DebugTraceUtil;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.TextureManager;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
final class BitmapTextureManager
implements TextureManager {
    private static final String UNSUPPORTED_IMAGE_CONFIGURATION = "Unsupported Image Configuration: No more than 8 bits of precision should be used for each RGB channel.";
    private final GlObjectsProvider glObjectsProvider;
    private final GlShaderProgram shaderProgram;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    private final Queue<BitmapFrameSequenceInfo> pendingBitmaps;
    private @MonotonicNonNull GlTextureInfo currentGlTextureInfo;
    private int downstreamShaderProgramCapacity;
    private boolean useHdr;
    private boolean currentInputStreamEnded;
    private boolean isNextFrameInTexture;

    public BitmapTextureManager(GlObjectsProvider glObjectsProvider, GlShaderProgram shaderProgram, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor) {
        this.glObjectsProvider = glObjectsProvider;
        this.shaderProgram = shaderProgram;
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
        this.pendingBitmaps = new LinkedBlockingQueue<BitmapFrameSequenceInfo>();
    }

    @Override
    public void onReadyToAcceptInputFrame() {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            ++this.downstreamShaderProgramCapacity;
            this.maybeQueueToShaderProgram();
        });
    }

    @Override
    public void queueInputBitmap(Bitmap inputBitmap, FrameInfo frameInfo, TimestampIterator inStreamOffsetsUs, boolean useHdr) {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            this.setupBitmap(inputBitmap, frameInfo, inStreamOffsetsUs, useHdr);
            this.currentInputStreamEnded = false;
        });
    }

    @Override
    public int getPendingFrameCount() {
        return 0;
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            if (this.pendingBitmaps.isEmpty()) {
                this.shaderProgram.signalEndOfCurrentInputStream();
                DebugTraceUtil.logEvent("BitmapTextureManager-SignalEOS", Long.MIN_VALUE);
            } else {
                this.currentInputStreamEnded = true;
            }
        });
    }

    @Override
    public void setOnFlushCompleteListener(@Nullable VideoFrameProcessingTaskExecutor.Task task) {
    }

    @Override
    public void release() {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            if (this.currentGlTextureInfo != null) {
                this.currentGlTextureInfo.release();
            }
        });
    }

    private void setupBitmap(Bitmap bitmap, FrameInfo frameInfo, TimestampIterator inStreamOffsetsUs, boolean useHdr) throws VideoFrameProcessingException {
        if (Util.SDK_INT >= 26) {
            Assertions.checkState((!bitmap.getConfig().equals((Object)Bitmap.Config.RGBA_F16) ? 1 : 0) != 0, (Object)UNSUPPORTED_IMAGE_CONFIGURATION);
        }
        if (Util.SDK_INT >= 33) {
            Assertions.checkState((!bitmap.getConfig().equals((Object)Bitmap.Config.RGBA_1010102) ? 1 : 0) != 0, (Object)UNSUPPORTED_IMAGE_CONFIGURATION);
        }
        this.useHdr = useHdr;
        Assertions.checkArgument((boolean)inStreamOffsetsUs.hasNext(), (Object)"Bitmap queued but no timestamps provided.");
        this.pendingBitmaps.add(new BitmapFrameSequenceInfo(bitmap, frameInfo, inStreamOffsetsUs));
        this.maybeQueueToShaderProgram();
    }

    private void maybeQueueToShaderProgram() throws VideoFrameProcessingException {
        if (this.pendingBitmaps.isEmpty() || this.downstreamShaderProgramCapacity == 0) {
            return;
        }
        BitmapFrameSequenceInfo currentBitmapInfo = (BitmapFrameSequenceInfo)Assertions.checkNotNull((Object)this.pendingBitmaps.peek());
        FrameInfo currentFrameInfo = currentBitmapInfo.frameInfo;
        TimestampIterator inStreamOffsetsUs = currentBitmapInfo.inStreamOffsetsUs;
        Assertions.checkState((boolean)currentBitmapInfo.inStreamOffsetsUs.hasNext());
        long currentPresentationTimeUs = ((BitmapFrameSequenceInfo)currentBitmapInfo).frameInfo.offsetToAddUs + inStreamOffsetsUs.next();
        if (!this.isNextFrameInTexture) {
            this.isNextFrameInTexture = true;
            this.updateCurrentGlTextureInfo(currentFrameInfo, currentBitmapInfo.bitmap);
        }
        --this.downstreamShaderProgramCapacity;
        this.shaderProgram.queueInputFrame(this.glObjectsProvider, (GlTextureInfo)Assertions.checkNotNull((Object)this.currentGlTextureInfo), currentPresentationTimeUs);
        DebugTraceUtil.logEvent("VFP-QueueBitmap", currentPresentationTimeUs, currentFrameInfo.width + "x" + currentFrameInfo.height);
        if (!currentBitmapInfo.inStreamOffsetsUs.hasNext()) {
            this.isNextFrameInTexture = false;
            this.pendingBitmaps.remove();
            if (this.pendingBitmaps.isEmpty() && this.currentInputStreamEnded) {
                this.shaderProgram.signalEndOfCurrentInputStream();
                DebugTraceUtil.logEvent("BitmapTextureManager-SignalEOS", Long.MIN_VALUE);
                this.currentInputStreamEnded = false;
            }
        }
    }

    private void updateCurrentGlTextureInfo(FrameInfo frameInfo, Bitmap bitmap) throws VideoFrameProcessingException {
        int currentTexId;
        try {
            if (this.currentGlTextureInfo != null) {
                this.currentGlTextureInfo.release();
            }
            currentTexId = GlUtil.createTexture((int)frameInfo.width, (int)frameInfo.height, (boolean)this.useHdr);
            GLES20.glBindTexture((int)3553, (int)currentTexId);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            throw VideoFrameProcessingException.from((Exception)((Object)e));
        }
        this.currentGlTextureInfo = new GlTextureInfo(currentTexId, -1, -1, frameInfo.width, frameInfo.height);
    }

    private static final class BitmapFrameSequenceInfo {
        public final Bitmap bitmap;
        private final FrameInfo frameInfo;
        private final TimestampIterator inStreamOffsetsUs;

        public BitmapFrameSequenceInfo(Bitmap bitmap, FrameInfo frameInfo, TimestampIterator inStreamOffsetsUs) {
            this.bitmap = bitmap;
            this.frameInfo = frameInfo;
            this.inStreamOffsetsUs = inStreamOffsetsUs;
        }
    }
}

