/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.effect.FrameConsumptionManager;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;

final class ChainingGlShaderProgramListener
implements GlShaderProgram.InputListener,
GlShaderProgram.OutputListener {
    private final GlShaderProgram producingGlShaderProgram;
    private final FrameConsumptionManager frameConsumptionManager;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;

    public ChainingGlShaderProgramListener(GlObjectsProvider glObjectsProvider, GlShaderProgram producingGlShaderProgram, GlShaderProgram consumingGlShaderProgram, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor) {
        this.producingGlShaderProgram = producingGlShaderProgram;
        this.frameConsumptionManager = new FrameConsumptionManager(glObjectsProvider, consumingGlShaderProgram, videoFrameProcessingTaskExecutor);
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
    }

    @Override
    public synchronized void onReadyToAcceptInputFrame() {
        this.frameConsumptionManager.onReadyToAcceptInputFrame();
    }

    @Override
    public void onInputFrameProcessed(GlTextureInfo inputTexture) {
        this.videoFrameProcessingTaskExecutor.submit(() -> this.producingGlShaderProgram.releaseOutputFrame(inputTexture));
    }

    @Override
    public synchronized void onFlush() {
        this.frameConsumptionManager.onFlush();
        this.videoFrameProcessingTaskExecutor.submit(this.producingGlShaderProgram::flush);
    }

    @Override
    public synchronized void onOutputFrameAvailable(GlTextureInfo outputTexture, long presentationTimeUs) {
        this.frameConsumptionManager.queueInputFrame(outputTexture, presentationTimeUs);
    }

    @Override
    public synchronized void onCurrentOutputStreamEnded() {
        this.frameConsumptionManager.signalEndOfCurrentStream();
    }
}

