/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.graphics.Matrix;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.MatrixTransformation;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class Crop
implements MatrixTransformation {
    private final float left;
    private final float right;
    private final float bottom;
    private final float top;
    private @MonotonicNonNull Matrix transformationMatrix;

    public Crop(float left, float right, float bottom, float top) {
        Assertions.checkArgument((right > left ? 1 : 0) != 0, (Object)("right value " + right + " should be greater than left value " + left));
        Assertions.checkArgument((top > bottom ? 1 : 0) != 0, (Object)("top value " + top + " should be greater than bottom value " + bottom));
        this.left = left;
        this.right = right;
        this.bottom = bottom;
        this.top = top;
        this.transformationMatrix = new Matrix();
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        this.transformationMatrix = new Matrix();
        if (this.left == -1.0f && this.right == 1.0f && this.bottom == -1.0f && this.top == 1.0f) {
            return new Size(inputWidth, inputHeight);
        }
        float scaleX = (this.right - this.left) / 2.0f;
        float scaleY = (this.top - this.bottom) / 2.0f;
        float centerX = (this.left + this.right) / 2.0f;
        float centerY = (this.bottom + this.top) / 2.0f;
        this.transformationMatrix.postTranslate(-centerX, -centerY);
        this.transformationMatrix.postScale(1.0f / scaleX, 1.0f / scaleY);
        int outputWidth = Math.round((float)inputWidth * scaleX);
        int outputHeight = Math.round((float)inputHeight * scaleY);
        return new Size(outputWidth, outputHeight);
    }

    @Override
    public Matrix getMatrix(long presentationTimeUs) {
        return (Matrix)Assertions.checkStateNotNull((Object)this.transformationMatrix, (Object)"configure must be called first");
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        Size outputSize = this.configure(inputWidth, inputHeight);
        return ((Matrix)Assertions.checkStateNotNull((Object)this.transformationMatrix)).isIdentity() && inputWidth == outputSize.getWidth() && inputHeight == outputSize.getHeight();
    }
}

