/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.SystemClock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;

@UnstableApi
public final class DebugTraceUtil {
    public static final String EVENT_VIDEO_INPUT_FORMAT = "VideoInputFormat";
    public static final String EVENT_DECODER_DECODED_FRAME = "Decoder-DecodedFrame";
    public static final String EVENT_VFP_REGISTER_NEW_INPUT_STREAM = "VFP-RegisterNewInputStream";
    public static final String EVENT_VFP_SURFACE_TEXTURE_INPUT = "VFP-SurfaceTextureInput";
    public static final String EVENT_VFP_QUEUE_FRAME = "VFP-QueueFrame";
    public static final String EVENT_VFP_QUEUE_BITMAP = "VFP-QueueBitmap";
    public static final String EVENT_VFP_QUEUE_TEXTURE = "VFP-QueueTexture";
    public static final String EVENT_VFP_RENDERED_TO_OUTPUT_SURFACE = "VFP-RenderedToOutputSurface";
    public static final String EVENT_VFP_OUTPUT_TEXTURE_RENDERED = "VFP-OutputTextureRendered";
    public static final String EVENT_VFP_FINISH_PROCESSING_INPUT_STREAM = "VFP-FinishOneInputStream";
    public static final String EVENT_COMPOSITOR_OUTPUT_TEXTURE_RENDERED = "COMP-OutputTextureRendered";
    public static final String EVENT_ENCODER_ENCODED_FRAME = "Encoder-EncodedFrame";
    public static final String EVENT_MUXER_CAN_WRITE_SAMPLE_VIDEO = "Muxer-CanWriteSample_Video";
    public static final String EVENT_MUXER_WRITE_SAMPLE_VIDEO = "Muxer-WriteSample_Video";
    public static final String EVENT_MUXER_CAN_WRITE_SAMPLE_AUDIO = "Muxer-CanWriteSample_Audio";
    public static final String EVENT_MUXER_WRITE_SAMPLE_AUDIO = "Muxer-WriteSample_Audio";
    public static final String EVENT_DECODER_RECEIVE_EOS = "Decoder-ReceiveEOS";
    public static final String EVENT_DECODER_SIGNAL_EOS = "Decoder-SignalEOS";
    public static final String EVENT_VFP_RECEIVE_END_OF_INPUT = "VFP-ReceiveEndOfAllInput";
    public static final String EVENT_EXTERNAL_TEXTURE_MANAGER_SIGNAL_EOS = "ExternalTextureManager-SignalEOS";
    public static final String EVENT_BITMAP_TEXTURE_MANAGER_SIGNAL_EOS = "BitmapTextureManager-SignalEOS";
    public static final String EVENT_TEX_ID_TEXTURE_MANAGER_SIGNAL_EOS = "TexIdTextureManager-SignalEOS";
    public static final String EVENT_VFP_SIGNAL_ENDED = "VFP-SignalEnded";
    public static final String EVENT_ENCODER_RECEIVE_EOS = "Encoder-ReceiveEOS";
    public static final String EVENT_MUXER_TRACK_ENDED_AUDIO = "Muxer-TrackEnded_Audio";
    public static final String EVENT_MUXER_TRACK_ENDED_VIDEO = "Muxer-TrackEnded_Video";
    private static final ImmutableList<String> EVENT_TYPES = ImmutableList.of((Object)"VideoInputFormat", (Object)"Decoder-DecodedFrame", (Object)"VFP-RegisterNewInputStream", (Object)"VFP-SurfaceTextureInput", (Object)"VFP-QueueFrame", (Object)"VFP-QueueBitmap", (Object)"VFP-QueueTexture", (Object)"VFP-RenderedToOutputSurface", (Object)"VFP-OutputTextureRendered", (Object)"VFP-FinishOneInputStream", (Object)"COMP-OutputTextureRendered", (Object)"Encoder-EncodedFrame", (Object[])new String[]{"Muxer-CanWriteSample_Video", "Muxer-WriteSample_Video", "Muxer-CanWriteSample_Audio", "Muxer-WriteSample_Audio", "Decoder-ReceiveEOS", "Decoder-SignalEOS", "VFP-ReceiveEndOfAllInput", "ExternalTextureManager-SignalEOS", "BitmapTextureManager-SignalEOS", "TexIdTextureManager-SignalEOS", "VFP-SignalEnded", "Encoder-ReceiveEOS", "Muxer-TrackEnded_Audio", "Muxer-TrackEnded_Video"});
    private static final int MAX_FIRST_LAST_LOGS = 10;
    @GuardedBy(value="DebugTraceUtil.class")
    private static final Map<String, EventLogger> events = new LinkedHashMap<String, EventLogger>();
    @GuardedBy(value="DebugTraceUtil.class")
    private static long startTimeMs = SystemClock.DEFAULT.elapsedRealtime();

    public static synchronized void reset() {
        events.clear();
        startTimeMs = SystemClock.DEFAULT.elapsedRealtime();
    }

    public static synchronized void logEvent(String eventName, long presentationTimeUs, @Nullable String extra) {
        long eventTimeMs = SystemClock.DEFAULT.elapsedRealtime() - startTimeMs;
        if (!events.containsKey(eventName)) {
            events.put(eventName, new EventLogger());
        }
        EventLogger logger = events.get(eventName);
        logger.addLog(new EventLog(presentationTimeUs, eventTimeMs, extra));
    }

    public static synchronized void logEvent(String eventName, long presentationTimeUs) {
        DebugTraceUtil.logEvent(eventName, presentationTimeUs, null);
    }

    public static synchronized String generateTraceSummary() {
        StringBuilder stringBuilder = new StringBuilder().append('{');
        for (int i = 0; i < EVENT_TYPES.size(); ++i) {
            String eventType = (String)EVENT_TYPES.get(i);
            if (!events.containsKey(eventType)) {
                stringBuilder.append(Util.formatInvariant((String)"\"%s\": \"No events logged\",", (Object[])new Object[]{eventType}));
                continue;
            }
            stringBuilder.append(Util.formatInvariant((String)"\"%s\":{", (Object[])new Object[]{eventType})).append(Assertions.checkNotNull((Object)events.get(eventType))).append("},");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static synchronized void dumpTsv(Writer writer) throws IOException {
        writer.write("event\ttimestamp\tpresentation\textra\n");
        for (Map.Entry<String, EventLogger> entry : events.entrySet()) {
            ImmutableList<EventLog> eventLogs = entry.getValue().getLogs();
            for (int i = 0; i < eventLogs.size(); ++i) {
                EventLog eventLog = (EventLog)eventLogs.get(i);
                writer.write(Util.formatInvariant((String)"%s\t%d\t%s\t%s\n", (Object[])new Object[]{entry.getKey(), eventLog.eventTimeMs, DebugTraceUtil.presentationTimeToString(eventLog.presentationTimeUs), Strings.nullToEmpty((String)eventLog.extra)}));
            }
        }
    }

    private static String presentationTimeToString(long presentationTimeUs) {
        if (presentationTimeUs == -9223372036854775807L) {
            return "UNSET";
        }
        if (presentationTimeUs == Long.MIN_VALUE) {
            return "EOS";
        }
        return String.valueOf(presentationTimeUs);
    }

    private static final class EventLogger {
        private final List<EventLog> firstLogs = new ArrayList<EventLog>(10);
        private final Queue<EventLog> lastLogs = new ArrayDeque<EventLog>(10);
        private int totalCount = 0;

        public void addLog(EventLog log) {
            if (this.firstLogs.size() < 10) {
                this.firstLogs.add(log);
            } else {
                this.lastLogs.add(log);
                if (this.lastLogs.size() > 10) {
                    this.lastLogs.remove();
                }
            }
            ++this.totalCount;
        }

        public ImmutableList<EventLog> getLogs() {
            return new ImmutableList.Builder().addAll(this.firstLogs).addAll(this.lastLogs).build();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("\"Count\": ").append(this.totalCount).append(", \"first\":[");
            for (int i = 0; i < this.firstLogs.size(); ++i) {
                stringBuilder.append(this.firstLogs.get(i)).append(",");
            }
            stringBuilder.append("],");
            if (this.lastLogs.isEmpty()) {
                return stringBuilder.toString();
            }
            ImmutableList lastLogsList = ImmutableList.copyOf(this.lastLogs);
            stringBuilder.append("\"last\":[");
            for (int i = 0; i < lastLogsList.size(); ++i) {
                stringBuilder.append(lastLogsList.get(i)).append(",");
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static final class EventLog {
        public final long presentationTimeUs;
        public final long eventTimeMs;
        @Nullable
        public final String extra;

        private EventLog(long presentationTimeUs, long eventTimeMs, @Nullable String extra) {
            this.presentationTimeUs = presentationTimeUs;
            this.eventTimeMs = eventTimeMs;
            this.extra = extra;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Util.formatInvariant((String)"\"%s@%d", (Object[])new Object[]{DebugTraceUtil.presentationTimeToString(this.presentationTimeUs), this.eventTimeMs}));
            if (this.extra != null) {
                stringBuilder.append(Util.formatInvariant((String)"(%s)", (Object[])new Object[]{this.extra}));
            }
            return stringBuilder.append('\"').toString();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface DebugTraceEvent {
    }
}

