/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.ExternalShaderProgram;
import androidx.media3.effect.GlMatrixTransformation;
import androidx.media3.effect.MatrixUtils;
import androidx.media3.effect.RgbMatrix;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@UnstableApi
final class DefaultShaderProgram
extends BaseGlShaderProgram
implements ExternalShaderProgram {
    private static final String VERTEX_SHADER_TRANSFORMATION_PATH = "shaders/vertex_shader_transformation_es2.glsl";
    private static final String VERTEX_SHADER_TRANSFORMATION_ES3_PATH = "shaders/vertex_shader_transformation_es3.glsl";
    private static final String FRAGMENT_SHADER_TRANSFORMATION_PATH = "shaders/fragment_shader_transformation_es2.glsl";
    private static final String FRAGMENT_SHADER_OETF_ES3_PATH = "shaders/fragment_shader_oetf_es3.glsl";
    private static final String FRAGMENT_SHADER_TRANSFORMATION_SDR_OETF_ES2_PATH = "shaders/fragment_shader_transformation_sdr_oetf_es2.glsl";
    private static final String FRAGMENT_SHADER_TRANSFORMATION_EXTERNAL_YUV_ES3_PATH = "shaders/fragment_shader_transformation_external_yuv_es3.glsl";
    private static final String FRAGMENT_SHADER_TRANSFORMATION_SDR_EXTERNAL_PATH = "shaders/fragment_shader_transformation_sdr_external_es2.glsl";
    private static final String FRAGMENT_SHADER_TRANSFORMATION_HDR_INTERNAL_ES3_PATH = "shaders/fragment_shader_transformation_hdr_internal_es3.glsl";
    private static final String FRAGMENT_SHADER_TRANSFORMATION_SDR_INTERNAL_PATH = "shaders/fragment_shader_transformation_sdr_internal_es2.glsl";
    private static final ImmutableList<float[]> NDC_SQUARE = ImmutableList.of((Object)new float[]{-1.0f, -1.0f, 0.0f, 1.0f}, (Object)new float[]{-1.0f, 1.0f, 0.0f, 1.0f}, (Object)new float[]{1.0f, 1.0f, 0.0f, 1.0f}, (Object)new float[]{1.0f, -1.0f, 0.0f, 1.0f});
    private static final float[] BT2020_FULL_RANGE_YUV_TO_RGB_COLOR_TRANSFORM_MATRIX = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.1646f, 1.8814f, 1.4746f, -0.5714f, 0.0f};
    private static final float[] BT2020_LIMITED_RANGE_YUV_TO_RGB_COLOR_TRANSFORM_MATRIX = new float[]{1.1689f, 1.1689f, 1.1689f, 0.0f, -0.1881f, 2.1502f, 1.6853f, -0.653f, 0.0f};
    private static final int GL_FALSE = 0;
    private static final int GL_TRUE = 1;
    private final ImmutableList<GlMatrixTransformation> matrixTransformations;
    private final ImmutableList<RgbMatrix> rgbMatrices;
    private final boolean useHdr;
    private final float[][] transformationMatrixCache;
    private final float[][] rgbMatrixCache;
    private final float[] compositeTransformationMatrixArray;
    private final float[] compositeRgbMatrixArray;
    private final float[] tempResultMatrix;
    private ImmutableList<float[]> visiblePolygon;
    private final GlProgram glProgram;
    private int outputColorTransfer;

    public static DefaultShaderProgram create(Context context, List<GlMatrixTransformation> matrixTransformations, List<RgbMatrix> rgbMatrices, boolean useHdr) throws VideoFrameProcessingException {
        GlProgram glProgram = DefaultShaderProgram.createGlProgram(context, VERTEX_SHADER_TRANSFORMATION_PATH, FRAGMENT_SHADER_TRANSFORMATION_PATH);
        return new DefaultShaderProgram(glProgram, (ImmutableList<GlMatrixTransformation>)ImmutableList.copyOf(matrixTransformations), (ImmutableList<RgbMatrix>)ImmutableList.copyOf(rgbMatrices), 1, useHdr);
    }

    public static DefaultShaderProgram createWithInternalSampler(Context context, List<GlMatrixTransformation> matrixTransformations, List<RgbMatrix> rgbMatrices, ColorInfo inputColorInfo, ColorInfo outputColorInfo, boolean enableColorTransfers, int inputType) throws VideoFrameProcessingException {
        Assertions.checkState((inputColorInfo.colorTransfer != 2 || inputType == 2 ? 1 : 0) != 0);
        boolean isInputTransferHdr = ColorInfo.isTransferHdr((ColorInfo)inputColorInfo);
        String vertexShaderFilePath = isInputTransferHdr ? VERTEX_SHADER_TRANSFORMATION_ES3_PATH : VERTEX_SHADER_TRANSFORMATION_PATH;
        String fragmentShaderFilePath = isInputTransferHdr ? FRAGMENT_SHADER_TRANSFORMATION_HDR_INTERNAL_ES3_PATH : FRAGMENT_SHADER_TRANSFORMATION_SDR_INTERNAL_PATH;
        GlProgram glProgram = DefaultShaderProgram.createGlProgram(context, vertexShaderFilePath, fragmentShaderFilePath);
        glProgram.setIntUniform("uInputColorTransfer", inputColorInfo.colorTransfer);
        return DefaultShaderProgram.createWithSampler(glProgram, matrixTransformations, rgbMatrices, inputColorInfo, outputColorInfo, enableColorTransfers);
    }

    public static DefaultShaderProgram createWithExternalSampler(Context context, List<GlMatrixTransformation> matrixTransformations, List<RgbMatrix> rgbMatrices, ColorInfo inputColorInfo, ColorInfo outputColorInfo, boolean enableColorTransfers) throws VideoFrameProcessingException {
        boolean isInputTransferHdr = ColorInfo.isTransferHdr((ColorInfo)inputColorInfo);
        String vertexShaderFilePath = isInputTransferHdr ? VERTEX_SHADER_TRANSFORMATION_ES3_PATH : VERTEX_SHADER_TRANSFORMATION_PATH;
        String fragmentShaderFilePath = isInputTransferHdr ? FRAGMENT_SHADER_TRANSFORMATION_EXTERNAL_YUV_ES3_PATH : FRAGMENT_SHADER_TRANSFORMATION_SDR_EXTERNAL_PATH;
        GlProgram glProgram = DefaultShaderProgram.createGlProgram(context, vertexShaderFilePath, fragmentShaderFilePath);
        if (isInputTransferHdr) {
            if (!GlUtil.isYuvTargetExtensionSupported()) {
                throw new VideoFrameProcessingException("The EXT_YUV_target extension is required for HDR editing input.");
            }
            glProgram.setFloatsUniform("uYuvToRgbColorTransform", inputColorInfo.colorRange == 1 ? BT2020_FULL_RANGE_YUV_TO_RGB_COLOR_TRANSFORM_MATRIX : BT2020_LIMITED_RANGE_YUV_TO_RGB_COLOR_TRANSFORM_MATRIX);
            glProgram.setIntUniform("uInputColorTransfer", inputColorInfo.colorTransfer);
        }
        return DefaultShaderProgram.createWithSampler(glProgram, matrixTransformations, rgbMatrices, inputColorInfo, outputColorInfo, enableColorTransfers);
    }

    public static DefaultShaderProgram createApplyingOetf(Context context, List<GlMatrixTransformation> matrixTransformations, List<RgbMatrix> rgbMatrices, ColorInfo outputColorInfo, boolean enableColorTransfers) throws VideoFrameProcessingException {
        String fragmentShaderFilePath;
        boolean outputIsHdr = ColorInfo.isTransferHdr((ColorInfo)outputColorInfo);
        String vertexShaderFilePath = outputIsHdr ? VERTEX_SHADER_TRANSFORMATION_ES3_PATH : VERTEX_SHADER_TRANSFORMATION_PATH;
        String string = fragmentShaderFilePath = outputIsHdr ? FRAGMENT_SHADER_OETF_ES3_PATH : FRAGMENT_SHADER_TRANSFORMATION_SDR_OETF_ES2_PATH;
        if (!enableColorTransfers) {
            fragmentShaderFilePath = FRAGMENT_SHADER_TRANSFORMATION_PATH;
        }
        GlProgram glProgram = DefaultShaderProgram.createGlProgram(context, vertexShaderFilePath, fragmentShaderFilePath);
        int outputColorTransfer = outputColorInfo.colorTransfer;
        if (outputIsHdr) {
            Assertions.checkArgument((outputColorTransfer == 7 || outputColorTransfer == 6 ? 1 : 0) != 0);
            Assertions.checkArgument((boolean)enableColorTransfers);
            glProgram.setIntUniform("uOutputColorTransfer", outputColorTransfer);
        } else if (enableColorTransfers) {
            Assertions.checkArgument((outputColorTransfer == 3 || outputColorTransfer == 10 ? 1 : 0) != 0);
            glProgram.setIntUniform("uOutputColorTransfer", outputColorTransfer);
        }
        return new DefaultShaderProgram(glProgram, (ImmutableList<GlMatrixTransformation>)ImmutableList.copyOf(matrixTransformations), (ImmutableList<RgbMatrix>)ImmutableList.copyOf(rgbMatrices), outputColorInfo.colorTransfer, outputIsHdr);
    }

    private static DefaultShaderProgram createWithSampler(GlProgram glProgram, List<GlMatrixTransformation> matrixTransformations, List<RgbMatrix> rgbMatrices, ColorInfo inputColorInfo, ColorInfo outputColorInfo, boolean enableColorTransfers) {
        boolean isInputTransferHdr = ColorInfo.isTransferHdr((ColorInfo)inputColorInfo);
        int outputColorTransfer = outputColorInfo.colorTransfer;
        if (isInputTransferHdr) {
            Assertions.checkArgument((inputColorInfo.colorSpace == 6 ? 1 : 0) != 0);
            Assertions.checkArgument((boolean)enableColorTransfers);
            glProgram.setIntUniform("uApplyHdrToSdrToneMapping", outputColorInfo.colorSpace != 6 ? 1 : 0);
            Assertions.checkArgument((outputColorTransfer != -1 && outputColorTransfer != 3 ? 1 : 0) != 0);
            glProgram.setIntUniform("uOutputColorTransfer", outputColorTransfer);
        } else {
            glProgram.setIntUniform("uEnableColorTransfer", enableColorTransfers ? 1 : 0);
            Assertions.checkArgument((outputColorTransfer == 3 || outputColorTransfer == 1 ? 1 : 0) != 0);
            glProgram.setIntUniform("uOutputColorTransfer", outputColorTransfer);
        }
        return new DefaultShaderProgram(glProgram, (ImmutableList<GlMatrixTransformation>)ImmutableList.copyOf(matrixTransformations), (ImmutableList<RgbMatrix>)ImmutableList.copyOf(rgbMatrices), outputColorInfo.colorTransfer, isInputTransferHdr);
    }

    private DefaultShaderProgram(GlProgram glProgram, ImmutableList<GlMatrixTransformation> matrixTransformations, ImmutableList<RgbMatrix> rgbMatrices, int outputColorTransfer, boolean useHdr) {
        super(useHdr, 1);
        this.glProgram = glProgram;
        this.outputColorTransfer = outputColorTransfer;
        this.matrixTransformations = matrixTransformations;
        this.rgbMatrices = rgbMatrices;
        this.useHdr = useHdr;
        this.transformationMatrixCache = new float[matrixTransformations.size()][16];
        this.rgbMatrixCache = new float[rgbMatrices.size()][16];
        this.compositeTransformationMatrixArray = GlUtil.create4x4IdentityMatrix();
        this.compositeRgbMatrixArray = GlUtil.create4x4IdentityMatrix();
        this.tempResultMatrix = new float[16];
        this.visiblePolygon = NDC_SQUARE;
    }

    private static GlProgram createGlProgram(Context context, String vertexShaderFilePath, String fragmentShaderFilePath) throws VideoFrameProcessingException {
        GlProgram glProgram;
        try {
            glProgram = new GlProgram(context, vertexShaderFilePath, fragmentShaderFilePath);
        }
        catch (GlUtil.GlException | IOException e) {
            throw new VideoFrameProcessingException(e);
        }
        glProgram.setFloatsUniform("uTexTransformationMatrix", GlUtil.create4x4IdentityMatrix());
        return glProgram;
    }

    @Override
    public void setTextureTransformMatrix(float[] textureTransformMatrix) {
        this.glProgram.setFloatsUniform("uTexTransformationMatrix", textureTransformMatrix);
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        return MatrixUtils.configureAndGetOutputSize(inputWidth, inputHeight, this.matrixTransformations);
    }

    @Override
    public void drawFrame(int inputTexId, long presentationTimeUs) throws VideoFrameProcessingException {
        this.updateCompositeRgbMatrixArray(presentationTimeUs);
        this.updateCompositeTransformationMatrixAndVisiblePolygon(presentationTimeUs);
        if (this.visiblePolygon.size() < 3) {
            return;
        }
        try {
            this.glProgram.use();
            this.glProgram.setSamplerTexIdUniform("uTexSampler", inputTexId, 0);
            this.glProgram.setFloatsUniform("uTransformationMatrix", this.compositeTransformationMatrixArray);
            this.glProgram.setFloatsUniform("uRgbMatrix", this.compositeRgbMatrixArray);
            this.glProgram.setBufferAttribute("aFramePosition", GlUtil.createVertexBuffer(this.visiblePolygon), 4);
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)6, (int)0, (int)this.visiblePolygon.size());
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e, presentationTimeUs);
        }
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        super.release();
        try {
            this.glProgram.delete();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }

    public void setOutputColorTransfer(int colorTransfer) {
        Assertions.checkState((this.outputColorTransfer != 1 ? 1 : 0) != 0);
        this.outputColorTransfer = colorTransfer;
        this.glProgram.setIntUniform("uOutputColorTransfer", colorTransfer);
    }

    public int getOutputColorTransfer() {
        return this.outputColorTransfer;
    }

    private void updateCompositeTransformationMatrixAndVisiblePolygon(long presentationTimeUs) {
        float[][] matricesAtPresentationTime = new float[this.matrixTransformations.size()][16];
        for (int i = 0; i < this.matrixTransformations.size(); ++i) {
            matricesAtPresentationTime[i] = ((GlMatrixTransformation)this.matrixTransformations.get(i)).getGlMatrixArray(presentationTimeUs);
        }
        if (!DefaultShaderProgram.updateMatrixCache(this.transformationMatrixCache, matricesAtPresentationTime)) {
            return;
        }
        GlUtil.setToIdentity((float[])this.compositeTransformationMatrixArray);
        this.visiblePolygon = NDC_SQUARE;
        for (float[] transformationMatrix : this.transformationMatrixCache) {
            Matrix.multiplyMM((float[])this.tempResultMatrix, (int)0, (float[])transformationMatrix, (int)0, (float[])this.compositeTransformationMatrixArray, (int)0);
            System.arraycopy(this.tempResultMatrix, 0, this.compositeTransformationMatrixArray, 0, this.tempResultMatrix.length);
            this.visiblePolygon = MatrixUtils.clipConvexPolygonToNdcRange(MatrixUtils.transformPoints(transformationMatrix, this.visiblePolygon));
            if (this.visiblePolygon.size() >= 3) continue;
            return;
        }
        Matrix.invertM((float[])this.tempResultMatrix, (int)0, (float[])this.compositeTransformationMatrixArray, (int)0);
        this.visiblePolygon = MatrixUtils.transformPoints(this.tempResultMatrix, this.visiblePolygon);
    }

    private void updateCompositeRgbMatrixArray(long presentationTimeUs) {
        int i;
        float[][] matricesCurrTimestamp = new float[this.rgbMatrices.size()][16];
        for (i = 0; i < this.rgbMatrices.size(); ++i) {
            matricesCurrTimestamp[i] = ((RgbMatrix)this.rgbMatrices.get(i)).getMatrix(presentationTimeUs, this.useHdr);
        }
        if (!DefaultShaderProgram.updateMatrixCache(this.rgbMatrixCache, matricesCurrTimestamp)) {
            return;
        }
        GlUtil.setToIdentity((float[])this.compositeRgbMatrixArray);
        for (i = 0; i < this.rgbMatrices.size(); ++i) {
            Matrix.multiplyMM((float[])this.tempResultMatrix, (int)0, (float[])((RgbMatrix)this.rgbMatrices.get(i)).getMatrix(presentationTimeUs, this.useHdr), (int)0, (float[])this.compositeRgbMatrixArray, (int)0);
            System.arraycopy(this.tempResultMatrix, 0, this.compositeRgbMatrixArray, 0, this.tempResultMatrix.length);
        }
    }

    private static boolean updateMatrixCache(float[][] cachedMatrices, float[][] newMatrices) {
        boolean matrixChanged = false;
        for (int i = 0; i < cachedMatrices.length; ++i) {
            float[] cachedMatrix = cachedMatrices[i];
            float[] newMatrix = newMatrices[i];
            if (Arrays.equals(cachedMatrix, newMatrix)) continue;
            Assertions.checkState((newMatrix.length == 16 ? 1 : 0) != 0, (Object)"A 4x4 transformation matrix must have 16 elements");
            System.arraycopy(newMatrix, 0, cachedMatrix, 0, newMatrix.length);
            matrixChanged = true;
        }
        return matrixChanged;
    }
}

