/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.LongArrayQueue;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.GlTextureProducer;
import androidx.media3.effect.OverlayMatrixProvider;
import androidx.media3.effect.OverlaySettings;
import androidx.media3.effect.TexturePool;
import androidx.media3.effect.VideoCompositor;
import androidx.media3.effect.VideoCompositorSettings;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class DefaultVideoCompositor
implements VideoCompositor {
    private static final String THREAD_NAME = "Effect:DefaultVideoCompositor:GlThread";
    private static final String TAG = "DefaultVideoCompositor";
    private static final int PRIMARY_INPUT_ID = 0;
    private final VideoCompositor.Listener listener;
    private final GlTextureProducer.Listener textureOutputListener;
    private final GlObjectsProvider glObjectsProvider;
    private final VideoCompositorSettings settings;
    private final CompositorGlProgram compositorGlProgram;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    @GuardedBy(value="this")
    private final List<InputSource> inputSources;
    @GuardedBy(value="this")
    private boolean allInputsEnded;
    private final TexturePool outputTexturePool;
    private final LongArrayQueue outputTextureTimestamps;
    private final LongArrayQueue syncObjects;
    private @MonotonicNonNull ColorInfo configuredColorInfo;
    private @MonotonicNonNull EGLContext eglContext;
    private @MonotonicNonNull EGLDisplay eglDisplay;
    private @MonotonicNonNull EGLSurface placeholderEglSurface;

    public DefaultVideoCompositor(Context context, GlObjectsProvider glObjectsProvider, VideoCompositorSettings settings, @Nullable ExecutorService executorService, VideoCompositor.Listener listener, GlTextureProducer.Listener textureOutputListener, @IntRange(from=1L) int textureOutputCapacity) {
        this.listener = listener;
        this.textureOutputListener = textureOutputListener;
        this.glObjectsProvider = glObjectsProvider;
        this.settings = settings;
        this.compositorGlProgram = new CompositorGlProgram(context);
        this.inputSources = new ArrayList<InputSource>();
        this.outputTexturePool = new TexturePool(false, textureOutputCapacity);
        this.outputTextureTimestamps = new LongArrayQueue(textureOutputCapacity);
        this.syncObjects = new LongArrayQueue(textureOutputCapacity);
        boolean ownsExecutor = executorService == null;
        ExecutorService instanceExecutorService = ownsExecutor ? Util.newSingleThreadExecutor((String)THREAD_NAME) : (ExecutorService)Assertions.checkNotNull((Object)executorService);
        this.videoFrameProcessingTaskExecutor = new VideoFrameProcessingTaskExecutor(instanceExecutorService, ownsExecutor, listener::onError);
        this.videoFrameProcessingTaskExecutor.submit(this::setupGlObjects);
    }

    @Override
    public synchronized int registerInputSource() {
        this.inputSources.add(new InputSource());
        return this.inputSources.size() - 1;
    }

    @Override
    public synchronized void signalEndOfInputSource(int inputId) {
        this.inputSources.get((int)inputId).isInputEnded = true;
        boolean allInputsEnded = true;
        for (int i = 0; i < this.inputSources.size(); ++i) {
            if (this.inputSources.get((int)i).isInputEnded) continue;
            allInputsEnded = false;
            break;
        }
        this.allInputsEnded = allInputsEnded;
        if (this.inputSources.get((int)0).frameInfos.isEmpty()) {
            if (inputId == 0) {
                this.releaseExcessFramesInAllSecondaryStreams();
            }
            if (allInputsEnded) {
                this.listener.onEnded();
                return;
            }
        }
        if (inputId != 0 && this.inputSources.get((int)inputId).frameInfos.size() == 1) {
            this.videoFrameProcessingTaskExecutor.submit(this::maybeComposite);
        }
    }

    @Override
    public synchronized void queueInputTexture(int inputId, GlTextureProducer textureProducer, GlTextureInfo inputTexture, ColorInfo colorInfo, long presentationTimeUs) {
        InputSource inputSource = this.inputSources.get(inputId);
        Assertions.checkState((!inputSource.isInputEnded ? 1 : 0) != 0);
        Assertions.checkStateNotNull((Object)(!ColorInfo.isTransferHdr((ColorInfo)colorInfo) ? 1 : 0), (Object)"HDR input is not supported.");
        if (this.configuredColorInfo == null) {
            this.configuredColorInfo = colorInfo;
        }
        Assertions.checkState((boolean)this.configuredColorInfo.equals((Object)colorInfo), (Object)"Mixing different ColorInfos is not supported.");
        InputFrameInfo inputFrameInfo = new InputFrameInfo(textureProducer, inputTexture, presentationTimeUs, this.settings.getOverlaySettings(inputId, presentationTimeUs));
        inputSource.frameInfos.add(inputFrameInfo);
        if (inputId == 0) {
            this.releaseExcessFramesInAllSecondaryStreams();
        } else {
            this.releaseExcessFramesInSecondaryStream(inputSource);
        }
        this.videoFrameProcessingTaskExecutor.submit(this::maybeComposite);
    }

    @Override
    public synchronized void release() {
        Assertions.checkState((boolean)this.allInputsEnded);
        try {
            this.videoFrameProcessingTaskExecutor.release(this::releaseGlObjects);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void releaseOutputTexture(long presentationTimeUs) {
        this.videoFrameProcessingTaskExecutor.submit(() -> this.releaseOutputTextureInternal(presentationTimeUs));
    }

    private synchronized void releaseExcessFramesInAllSecondaryStreams() {
        for (int i = 0; i < this.inputSources.size(); ++i) {
            if (i == 0) continue;
            this.releaseExcessFramesInSecondaryStream(this.inputSources.get(i));
        }
    }

    private synchronized void releaseExcessFramesInSecondaryStream(InputSource secondaryInputSource) {
        InputSource primaryInputSource = this.inputSources.get(0);
        if (primaryInputSource.frameInfos.isEmpty() && primaryInputSource.isInputEnded) {
            this.releaseFrames(secondaryInputSource, secondaryInputSource.frameInfos.size());
            return;
        }
        InputFrameInfo nextPrimaryFrame = primaryInputSource.frameInfos.peek();
        long nextTimestampToComposite = nextPrimaryFrame != null ? nextPrimaryFrame.presentationTimeUs : -9223372036854775807L;
        int numberOfSecondaryFramesBeforeOrAtNextTargetTimestamp = Iterables.size((Iterable)Iterables.filter(secondaryInputSource.frameInfos, frame -> frame.presentationTimeUs <= nextTimestampToComposite));
        this.releaseFrames(secondaryInputSource, Math.max(numberOfSecondaryFramesBeforeOrAtNextTargetTimestamp - 1, 0));
    }

    private synchronized void releaseFrames(InputSource inputSource, int numberOfFramesToRelease) {
        for (int i = 0; i < numberOfFramesToRelease; ++i) {
            InputFrameInfo frameInfoToRelease = inputSource.frameInfos.remove();
            frameInfoToRelease.textureProducer.releaseOutputTexture(frameInfoToRelease.presentationTimeUs);
        }
    }

    private void setupGlObjects() throws GlUtil.GlException {
        this.eglDisplay = GlUtil.getDefaultEglDisplay();
        this.eglContext = this.glObjectsProvider.createEglContext(this.eglDisplay, 2, GlUtil.EGL_CONFIG_ATTRIBUTES_RGBA_8888);
        this.placeholderEglSurface = this.glObjectsProvider.createFocusedPlaceholderEglSurface(this.eglContext, this.eglDisplay);
    }

    private synchronized void maybeComposite() throws VideoFrameProcessingException, GlUtil.GlException {
        ImmutableList<InputFrameInfo> framesToComposite = this.getFramesToComposite();
        if (framesToComposite.isEmpty()) {
            return;
        }
        InputFrameInfo primaryInputFrame = (InputFrameInfo)framesToComposite.get(0);
        ImmutableList.Builder inputSizes = new ImmutableList.Builder();
        for (int i = 0; i < framesToComposite.size(); ++i) {
            GlTextureInfo texture = ((InputFrameInfo)framesToComposite.get((int)i)).texture;
            inputSizes.add((Object)new Size(texture.width, texture.height));
        }
        Size outputSize = this.settings.getOutputSize((List<Size>)inputSizes.build());
        this.outputTexturePool.ensureConfigured(this.glObjectsProvider, outputSize.getWidth(), outputSize.getHeight());
        GlTextureInfo outputTexture = this.outputTexturePool.useTexture();
        long outputPresentationTimestampUs = primaryInputFrame.presentationTimeUs;
        this.outputTextureTimestamps.add(outputPresentationTimestampUs);
        this.compositorGlProgram.drawFrame((List<InputFrameInfo>)framesToComposite, outputTexture);
        long syncObject = GlUtil.createGlSyncFence();
        this.syncObjects.add(syncObject);
        this.textureOutputListener.onTextureRendered(this, outputTexture, outputPresentationTimestampUs, syncObject);
        InputSource primaryInputSource = this.inputSources.get(0);
        this.releaseFrames(primaryInputSource, 1);
        this.releaseExcessFramesInAllSecondaryStreams();
        if (this.allInputsEnded && primaryInputSource.frameInfos.isEmpty()) {
            this.listener.onEnded();
        }
    }

    private synchronized ImmutableList<InputFrameInfo> getFramesToComposite() {
        if (this.outputTexturePool.freeTextureCount() == 0) {
            return ImmutableList.of();
        }
        for (int inputId = 0; inputId < this.inputSources.size(); ++inputId) {
            if (!this.inputSources.get((int)inputId).frameInfos.isEmpty()) continue;
            return ImmutableList.of();
        }
        ImmutableList.Builder framesToComposite = new ImmutableList.Builder();
        InputFrameInfo primaryFrameToComposite = this.inputSources.get((int)0).frameInfos.element();
        framesToComposite.add((Object)primaryFrameToComposite);
        block1: for (int inputId = 0; inputId < this.inputSources.size(); ++inputId) {
            if (inputId == 0) continue;
            InputSource secondaryInputSource = this.inputSources.get(inputId);
            if (secondaryInputSource.frameInfos.size() == 1 && !secondaryInputSource.isInputEnded) {
                return ImmutableList.of();
            }
            long minTimeDiffFromPrimaryUs = Long.MAX_VALUE;
            InputFrameInfo secondaryFrameToComposite = null;
            Iterator frameInfosIterator = secondaryInputSource.frameInfos.iterator();
            while (frameInfosIterator.hasNext()) {
                InputFrameInfo candidateFrame = (InputFrameInfo)frameInfosIterator.next();
                long candidateTimestampUs = candidateFrame.presentationTimeUs;
                long candidateAbsDistance = Math.abs(candidateTimestampUs - primaryFrameToComposite.presentationTimeUs);
                if (candidateAbsDistance < minTimeDiffFromPrimaryUs) {
                    minTimeDiffFromPrimaryUs = candidateAbsDistance;
                    secondaryFrameToComposite = candidateFrame;
                }
                if (candidateTimestampUs <= primaryFrameToComposite.presentationTimeUs && (frameInfosIterator.hasNext() || !secondaryInputSource.isInputEnded)) continue;
                framesToComposite.add((Object)((InputFrameInfo)Assertions.checkNotNull((Object)secondaryFrameToComposite)));
                continue block1;
            }
        }
        ImmutableList framesToCompositeList = framesToComposite.build();
        if (framesToCompositeList.size() != this.inputSources.size()) {
            return ImmutableList.of();
        }
        return framesToCompositeList;
    }

    private synchronized void releaseOutputTextureInternal(long presentationTimeUs) throws VideoFrameProcessingException, GlUtil.GlException {
        while (this.outputTexturePool.freeTextureCount() < this.outputTexturePool.capacity() && this.outputTextureTimestamps.element() <= presentationTimeUs) {
            this.outputTexturePool.freeTexture();
            this.outputTextureTimestamps.remove();
            GlUtil.deleteSyncObject((long)this.syncObjects.remove());
        }
        this.maybeComposite();
    }

    private void releaseGlObjects() {
        try {
            this.compositorGlProgram.release();
            this.outputTexturePool.deleteAllTextures();
            GlUtil.destroyEglSurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.placeholderEglSurface);
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Error releasing GL resources", (Throwable)e);
        }
        finally {
            try {
                GlUtil.destroyEglContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            }
            catch (GlUtil.GlException e) {
                Log.e((String)TAG, (String)"Error releasing GL context", (Throwable)e);
            }
        }
    }

    private static final class CompositorGlProgram {
        private static final String TAG = "CompositorGlProgram";
        private static final String VERTEX_SHADER_PATH = "shaders/vertex_shader_transformation_es2.glsl";
        private static final String FRAGMENT_SHADER_PATH = "shaders/fragment_shader_alpha_scale_es2.glsl";
        private final Context context;
        private final OverlayMatrixProvider overlayMatrixProvider;
        private @MonotonicNonNull GlProgram glProgram;

        public CompositorGlProgram(Context context) {
            this.context = context;
            this.overlayMatrixProvider = new OverlayMatrixProvider();
        }

        public void drawFrame(List<InputFrameInfo> framesToComposite, GlTextureInfo outputTexture) throws GlUtil.GlException, VideoFrameProcessingException {
            this.ensureConfigured();
            GlUtil.focusFramebufferUsingCurrentContext((int)outputTexture.fboId, (int)outputTexture.width, (int)outputTexture.height);
            this.overlayMatrixProvider.configure(new Size(outputTexture.width, outputTexture.height));
            GlUtil.clearFocusedBuffers();
            GlProgram glProgram = (GlProgram)Assertions.checkNotNull((Object)this.glProgram);
            glProgram.use();
            GLES20.glEnable((int)3042);
            GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlUtil.checkGlError();
            for (int i = framesToComposite.size() - 1; i >= 0; --i) {
                this.blendOntoFocusedTexture(framesToComposite.get(i));
            }
            GLES20.glDisable((int)3042);
            GlUtil.checkGlError();
        }

        public void release() {
            try {
                if (this.glProgram != null) {
                    this.glProgram.delete();
                }
            }
            catch (GlUtil.GlException e) {
                Log.e((String)TAG, (String)"Error releasing GL Program", (Throwable)e);
            }
        }

        private void ensureConfigured() throws VideoFrameProcessingException, GlUtil.GlException {
            if (this.glProgram != null) {
                return;
            }
            try {
                this.glProgram = new GlProgram(this.context, VERTEX_SHADER_PATH, FRAGMENT_SHADER_PATH);
                this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
                this.glProgram.setFloatsUniform("uTexTransformationMatrix", GlUtil.create4x4IdentityMatrix());
            }
            catch (IOException e) {
                throw new VideoFrameProcessingException((Throwable)e);
            }
        }

        private void blendOntoFocusedTexture(InputFrameInfo inputFrameInfo) throws GlUtil.GlException {
            GlProgram glProgram = (GlProgram)Assertions.checkNotNull((Object)this.glProgram);
            GlTextureInfo inputTexture = inputFrameInfo.texture;
            glProgram.setSamplerTexIdUniform("uTexSampler", inputTexture.texId, 0);
            float[] transformationMatrix = this.overlayMatrixProvider.getTransformationMatrix(new Size(inputTexture.width, inputTexture.height), inputFrameInfo.overlaySettings);
            glProgram.setFloatsUniform("uTransformationMatrix", transformationMatrix);
            glProgram.setFloatUniform("uAlphaScale", inputFrameInfo.overlaySettings.alphaScale);
            glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GlUtil.checkGlError();
        }
    }

    private static final class InputSource {
        public final Queue<InputFrameInfo> frameInfos = new ArrayDeque<InputFrameInfo>();
        public boolean isInputEnded;
    }

    private static final class InputFrameInfo {
        public final GlTextureProducer textureProducer;
        public final GlTextureInfo texture;
        public final long presentationTimeUs;
        public final OverlaySettings overlaySettings;

        public InputFrameInfo(GlTextureProducer textureProducer, GlTextureInfo texture, long presentationTimeUs, OverlaySettings overlaySettings) {
            this.textureProducer = textureProducer;
            this.texture = texture;
            this.presentationTimeUs = presentationTimeUs;
            this.overlaySettings = overlaySettings;
        }
    }
}

