/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.BitmapOverlay;
import androidx.media3.effect.OverlaySettings;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public abstract class DrawableOverlay
extends BitmapOverlay {
    private @MonotonicNonNull Bitmap lastBitmap;
    private @MonotonicNonNull Drawable lastDrawable;

    public abstract Drawable getDrawable(long var1);

    @Override
    public Bitmap getBitmap(long presentationTimeUs) {
        Drawable overlayDrawable = this.getDrawable(presentationTimeUs);
        if (!overlayDrawable.equals(this.lastDrawable)) {
            this.lastDrawable = overlayDrawable;
            this.lastBitmap = Bitmap.createBitmap((int)this.lastDrawable.getIntrinsicWidth(), (int)this.lastDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.lastBitmap);
            this.lastDrawable.draw(canvas);
        }
        return (Bitmap)Assertions.checkNotNull((Object)this.lastBitmap);
    }

    public static DrawableOverlay createStaticDrawableOverlay(final Drawable drawable, final OverlaySettings overlaySettings) {
        return new DrawableOverlay(){

            @Override
            public Drawable getDrawable(long presentationTimeUs) {
                return drawable;
            }

            @Override
            public OverlaySettings getOverlaySettings(long presentationTimeUs) {
                return overlaySettings;
            }
        };
    }
}

