/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.annotation.IntRange;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.FrameCacheGlShaderProgram;
import androidx.media3.effect.GlEffect;
import androidx.media3.effect.GlShaderProgram;

@UnstableApi
public final class FrameCache
implements GlEffect {
    public final int capacity;

    public FrameCache(@IntRange(from=1L, to=8L) int capacity) {
        Assertions.checkArgument((capacity > 0 && capacity < 9 ? 1 : 0) != 0);
        this.capacity = capacity;
    }

    @Override
    public GlShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        return new FrameCacheGlShaderProgram(context, this.capacity, useHdr);
    }
}

