/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.annotation.FloatRange;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.GlEffect;
import androidx.media3.effect.HslShaderProgram;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class HslAdjustment
implements GlEffect {
    public final float hueAdjustmentDegrees;
    public final float saturationAdjustment;
    public final float lightnessAdjustment;

    private HslAdjustment(float hueAdjustmentDegrees, float saturationAdjustment, float lightnessAdjustment) {
        this.hueAdjustmentDegrees = hueAdjustmentDegrees;
        this.saturationAdjustment = saturationAdjustment;
        this.lightnessAdjustment = lightnessAdjustment;
    }

    @Override
    public BaseGlShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        return new HslShaderProgram(context, this, useHdr);
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        return this.hueAdjustmentDegrees == 0.0f && this.saturationAdjustment == 0.0f && this.lightnessAdjustment == 0.0f;
    }

    public static final class Builder {
        private float hueAdjustment;
        private float saturationAdjustment;
        private float lightnessAdjustment;

        @CanIgnoreReturnValue
        public Builder adjustHue(float hueAdjustmentDegrees) {
            this.hueAdjustment = hueAdjustmentDegrees % 360.0f;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder adjustSaturation(@FloatRange(from=-100.0, to=100.0) float saturationAdjustment) {
            Assertions.checkArgument((-100.0f <= saturationAdjustment && saturationAdjustment <= 100.0f ? 1 : 0) != 0, (Object)("Can adjust the saturation by only 100 in either direction, but provided " + saturationAdjustment));
            this.saturationAdjustment = saturationAdjustment;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder adjustLightness(@FloatRange(from=-100.0, to=100.0) float lightnessAdjustment) {
            Assertions.checkArgument((-100.0f <= lightnessAdjustment && lightnessAdjustment <= 100.0f ? 1 : 0) != 0, (Object)("Can adjust the lightness by only 100 in either direction, but provided " + lightnessAdjustment));
            this.lightnessAdjustment = lightnessAdjustment;
            return this;
        }

        public HslAdjustment build() {
            return new HslAdjustment(this.hueAdjustment, this.saturationAdjustment, this.lightnessAdjustment);
        }
    }
}

