/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.opengl.Matrix;
import androidx.annotation.FloatRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.RgbMatrix;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;

@UnstableApi
public final class RgbAdjustment
implements RgbMatrix {
    private final float[] rgbMatrix;

    private RgbAdjustment(float[] rgbMatrix) {
        this.rgbMatrix = rgbMatrix;
    }

    @Override
    public float[] getMatrix(long presentationTimeUs, boolean useHdr) {
        return this.rgbMatrix;
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        return Arrays.equals(this.rgbMatrix, GlUtil.create4x4IdentityMatrix());
    }

    public static final class Builder {
        private float redScale = 1.0f;
        private float greenScale = 1.0f;
        private float blueScale = 1.0f;

        @CanIgnoreReturnValue
        public Builder setRedScale(@FloatRange(from=0.0) float redScale) {
            Assertions.checkArgument((0.0f <= redScale ? 1 : 0) != 0, (Object)"Red scale needs to be non-negative.");
            this.redScale = redScale;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setGreenScale(@FloatRange(from=0.0) float greenScale) {
            Assertions.checkArgument((0.0f <= greenScale ? 1 : 0) != 0, (Object)"Green scale needs to be non-negative.");
            this.greenScale = greenScale;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBlueScale(@FloatRange(from=0.0) float blueScale) {
            Assertions.checkArgument((0.0f <= blueScale ? 1 : 0) != 0, (Object)"Blue scale needs to be non-negative.");
            this.blueScale = blueScale;
            return this;
        }

        public RgbAdjustment build() {
            float[] rgbMatrix = GlUtil.create4x4IdentityMatrix();
            Matrix.scaleM((float[])rgbMatrix, (int)0, (float)this.redScale, (float)this.greenScale, (float)this.blueScale);
            return new RgbAdjustment(rgbMatrix);
        }
    }
}

