/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.RgbMatrix;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class RgbFilter
implements RgbMatrix {
    private static final int COLOR_FILTER_GRAYSCALE_INDEX = 1;
    private static final int COLOR_FILTER_INVERTED_INDEX = 2;
    private static final float[] FILTER_MATRIX_GRAYSCALE_SDR = new float[]{0.2126f, 0.2126f, 0.2126f, 0.0f, 0.7152f, 0.7152f, 0.7152f, 0.0f, 0.0722f, 0.0722f, 0.0722f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] FILTER_MATRIX_GRAYSCALE_HDR = new float[]{0.2627f, 0.2627f, 0.2627f, 0.0f, 0.678f, 0.678f, 0.678f, 0.0f, 0.0593f, 0.0593f, 0.0593f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] FILTER_MATRIX_INVERTED = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private final int colorFilter;
    private @MonotonicNonNull Boolean useHdr;

    public static RgbFilter createGrayscaleFilter() {
        return new RgbFilter(1);
    }

    public static RgbFilter createInvertedFilter() {
        return new RgbFilter(2);
    }

    private RgbFilter(int colorFilter) {
        this.colorFilter = colorFilter;
    }

    private void checkForConsistentHdrSetting(boolean useHdr) {
        if (this.useHdr == null) {
            this.useHdr = useHdr;
        } else {
            Assertions.checkState((this.useHdr == useHdr ? 1 : 0) != 0, (Object)"Changing HDR setting is not supported.");
        }
    }

    @Override
    public float[] getMatrix(long presentationTimeUs, boolean useHdr) {
        this.checkForConsistentHdrSetting(useHdr);
        switch (this.colorFilter) {
            case 1: {
                return useHdr ? FILTER_MATRIX_GRAYSCALE_HDR : FILTER_MATRIX_GRAYSCALE_SDR;
            }
            case 2: {
                return FILTER_MATRIX_INVERTED;
            }
        }
        throw new IllegalStateException("Invalid color filter " + this.colorFilter);
    }

    @Override
    public BaseGlShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        this.checkForConsistentHdrSetting(useHdr);
        return RgbMatrix.super.toGlShaderProgram(context, useHdr);
    }
}

