/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.effect.FrameCacheGlShaderProgram;

final class SimpleFrameDroppingShaderProgram
extends FrameCacheGlShaderProgram {
    private final int n;
    private int framesReceived;

    public SimpleFrameDroppingShaderProgram(Context context, boolean useHdr, float inputFrameRate, float targetFrameRate) throws VideoFrameProcessingException {
        super(context, 1, useHdr);
        this.n = Math.round(inputFrameRate / targetFrameRate);
        Assertions.checkArgument((this.n >= 1 ? 1 : 0) != 0, (Object)"The input frame rate should be greater than the target frame rate.");
    }

    @Override
    public void queueInputFrame(GlObjectsProvider glObjectsProvider, GlTextureInfo inputTexture, long presentationTimeUs) {
        if (this.framesReceived % this.n == 0) {
            super.queueInputFrame(glObjectsProvider, inputTexture, presentationTimeUs);
        } else {
            this.getInputListener().onInputFrameProcessed(inputTexture);
            this.getInputListener().onReadyToAcceptInputFrame();
        }
        ++this.framesReceived;
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        super.signalEndOfCurrentInputStream();
        this.framesReceived = 0;
    }

    @Override
    public void flush() {
        super.flush();
        this.framesReceived = 0;
    }
}

