/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLUtils;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.ColorLut;
import androidx.media3.effect.ColorLutShaderProgram;

@UnstableApi
public final class SingleColorLut
implements ColorLut {
    private final Bitmap lut;
    private int lutTextureId;

    public static SingleColorLut createFromCube(int[][][] lutCube) {
        Assertions.checkArgument((lutCube.length > 0 && lutCube[0].length > 0 && lutCube[0][0].length > 0 ? 1 : 0) != 0, (Object)"LUT must have three dimensions.");
        Assertions.checkArgument((lutCube.length == lutCube[0].length && lutCube.length == lutCube[0][0].length ? 1 : 0) != 0, (Object)Util.formatInvariant((String)"All three dimensions of a LUT must match, received %d x %d x %d.", (Object[])new Object[]{lutCube.length, lutCube[0].length, lutCube[0][0].length}));
        return new SingleColorLut(SingleColorLut.transformCubeIntoBitmap(lutCube));
    }

    public static SingleColorLut createFromBitmap(Bitmap lut) {
        Assertions.checkArgument((lut.getWidth() * lut.getWidth() == lut.getHeight() ? 1 : 0) != 0, (Object)Util.formatInvariant((String)"LUT needs to be in a N x N^2 format, received %d x %d.", (Object[])new Object[]{lut.getWidth(), lut.getHeight()}));
        Assertions.checkArgument((lut.getConfig() == Bitmap.Config.ARGB_8888 ? 1 : 0) != 0, (Object)"Color representation needs to be ARGB_8888.");
        return new SingleColorLut(lut);
    }

    private SingleColorLut(Bitmap lut) {
        this.lut = lut;
        this.lutTextureId = -1;
    }

    private static Bitmap transformCubeIntoBitmap(int[][][] cube) {
        int length = cube.length;
        int[] bitmapColorsArray = new int[length * length * length];
        for (int r = 0; r < length; ++r) {
            for (int g = 0; g < length; ++g) {
                for (int b = 0; b < length; ++b) {
                    int color = cube[r][g][b];
                    int planePosition = b + length * (g + length * r);
                    bitmapColorsArray[planePosition] = color;
                }
            }
        }
        return Bitmap.createBitmap((int[])bitmapColorsArray, (int)length, (int)(length * length), (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    @Override
    public int getLutTextureId(long presentationTimeUs) {
        Assertions.checkState((this.lutTextureId != -1 ? 1 : 0) != 0, (Object)"The LUT has not been stored as a texture in OpenGL yet. You must to call #toGlShaderProgram() first.");
        return this.lutTextureId;
    }

    @Override
    public int getLength(long presentationTimeUs) {
        return this.lut.getWidth();
    }

    @Override
    public void release() throws GlUtil.GlException {
        GlUtil.deleteTexture((int)this.lutTextureId);
    }

    @Override
    public BaseGlShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        Assertions.checkState((!useHdr ? 1 : 0) != 0, (Object)"HDR is currently not supported.");
        try {
            this.lutTextureId = SingleColorLut.storeLutAsTexture(this.lut);
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException("Could not store the LUT as a texture.", (Throwable)e);
        }
        return new ColorLutShaderProgram(context, this, useHdr);
    }

    private static int storeLutAsTexture(Bitmap bitmap) throws GlUtil.GlException {
        int lutTextureId = GlUtil.createTexture((int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)false);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        GlUtil.checkGlError();
        return lutTextureId;
    }
}

