/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import androidx.annotation.Nullable;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.OnInputFrameProcessedListener;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.effect.DebugTraceUtil;
import androidx.media3.effect.FrameConsumptionManager;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.TextureManager;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class TexIdTextureManager
implements TextureManager {
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    private final FrameConsumptionManager frameConsumptionManager;
    private @MonotonicNonNull OnInputFrameProcessedListener frameProcessedListener;
    private @MonotonicNonNull FrameInfo inputFrameInfo;

    public TexIdTextureManager(GlObjectsProvider glObjectsProvider, GlShaderProgram shaderProgram, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor) {
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
        this.frameConsumptionManager = new FrameConsumptionManager(glObjectsProvider, shaderProgram, videoFrameProcessingTaskExecutor);
    }

    @Override
    public void onReadyToAcceptInputFrame() {
        this.videoFrameProcessingTaskExecutor.submit(this.frameConsumptionManager::onReadyToAcceptInputFrame);
    }

    @Override
    public void onInputFrameProcessed(GlTextureInfo inputTexture) {
        this.videoFrameProcessingTaskExecutor.submit(() -> ((OnInputFrameProcessedListener)Assertions.checkNotNull((Object)this.frameProcessedListener)).onInputFrameProcessed(inputTexture.texId, GlUtil.createGlSyncFence()));
    }

    @Override
    public void onFlush() {
        this.videoFrameProcessingTaskExecutor.submit(this.frameConsumptionManager::onFlush);
    }

    @Override
    public void queueInputTexture(int inputTexId, long presentationTimeUs) {
        FrameInfo frameInfo = (FrameInfo)Assertions.checkNotNull((Object)this.inputFrameInfo);
        Assertions.checkNotNull((Object)this.frameProcessedListener);
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            GlTextureInfo inputTexture = new GlTextureInfo(inputTexId, -1, -1, frameInfo.width, frameInfo.height);
            this.frameConsumptionManager.queueInputFrame(inputTexture, presentationTimeUs);
            DebugTraceUtil.logEvent("VFP-QueueTexture", presentationTimeUs, frameInfo.width + "x" + frameInfo.height);
        });
    }

    @Override
    public void setOnInputFrameProcessedListener(OnInputFrameProcessedListener listener) {
        this.frameProcessedListener = listener;
    }

    @Override
    public void setInputFrameInfo(FrameInfo inputFrameInfo) {
        this.inputFrameInfo = inputFrameInfo;
    }

    @Override
    public int getPendingFrameCount() {
        return this.frameConsumptionManager.getPendingFrameCount();
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        this.videoFrameProcessingTaskExecutor.submit(() -> {
            this.frameConsumptionManager.signalEndOfCurrentStream();
            DebugTraceUtil.logEvent("TexIdTextureManager-SignalEOS", Long.MIN_VALUE);
        });
    }

    @Override
    public void setOnFlushCompleteListener(@Nullable VideoFrameProcessingTaskExecutor.Task task) {
    }

    @Override
    public void release() throws VideoFrameProcessingException {
    }
}

