/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.GlEffect;
import androidx.media3.effect.ThumbnailStripShaderProgram;
import java.util.ArrayList;
import java.util.List;

@UnstableApi
final class ThumbnailStripEffect
implements GlEffect {
    final int stripWidth;
    final int stripHeight;
    private final List<Long> timestampsMs;
    private int currentThumbnailIndex;

    public ThumbnailStripEffect(int stripWidth, int stripHeight) {
        this.stripWidth = stripWidth;
        this.stripHeight = stripHeight;
        this.timestampsMs = new ArrayList<Long>();
    }

    @Override
    public ThumbnailStripShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        return new ThumbnailStripShaderProgram(context, useHdr, this);
    }

    public void setTimestampsMs(List<Long> timestampsMs) {
        this.timestampsMs.clear();
        this.timestampsMs.addAll(timestampsMs);
        this.currentThumbnailIndex = 0;
    }

    public boolean isDone() {
        return this.currentThumbnailIndex >= this.timestampsMs.size();
    }

    public int getNextThumbnailIndex() {
        return this.currentThumbnailIndex;
    }

    public long getNextTimestampMs() {
        return this.isDone() ? Long.MIN_VALUE : this.timestampsMs.get(this.currentThumbnailIndex);
    }

    public int getNumberOfThumbnails() {
        return this.timestampsMs.size();
    }

    void onThumbnailDrawn() {
        ++this.currentThumbnailIndex;
    }
}

