/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.GLES20;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.Util;
import androidx.media3.effect.BaseGlShaderProgram;
import androidx.media3.effect.ThumbnailStripEffect;
import java.io.IOException;

final class ThumbnailStripShaderProgram
extends BaseGlShaderProgram {
    private static final String VERTEX_SHADER_PATH = "shaders/vertex_shader_thumbnail_strip_es2.glsl";
    private static final String FRAGMENT_SHADER_PATH = "shaders/fragment_shader_copy_es2.glsl";
    private final GlProgram glProgram;
    private final ThumbnailStripEffect thumbnailStripEffect;

    public ThumbnailStripShaderProgram(Context context, boolean useHdr, ThumbnailStripEffect thumbnailStripEffect) throws VideoFrameProcessingException {
        super(useHdr, 1);
        this.thumbnailStripEffect = thumbnailStripEffect;
        try {
            this.glProgram = new GlProgram(context, VERTEX_SHADER_PATH, FRAGMENT_SHADER_PATH);
        }
        catch (GlUtil.GlException | IOException e) {
            throw VideoFrameProcessingException.from((Exception)e);
        }
        this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
    }

    @Override
    public boolean shouldClearTextureBuffer() {
        return false;
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        return new Size(this.thumbnailStripEffect.stripWidth, this.thumbnailStripEffect.stripHeight);
    }

    @Override
    public void drawFrame(int inputTexId, long presentationTimeUs) throws VideoFrameProcessingException {
        long targetPresentationTimeUs = Util.msToUs((long)this.thumbnailStripEffect.getNextTimestampMs());
        if (this.thumbnailStripEffect.isDone() || presentationTimeUs < targetPresentationTimeUs) {
            return;
        }
        try {
            this.glProgram.use();
            this.glProgram.setSamplerTexIdUniform("uTexSampler", inputTexId, 0);
            this.glProgram.setIntUniform("uIndex", this.thumbnailStripEffect.getNextThumbnailIndex());
            this.glProgram.setIntUniform("uCount", this.thumbnailStripEffect.getNumberOfThumbnails());
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            this.thumbnailStripEffect.onThumbnailDrawn();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e, presentationTimeUs);
        }
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        super.release();
        try {
            this.glProgram.delete();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }
}

