/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.annotation.IntRange;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.GlEffect;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.TimestampWrapperShaderProgram;

@UnstableApi
public final class TimestampWrapper
implements GlEffect {
    public final GlEffect glEffect;
    public final long startTimeUs;
    public final long endTimeUs;

    public TimestampWrapper(GlEffect glEffect, @IntRange(from=0L) long startTimeUs, @IntRange(from=0L) long endTimeUs) {
        Assertions.checkArgument((startTimeUs >= 0L && endTimeUs >= 0L ? 1 : 0) != 0, (Object)"startTimeUs and endTimeUs must be non-negative.");
        Assertions.checkArgument((endTimeUs > startTimeUs ? 1 : 0) != 0, (Object)"endTimeUs should be after startTimeUs.");
        this.glEffect = glEffect;
        this.startTimeUs = startTimeUs;
        this.endTimeUs = endTimeUs;
    }

    @Override
    public GlShaderProgram toGlShaderProgram(Context context, boolean useHdr) throws VideoFrameProcessingException {
        return new TimestampWrapperShaderProgram(context, useHdr, this);
    }

    @Override
    public boolean isNoOp(int inputWidth, int inputHeight) {
        return this.glEffect.isNoOp(inputWidth, inputHeight);
    }
}

