/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.GLES20;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.GlProgram;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.effect.SingleFrameGlShaderProgram;
import java.io.IOException;

final class AlphaScaleShaderProgram
extends SingleFrameGlShaderProgram {
    private static final String VERTEX_SHADER_PATH = "shaders/vertex_shader_transformation_es2.glsl";
    private static final String FRAGMENT_SHADER_PATH = "shaders/fragment_shader_alpha_scale_es2.glsl";
    private final GlProgram glProgram;

    public AlphaScaleShaderProgram(Context context, boolean useHdr, float alphaScale) throws VideoFrameProcessingException {
        super(useHdr);
        try {
            this.glProgram = new GlProgram(context, VERTEX_SHADER_PATH, FRAGMENT_SHADER_PATH);
        }
        catch (GlUtil.GlException | IOException e) {
            throw new VideoFrameProcessingException(e);
        }
        this.glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
        float[] identityMatrix = GlUtil.create4x4IdentityMatrix();
        this.glProgram.setFloatsUniform("uTransformationMatrix", identityMatrix);
        this.glProgram.setFloatsUniform("uTexTransformationMatrix", identityMatrix);
        this.glProgram.setFloatUniform("uAlphaScale", alphaScale);
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        return new Size(inputWidth, inputHeight);
    }

    @Override
    public void drawFrame(int inputTexId, long presentationTimeUs) throws VideoFrameProcessingException {
        try {
            this.glProgram.use();
            this.glProgram.setSamplerTexIdUniform("uTexSampler", inputTexId, 0);
            this.glProgram.bindAttributesAndUniforms();
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e, presentationTimeUs);
        }
    }
}

