/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.effect.FrameCacheGlShaderProgram;

final class DefaultFrameDroppingShaderProgram
extends FrameCacheGlShaderProgram {
    private final boolean useHdr;
    private final long targetFrameDeltaUs;
    private long previousPresentationTimeUs;
    private long lastQueuedPresentationTimeUs;
    private int framesReceived;
    @Nullable
    private GlTextureInfo previousTexture;

    public DefaultFrameDroppingShaderProgram(Context context, boolean useHdr, float targetFrameRate) throws VideoFrameProcessingException {
        super(context, 1, useHdr);
        this.useHdr = useHdr;
        this.targetFrameDeltaUs = (long)(1000000.0f / targetFrameRate);
        this.lastQueuedPresentationTimeUs = -9223372036854775807L;
        this.previousPresentationTimeUs = -9223372036854775807L;
    }

    @Override
    public void queueInputFrame(GlObjectsProvider glObjectsProvider, GlTextureInfo inputTexture, long presentationTimeUs) {
        ++this.framesReceived;
        if (this.framesReceived == 1) {
            this.copyTextureToPreviousFrame(glObjectsProvider, inputTexture, presentationTimeUs);
            this.queuePreviousFrame(glObjectsProvider);
            this.getInputListener().onInputFrameProcessed(inputTexture);
            this.getInputListener().onReadyToAcceptInputFrame();
            return;
        }
        if (this.shouldQueuePreviousFrame(presentationTimeUs)) {
            this.queuePreviousFrame(glObjectsProvider);
        }
        this.copyTextureToPreviousFrame(glObjectsProvider, inputTexture, presentationTimeUs);
        this.getInputListener().onInputFrameProcessed(inputTexture);
        if (this.outputTexturePool.freeTextureCount() > 0) {
            this.getInputListener().onReadyToAcceptInputFrame();
        }
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        super.signalEndOfCurrentInputStream();
        this.reset();
    }

    @Override
    public void flush() {
        super.flush();
        this.reset();
    }

    @Override
    public void release() throws VideoFrameProcessingException {
        super.release();
        try {
            if (this.previousTexture != null) {
                this.previousTexture.release();
            }
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }

    private void reset() {
        try {
            if (this.previousTexture != null) {
                this.previousTexture.release();
            }
        }
        catch (GlUtil.GlException e) {
            this.onError((Exception)((Object)e));
        }
        this.lastQueuedPresentationTimeUs = -9223372036854775807L;
        this.previousPresentationTimeUs = -9223372036854775807L;
        this.framesReceived = 0;
    }

    private void copyTextureToPreviousFrame(GlObjectsProvider glObjectsProvider, GlTextureInfo newTexture, long presentationTimeUs) {
        try {
            if (this.previousTexture == null) {
                int texId = GlUtil.createTexture((int)newTexture.width, (int)newTexture.height, (boolean)this.useHdr);
                this.previousTexture = glObjectsProvider.createBuffersForTexture(texId, newTexture.width, newTexture.height);
            }
            GlTextureInfo previousTexture = (GlTextureInfo)Assertions.checkNotNull((Object)this.previousTexture);
            if (previousTexture.height != newTexture.height || previousTexture.width != newTexture.width) {
                previousTexture.release();
                int texId = GlUtil.createTexture((int)newTexture.width, (int)newTexture.height, (boolean)this.useHdr);
                previousTexture = glObjectsProvider.createBuffersForTexture(texId, newTexture.width, newTexture.height);
            }
            GlUtil.focusFramebufferUsingCurrentContext((int)previousTexture.fboId, (int)previousTexture.width, (int)previousTexture.height);
            GlUtil.clearFocusedBuffers();
            this.drawFrame(newTexture.texId, presentationTimeUs);
            this.previousPresentationTimeUs = presentationTimeUs;
            this.previousTexture = previousTexture;
        }
        catch (VideoFrameProcessingException | GlUtil.GlException e) {
            this.onError((Exception)e);
        }
    }

    private boolean shouldQueuePreviousFrame(long currentPresentationTimeUs) {
        if (this.framesReceived == 2) {
            return false;
        }
        long previousFrameTimeDeltaUs = this.previousPresentationTimeUs - this.lastQueuedPresentationTimeUs;
        long currentFrameTimeDeltaUs = currentPresentationTimeUs - this.lastQueuedPresentationTimeUs;
        return Math.abs(previousFrameTimeDeltaUs - this.targetFrameDeltaUs) < Math.abs(currentFrameTimeDeltaUs - this.targetFrameDeltaUs);
    }

    private void queuePreviousFrame(GlObjectsProvider glObjectsProvider) {
        try {
            GlTextureInfo previousTexture = (GlTextureInfo)Assertions.checkNotNull((Object)this.previousTexture);
            Size outputTextureSize = this.configure(previousTexture.width, previousTexture.height);
            this.outputTexturePool.ensureConfigured(glObjectsProvider, outputTextureSize.getWidth(), outputTextureSize.getHeight());
            GlTextureInfo outputTexture = this.outputTexturePool.useTexture();
            GlUtil.focusFramebufferUsingCurrentContext((int)outputTexture.fboId, (int)outputTexture.width, (int)outputTexture.height);
            GlUtil.clearFocusedBuffers();
            this.drawFrame(previousTexture.texId, this.previousPresentationTimeUs);
            this.getOutputListener().onOutputFrameAvailable(outputTexture, this.previousPresentationTimeUs);
            this.lastQueuedPresentationTimeUs = this.previousPresentationTimeUs;
        }
        catch (VideoFrameProcessingException | GlUtil.GlException e) {
            this.onError((Exception)e);
        }
    }
}

