/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DebugViewProvider;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.SurfaceInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.VideoFrameProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.LongArrayQueue;
import androidx.media3.common.util.Size;
import androidx.media3.common.util.Util;
import androidx.media3.effect.DebugTraceUtil;
import androidx.media3.effect.DefaultShaderProgram;
import androidx.media3.effect.GlMatrixTransformation;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.GlTextureProducer;
import androidx.media3.effect.MatrixUtils;
import androidx.media3.effect.Presentation;
import androidx.media3.effect.RgbMatrix;
import androidx.media3.effect.ScaleAndRotateTransformation;
import androidx.media3.effect.TexturePool;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class FinalShaderProgramWrapper
implements GlShaderProgram,
GlTextureProducer {
    private static final String TAG = "FinalShaderWrapper";
    private static final int SURFACE_INPUT_CAPACITY = 1;
    private final Context context;
    private final List<GlMatrixTransformation> matrixTransformations;
    private final List<RgbMatrix> rgbMatrices;
    private final EGLDisplay eglDisplay;
    private final EGLContext eglContext;
    private final DebugViewProvider debugViewProvider;
    private final ColorInfo outputColorInfo;
    private final boolean enableColorTransfers;
    private final boolean renderFramesAutomatically;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    private final Executor videoFrameProcessorListenerExecutor;
    private final VideoFrameProcessor.Listener videoFrameProcessorListener;
    private final Queue<Pair<GlTextureInfo, Long>> availableFrames;
    private final TexturePool outputTexturePool;
    private final LongArrayQueue outputTextureTimestamps;
    private final LongArrayQueue syncObjects;
    @Nullable
    private final GlTextureProducer.Listener textureOutputListener;
    private int inputWidth;
    private int inputHeight;
    private int outputWidth;
    private int outputHeight;
    @Nullable
    private DefaultShaderProgram defaultShaderProgram;
    @Nullable
    private SurfaceViewWrapper debugSurfaceViewWrapper;
    private GlShaderProgram.InputListener inputListener;
    private @MonotonicNonNull Size outputSizeBeforeSurfaceTransformation;
    @Nullable
    private SurfaceView debugSurfaceView;
    @Nullable
    private OnInputStreamProcessedListener onInputStreamProcessedListener;
    private boolean matrixTransformationsChanged;
    @GuardedBy(value="this")
    private boolean outputSurfaceInfoChanged;
    @GuardedBy(value="this")
    @Nullable
    private SurfaceInfo outputSurfaceInfo;
    @GuardedBy(value="this")
    @Nullable
    private EGLSurface outputEglSurface;

    public FinalShaderProgramWrapper(Context context, EGLDisplay eglDisplay, EGLContext eglContext, DebugViewProvider debugViewProvider, ColorInfo outputColorInfo, boolean enableColorTransfers, boolean renderFramesAutomatically, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor, Executor videoFrameProcessorListenerExecutor, VideoFrameProcessor.Listener videoFrameProcessorListener, @Nullable GlTextureProducer.Listener textureOutputListener, int textureOutputCapacity) {
        this.context = context;
        this.matrixTransformations = new ArrayList<GlMatrixTransformation>();
        this.rgbMatrices = new ArrayList<RgbMatrix>();
        this.eglDisplay = eglDisplay;
        this.eglContext = eglContext;
        this.debugViewProvider = debugViewProvider;
        this.outputColorInfo = outputColorInfo;
        this.enableColorTransfers = enableColorTransfers;
        this.renderFramesAutomatically = renderFramesAutomatically;
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
        this.videoFrameProcessorListenerExecutor = videoFrameProcessorListenerExecutor;
        this.videoFrameProcessorListener = videoFrameProcessorListener;
        this.textureOutputListener = textureOutputListener;
        this.inputListener = new GlShaderProgram.InputListener(){};
        this.availableFrames = new ConcurrentLinkedQueue<Pair<GlTextureInfo, Long>>();
        boolean useHighPrecisionColorComponents = ColorInfo.isTransferHdr((ColorInfo)outputColorInfo);
        this.outputTexturePool = new TexturePool(useHighPrecisionColorComponents, textureOutputCapacity);
        this.outputTextureTimestamps = new LongArrayQueue(textureOutputCapacity);
        this.syncObjects = new LongArrayQueue(textureOutputCapacity);
    }

    @Override
    public void setInputListener(GlShaderProgram.InputListener inputListener) {
        this.inputListener = inputListener;
        int inputCapacity = this.textureOutputListener == null ? 1 : this.outputTexturePool.freeTextureCount();
        for (int i = 0; i < inputCapacity; ++i) {
            inputListener.onReadyToAcceptInputFrame();
        }
    }

    @Override
    public void setOutputListener(GlShaderProgram.OutputListener outputListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setErrorListener(Executor executor, GlShaderProgram.ErrorListener errorListener) {
        throw new UnsupportedOperationException();
    }

    public void setOnInputStreamProcessedListener(@Nullable OnInputStreamProcessedListener onInputStreamProcessedListener) {
        this.onInputStreamProcessedListener = onInputStreamProcessedListener;
    }

    @Override
    public void signalEndOfCurrentInputStream() {
        ((OnInputStreamProcessedListener)Assertions.checkNotNull((Object)this.onInputStreamProcessedListener)).onInputStreamProcessed();
    }

    @Override
    public void queueInputFrame(GlObjectsProvider glObjectsProvider, GlTextureInfo inputTexture, long presentationTimeUs) {
        this.videoFrameProcessorListenerExecutor.execute(() -> this.videoFrameProcessorListener.onOutputFrameAvailableForRendering(presentationTimeUs));
        if (this.textureOutputListener == null) {
            if (this.renderFramesAutomatically) {
                this.renderFrame(glObjectsProvider, inputTexture, presentationTimeUs, presentationTimeUs * 1000L);
            } else {
                this.availableFrames.add((Pair<GlTextureInfo, Long>)Pair.create((Object)inputTexture, (Object)presentationTimeUs));
            }
            this.inputListener.onReadyToAcceptInputFrame();
        } else {
            Assertions.checkState((this.outputTexturePool.freeTextureCount() > 0 ? 1 : 0) != 0);
            this.renderFrame(glObjectsProvider, inputTexture, presentationTimeUs, presentationTimeUs * 1000L);
        }
    }

    @Override
    public void releaseOutputFrame(GlTextureInfo outputTexture) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseOutputTexture(long presentationTimeUs) {
        this.videoFrameProcessingTaskExecutor.submit(() -> this.releaseOutputTextureInternal(presentationTimeUs));
    }

    private void releaseOutputTextureInternal(long presentationTimeUs) throws GlUtil.GlException {
        Assertions.checkState((this.textureOutputListener != null ? 1 : 0) != 0);
        while (this.outputTexturePool.freeTextureCount() < this.outputTexturePool.capacity() && this.outputTextureTimestamps.element() <= presentationTimeUs) {
            this.outputTexturePool.freeTexture();
            this.outputTextureTimestamps.remove();
            GlUtil.deleteSyncObject((long)this.syncObjects.remove());
            this.inputListener.onReadyToAcceptInputFrame();
        }
    }

    public void setMatrixTransformations(List<GlMatrixTransformation> matrixTransformations, List<RgbMatrix> rgbMatrices) {
        this.matrixTransformations.clear();
        this.matrixTransformations.addAll(matrixTransformations);
        this.rgbMatrices.clear();
        this.rgbMatrices.addAll(rgbMatrices);
        this.matrixTransformationsChanged = true;
    }

    @Override
    public void flush() {
        this.availableFrames.clear();
        if (this.defaultShaderProgram != null) {
            this.defaultShaderProgram.flush();
        }
        this.inputListener.onFlush();
        if (this.textureOutputListener == null) {
            this.inputListener.onReadyToAcceptInputFrame();
        }
    }

    @Override
    public synchronized void release() throws VideoFrameProcessingException {
        if (this.defaultShaderProgram != null) {
            this.defaultShaderProgram.release();
        }
        try {
            this.outputTexturePool.deleteAllTextures();
            GlUtil.destroyEglSurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.outputEglSurface);
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            throw new VideoFrameProcessingException((Throwable)e);
        }
    }

    public void renderOutputFrame(GlObjectsProvider glObjectsProvider, long renderTimeNs) {
        if (this.textureOutputListener != null) {
            return;
        }
        Assertions.checkState((!this.renderFramesAutomatically ? 1 : 0) != 0);
        Pair<GlTextureInfo, Long> oldestAvailableFrame = this.availableFrames.remove();
        this.renderFrame(glObjectsProvider, (GlTextureInfo)oldestAvailableFrame.first, (Long)oldestAvailableFrame.second, renderTimeNs);
    }

    public synchronized void setOutputSurfaceInfo(@Nullable SurfaceInfo outputSurfaceInfo) {
        if (this.textureOutputListener != null) {
            return;
        }
        if (Util.areEqual((Object)this.outputSurfaceInfo, (Object)outputSurfaceInfo)) {
            return;
        }
        if (outputSurfaceInfo != null && this.outputSurfaceInfo != null && !this.outputSurfaceInfo.surface.equals(outputSurfaceInfo.surface)) {
            try {
                GlUtil.destroyEglSurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.outputEglSurface);
            }
            catch (GlUtil.GlException e) {
                this.videoFrameProcessorListenerExecutor.execute(() -> this.videoFrameProcessorListener.onError(VideoFrameProcessingException.from((Exception)((Object)e))));
            }
            this.outputEglSurface = null;
        }
        this.outputSurfaceInfoChanged = this.outputSurfaceInfo == null || outputSurfaceInfo == null || this.outputSurfaceInfo.width != outputSurfaceInfo.width || this.outputSurfaceInfo.height != outputSurfaceInfo.height || this.outputSurfaceInfo.orientationDegrees != outputSurfaceInfo.orientationDegrees;
        this.outputSurfaceInfo = outputSurfaceInfo;
    }

    private synchronized void renderFrame(GlObjectsProvider glObjectsProvider, GlTextureInfo inputTexture, long presentationTimeUs, long renderTimeNs) {
        try {
            if (renderTimeNs == -2L || !this.ensureConfigured(glObjectsProvider, inputTexture.width, inputTexture.height)) {
                this.inputListener.onInputFrameProcessed(inputTexture);
                return;
            }
            if (this.outputSurfaceInfo != null) {
                this.renderFrameToOutputSurface(inputTexture, presentationTimeUs, renderTimeNs);
            } else if (this.textureOutputListener != null) {
                this.renderFrameToOutputTexture(inputTexture, presentationTimeUs);
            }
        }
        catch (VideoFrameProcessingException | GlUtil.GlException e) {
            this.videoFrameProcessorListenerExecutor.execute(() -> this.lambda$renderFrame$3((Exception)e, presentationTimeUs));
        }
        if (this.debugSurfaceViewWrapper != null && this.defaultShaderProgram != null) {
            this.renderFrameToDebugSurface(glObjectsProvider, inputTexture, presentationTimeUs);
        }
        this.inputListener.onInputFrameProcessed(inputTexture);
    }

    private synchronized void renderFrameToOutputSurface(GlTextureInfo inputTexture, long presentationTimeUs, long renderTimeNs) throws VideoFrameProcessingException, GlUtil.GlException {
        EGLSurface outputEglSurface = (EGLSurface)Assertions.checkNotNull((Object)this.outputEglSurface);
        SurfaceInfo outputSurfaceInfo = (SurfaceInfo)Assertions.checkNotNull((Object)this.outputSurfaceInfo);
        DefaultShaderProgram defaultShaderProgram = (DefaultShaderProgram)Assertions.checkNotNull((Object)this.defaultShaderProgram);
        GlUtil.focusEglSurface((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext, (EGLSurface)outputEglSurface, (int)outputSurfaceInfo.width, (int)outputSurfaceInfo.height);
        GlUtil.clearFocusedBuffers();
        defaultShaderProgram.drawFrame(inputTexture.texId, presentationTimeUs);
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)outputEglSurface, (long)(renderTimeNs == -1L ? System.nanoTime() : renderTimeNs));
        EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)outputEglSurface);
        DebugTraceUtil.logEvent("VFP-RenderedToOutputSurface", presentationTimeUs);
    }

    private void renderFrameToOutputTexture(GlTextureInfo inputTexture, long presentationTimeUs) throws GlUtil.GlException, VideoFrameProcessingException {
        GlTextureInfo outputTexture = this.outputTexturePool.useTexture();
        this.outputTextureTimestamps.add(presentationTimeUs);
        GlUtil.focusFramebufferUsingCurrentContext((int)outputTexture.fboId, (int)outputTexture.width, (int)outputTexture.height);
        GlUtil.clearFocusedBuffers();
        ((DefaultShaderProgram)Assertions.checkNotNull((Object)this.defaultShaderProgram)).drawFrame(inputTexture.texId, presentationTimeUs);
        long syncObject = GlUtil.createGlSyncFence();
        this.syncObjects.add(syncObject);
        ((GlTextureProducer.Listener)Assertions.checkNotNull((Object)this.textureOutputListener)).onTextureRendered(this, outputTexture, presentationTimeUs, syncObject);
    }

    private synchronized boolean ensureConfigured(GlObjectsProvider glObjectsProvider, int inputWidth, int inputHeight) throws VideoFrameProcessingException, GlUtil.GlException {
        SurfaceView debugSurfaceView;
        boolean inputSizeChanged;
        boolean bl = inputSizeChanged = this.inputWidth != inputWidth || this.inputHeight != inputHeight || this.outputSizeBeforeSurfaceTransformation == null;
        if (inputSizeChanged) {
            this.inputWidth = inputWidth;
            this.inputHeight = inputHeight;
            Size outputSizeBeforeSurfaceTransformation = MatrixUtils.configureAndGetOutputSize(inputWidth, inputHeight, this.matrixTransformations);
            if (!Util.areEqual((Object)this.outputSizeBeforeSurfaceTransformation, (Object)outputSizeBeforeSurfaceTransformation)) {
                this.outputSizeBeforeSurfaceTransformation = outputSizeBeforeSurfaceTransformation;
                this.videoFrameProcessorListenerExecutor.execute(() -> this.videoFrameProcessorListener.onOutputSizeChanged(outputSizeBeforeSurfaceTransformation.getWidth(), outputSizeBeforeSurfaceTransformation.getHeight()));
            }
        }
        Assertions.checkNotNull((Object)this.outputSizeBeforeSurfaceTransformation);
        if (this.outputSurfaceInfo == null) {
            GlUtil.destroyEglSurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.outputEglSurface);
            this.outputEglSurface = null;
        }
        if (this.outputSurfaceInfo == null && this.textureOutputListener == null) {
            if (this.defaultShaderProgram != null) {
                this.defaultShaderProgram.release();
                this.defaultShaderProgram = null;
            }
            return false;
        }
        this.outputWidth = this.outputSurfaceInfo == null ? this.outputSizeBeforeSurfaceTransformation.getWidth() : this.outputSurfaceInfo.width;
        int n = this.outputHeight = this.outputSurfaceInfo == null ? this.outputSizeBeforeSurfaceTransformation.getHeight() : this.outputSurfaceInfo.height;
        if (this.outputSurfaceInfo != null && this.outputEglSurface == null) {
            this.outputEglSurface = glObjectsProvider.createEglSurface(this.eglDisplay, (Object)this.outputSurfaceInfo.surface, this.outputColorInfo.colorTransfer, this.renderFramesAutomatically);
        }
        if (this.textureOutputListener != null) {
            this.outputTexturePool.ensureConfigured(glObjectsProvider, this.outputWidth, this.outputHeight);
        }
        if ((debugSurfaceView = this.debugViewProvider.getDebugPreviewSurfaceView(this.outputWidth, this.outputHeight)) != null && !Util.areEqual((Object)this.debugSurfaceView, (Object)debugSurfaceView)) {
            this.debugSurfaceViewWrapper = new SurfaceViewWrapper(this.eglDisplay, this.eglContext, debugSurfaceView, this.outputColorInfo.colorTransfer);
        }
        this.debugSurfaceView = debugSurfaceView;
        if (this.defaultShaderProgram != null && (this.outputSurfaceInfoChanged || inputSizeChanged || this.matrixTransformationsChanged)) {
            this.defaultShaderProgram.release();
            this.defaultShaderProgram = null;
            this.outputSurfaceInfoChanged = false;
            this.matrixTransformationsChanged = false;
        }
        if (this.defaultShaderProgram == null) {
            this.defaultShaderProgram = this.createDefaultShaderProgram(this.outputSurfaceInfo == null ? 0 : this.outputSurfaceInfo.orientationDegrees, this.outputWidth, this.outputHeight);
            this.outputSurfaceInfoChanged = false;
        }
        return true;
    }

    private synchronized DefaultShaderProgram createDefaultShaderProgram(int outputOrientationDegrees, int outputWidth, int outputHeight) throws VideoFrameProcessingException {
        ImmutableList.Builder matrixTransformationListBuilder = new ImmutableList.Builder().addAll(this.matrixTransformations);
        if (outputOrientationDegrees != 0) {
            matrixTransformationListBuilder.add((Object)new ScaleAndRotateTransformation.Builder().setRotationDegrees(outputOrientationDegrees).build());
        }
        matrixTransformationListBuilder.add((Object)Presentation.createForWidthAndHeight(outputWidth, outputHeight, 0));
        ImmutableList expandedMatrixTransformations = matrixTransformationListBuilder.build();
        DefaultShaderProgram defaultShaderProgram = DefaultShaderProgram.createApplyingOetf(this.context, (List<GlMatrixTransformation>)expandedMatrixTransformations, this.rgbMatrices, this.outputColorInfo, this.enableColorTransfers);
        Size outputSize = defaultShaderProgram.configure(this.inputWidth, this.inputHeight);
        if (this.outputSurfaceInfo != null) {
            SurfaceInfo outputSurfaceInfo = (SurfaceInfo)Assertions.checkNotNull((Object)this.outputSurfaceInfo);
            Assertions.checkState((outputSize.getWidth() == outputSurfaceInfo.width ? 1 : 0) != 0);
            Assertions.checkState((outputSize.getHeight() == outputSurfaceInfo.height ? 1 : 0) != 0);
        }
        return defaultShaderProgram;
    }

    private void renderFrameToDebugSurface(GlObjectsProvider glObjectsProvider, GlTextureInfo inputTexture, long presentationTimeUs) {
        DefaultShaderProgram defaultShaderProgram = (DefaultShaderProgram)Assertions.checkNotNull((Object)this.defaultShaderProgram);
        SurfaceViewWrapper debugSurfaceViewWrapper = (SurfaceViewWrapper)Assertions.checkNotNull((Object)this.debugSurfaceViewWrapper);
        try {
            ((SurfaceViewWrapper)Assertions.checkNotNull((Object)debugSurfaceViewWrapper)).maybeRenderToSurfaceView(() -> {
                GlUtil.clearFocusedBuffers();
                if (this.enableColorTransfers) {
                    int configuredColorTransfer = defaultShaderProgram.getOutputColorTransfer();
                    defaultShaderProgram.setOutputColorTransfer(debugSurfaceViewWrapper.outputColorTransfer);
                    defaultShaderProgram.drawFrame(inputTexture.texId, presentationTimeUs);
                    defaultShaderProgram.setOutputColorTransfer(configuredColorTransfer);
                } else {
                    defaultShaderProgram.drawFrame(inputTexture.texId, presentationTimeUs);
                }
            }, glObjectsProvider);
        }
        catch (VideoFrameProcessingException | GlUtil.GlException e) {
            Log.d((String)TAG, (String)"Error rendering to debug preview", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$renderFrame$3(Exception e, long presentationTimeUs) {
        this.videoFrameProcessorListener.onError(VideoFrameProcessingException.from((Exception)e, (long)presentationTimeUs));
    }

    static interface OnInputStreamProcessedListener {
        public void onInputStreamProcessed();
    }

    private static final class SurfaceViewWrapper
    implements SurfaceHolder.Callback {
        public final int outputColorTransfer;
        private final EGLDisplay eglDisplay;
        private final EGLContext eglContext;
        @GuardedBy(value="this")
        @Nullable
        private Surface surface;
        @GuardedBy(value="this")
        @Nullable
        private EGLSurface eglSurface;
        private int width;
        private int height;

        public SurfaceViewWrapper(EGLDisplay eglDisplay, EGLContext eglContext, SurfaceView surfaceView, int outputColorTransfer) {
            this.eglDisplay = eglDisplay;
            this.eglContext = eglContext;
            this.outputColorTransfer = outputColorTransfer == 7 ? 6 : outputColorTransfer;
            surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
            this.surface = surfaceView.getHolder().getSurface();
            this.width = surfaceView.getWidth();
            this.height = surfaceView.getHeight();
        }

        public void surfaceCreated(SurfaceHolder holder) {
        }

        public synchronized void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            this.width = width;
            this.height = height;
            Surface newSurface = holder.getSurface();
            if (this.surface == null || !this.surface.equals(newSurface)) {
                this.surface = newSurface;
                this.eglSurface = null;
            }
        }

        public synchronized void surfaceDestroyed(SurfaceHolder holder) {
            this.surface = null;
            this.eglSurface = null;
            this.width = -1;
            this.height = -1;
        }

        public synchronized void maybeRenderToSurfaceView(VideoFrameProcessingTaskExecutor.Task renderingTask, GlObjectsProvider glObjectsProvider) throws GlUtil.GlException, VideoFrameProcessingException {
            if (this.surface == null) {
                return;
            }
            if (this.eglSurface == null) {
                this.eglSurface = glObjectsProvider.createEglSurface(this.eglDisplay, (Object)this.surface, this.outputColorTransfer, false);
            }
            EGLSurface eglSurface = this.eglSurface;
            GlUtil.focusEglSurface((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext, (EGLSurface)eglSurface, (int)this.width, (int)this.height);
            renderingTask.run();
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)eglSurface);
            GLES20.glFinish();
        }
    }
}

