/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.effect.GlShaderProgram;
import androidx.media3.effect.VideoFrameProcessingTaskExecutor;
import java.util.ArrayDeque;
import java.util.Queue;

final class FrameConsumptionManager
implements GlShaderProgram.InputListener {
    private final GlObjectsProvider glObjectsProvider;
    private final GlShaderProgram consumingGlShaderProgram;
    private final VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor;
    @GuardedBy(value="this")
    private final Queue<Pair<GlTextureInfo, Long>> availableFrames;
    @GuardedBy(value="this")
    private int consumingGlShaderProgramInputCapacity;

    public FrameConsumptionManager(GlObjectsProvider glObjectsProvider, GlShaderProgram consumingGlShaderProgram, VideoFrameProcessingTaskExecutor videoFrameProcessingTaskExecutor) {
        this.glObjectsProvider = glObjectsProvider;
        this.consumingGlShaderProgram = consumingGlShaderProgram;
        this.videoFrameProcessingTaskExecutor = videoFrameProcessingTaskExecutor;
        this.availableFrames = new ArrayDeque<Pair<GlTextureInfo, Long>>();
    }

    @Override
    public synchronized void onReadyToAcceptInputFrame() {
        Pair<GlTextureInfo, Long> pendingFrame = this.availableFrames.poll();
        if (pendingFrame == null) {
            ++this.consumingGlShaderProgramInputCapacity;
            return;
        }
        this.videoFrameProcessingTaskExecutor.submit(() -> this.consumingGlShaderProgram.queueInputFrame(this.glObjectsProvider, (GlTextureInfo)pendingFrame.first, (Long)pendingFrame.second));
        Pair<GlTextureInfo, Long> nextPendingFrame = this.availableFrames.peek();
        if (nextPendingFrame != null && (Long)nextPendingFrame.second == Long.MIN_VALUE) {
            this.videoFrameProcessingTaskExecutor.submit(this.consumingGlShaderProgram::signalEndOfCurrentInputStream);
            this.availableFrames.remove();
        }
    }

    @Override
    public synchronized void onFlush() {
        this.consumingGlShaderProgramInputCapacity = 0;
        this.availableFrames.clear();
    }

    public synchronized void queueInputFrame(GlTextureInfo inputTexture, long presentationTimeUs) {
        if (this.consumingGlShaderProgramInputCapacity > 0) {
            this.videoFrameProcessingTaskExecutor.submit(() -> this.consumingGlShaderProgram.queueInputFrame(this.glObjectsProvider, inputTexture, presentationTimeUs));
            --this.consumingGlShaderProgramInputCapacity;
        } else {
            this.availableFrames.add((Pair<GlTextureInfo, Long>)Pair.create((Object)inputTexture, (Object)presentationTimeUs));
        }
    }

    public synchronized void signalEndOfCurrentStream() {
        if (!this.availableFrames.isEmpty()) {
            this.availableFrames.add((Pair<GlTextureInfo, Long>)Pair.create((Object)GlTextureInfo.UNSET, (Object)Long.MIN_VALUE));
        } else {
            this.videoFrameProcessingTaskExecutor.submit(this.consumingGlShaderProgram::signalEndOfCurrentInputStream);
        }
    }

    public synchronized int getPendingFrameCount() {
        return this.availableFrames.size();
    }
}

