/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.content.Context;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DebugViewProvider;
import androidx.media3.common.Effect;
import androidx.media3.common.FrameInfo;
import androidx.media3.common.GlObjectsProvider;
import androidx.media3.common.GlTextureInfo;
import androidx.media3.common.SurfaceInfo;
import androidx.media3.common.VideoFrameProcessingException;
import androidx.media3.common.VideoFrameProcessor;
import androidx.media3.common.VideoGraph;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.effect.DebugTraceUtil;
import androidx.media3.effect.DefaultGlObjectsProvider;
import androidx.media3.effect.DefaultVideoCompositor;
import androidx.media3.effect.DefaultVideoFrameProcessor;
import androidx.media3.effect.GlTextureProducer;
import androidx.media3.effect.VideoCompositor;
import androidx.media3.effect.VideoCompositorSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public abstract class MultipleInputVideoGraph
implements VideoGraph {
    private static final String SHARED_EXECUTOR_NAME = "Transformer:MultipleInputVideoGraph:Thread";
    private static final long RELEASE_WAIT_TIME_MS = 1000L;
    private static final int PRE_COMPOSITOR_TEXTURE_OUTPUT_CAPACITY = 2;
    private static final int COMPOSITOR_TEXTURE_OUTPUT_CAPACITY = 1;
    private final Context context;
    private final ColorInfo inputColorInfo;
    private final ColorInfo outputColorInfo;
    private final GlObjectsProvider glObjectsProvider;
    private final DebugViewProvider debugViewProvider;
    private final VideoGraph.Listener listener;
    private final Executor listenerExecutor;
    private final VideoCompositorSettings videoCompositorSettings;
    private final List<Effect> compositionEffects;
    private final List<VideoFrameProcessor> preProcessors;
    private final ExecutorService sharedExecutorService;
    private final DefaultVideoFrameProcessor.Factory videoFrameProcessorFactory;
    private final Queue<CompositorOutputTextureInfo> compositorOutputTextures;
    private final SparseArray<CompositorOutputTextureRelease> compositorOutputTextureReleases;
    private final long initialTimestampOffsetUs;
    @Nullable
    private VideoFrameProcessor compositionVideoFrameProcessor;
    @Nullable
    private VideoCompositor videoCompositor;
    private boolean compositionVideoFrameProcessorInputStreamRegistered;
    private boolean compositionVideoFrameProcessorInputStreamRegistrationCompleted;
    private boolean compositorEnded;
    private boolean released;
    private long lastRenderedPresentationTimeUs;
    private volatile boolean hasProducedFrameWithTimestampZero;

    protected MultipleInputVideoGraph(Context context, ColorInfo inputColorInfo, ColorInfo outputColorInfo, DebugViewProvider debugViewProvider, VideoGraph.Listener listener, Executor listenerExecutor, VideoCompositorSettings videoCompositorSettings, List<Effect> compositionEffects, long initialTimestampOffsetUs) {
        this.context = context;
        this.inputColorInfo = inputColorInfo;
        this.outputColorInfo = outputColorInfo;
        this.debugViewProvider = debugViewProvider;
        this.listener = listener;
        this.listenerExecutor = listenerExecutor;
        this.videoCompositorSettings = videoCompositorSettings;
        this.compositionEffects = new ArrayList<Effect>(compositionEffects);
        this.initialTimestampOffsetUs = initialTimestampOffsetUs;
        this.lastRenderedPresentationTimeUs = -9223372036854775807L;
        this.preProcessors = new ArrayList<VideoFrameProcessor>();
        this.sharedExecutorService = Util.newSingleThreadScheduledExecutor((String)SHARED_EXECUTOR_NAME);
        this.glObjectsProvider = new SingleContextGlObjectsProvider();
        this.videoFrameProcessorFactory = new DefaultVideoFrameProcessor.Factory.Builder().setGlObjectsProvider(this.glObjectsProvider).setExecutorService(this.sharedExecutorService).build();
        this.compositorOutputTextures = new ArrayDeque<CompositorOutputTextureInfo>();
        this.compositorOutputTextureReleases = new SparseArray();
    }

    public void initialize() throws VideoFrameProcessingException {
        Assertions.checkState((this.preProcessors.isEmpty() && this.videoCompositor == null && this.compositionVideoFrameProcessor == null && !this.released ? 1 : 0) != 0);
        this.compositionVideoFrameProcessor = this.videoFrameProcessorFactory.create(this.context, this.debugViewProvider, this.outputColorInfo, this.outputColorInfo, true, MoreExecutors.directExecutor(), new VideoFrameProcessor.Listener(){

            public void onInputStreamRegistered(int inputType, List<Effect> effects, FrameInfo frameInfo) {
                MultipleInputVideoGraph.this.compositionVideoFrameProcessorInputStreamRegistrationCompleted = true;
                MultipleInputVideoGraph.this.queueCompositionOutputInternal();
            }

            public void onOutputSizeChanged(int width, int height) {
                MultipleInputVideoGraph.this.listenerExecutor.execute(() -> MultipleInputVideoGraph.this.listener.onOutputSizeChanged(width, height));
            }

            public void onOutputFrameAvailableForRendering(long presentationTimeUs) {
                if (presentationTimeUs == 0L) {
                    MultipleInputVideoGraph.this.hasProducedFrameWithTimestampZero = true;
                }
                MultipleInputVideoGraph.this.lastRenderedPresentationTimeUs = presentationTimeUs;
            }

            public void onError(VideoFrameProcessingException exception) {
                MultipleInputVideoGraph.this.handleVideoFrameProcessingException((Exception)((Object)exception));
            }

            public void onEnded() {
                MultipleInputVideoGraph.this.listenerExecutor.execute(() -> MultipleInputVideoGraph.this.listener.onEnded(MultipleInputVideoGraph.this.lastRenderedPresentationTimeUs));
            }
        });
        this.compositionVideoFrameProcessor.setOnInputFrameProcessedListener(this::onCompositionVideoFrameProcessorInputFrameProcessed);
        this.videoCompositor = new DefaultVideoCompositor(this.context, this.glObjectsProvider, this.videoCompositorSettings, this.sharedExecutorService, new VideoCompositor.Listener(){

            @Override
            public void onError(VideoFrameProcessingException exception) {
                MultipleInputVideoGraph.this.handleVideoFrameProcessingException((Exception)((Object)exception));
            }

            @Override
            public void onEnded() {
                MultipleInputVideoGraph.this.onVideoCompositorEnded();
            }
        }, this::processCompositorOutputTexture, 1);
    }

    public int registerInput() throws VideoFrameProcessingException {
        Assertions.checkStateNotNull((Object)this.videoCompositor);
        final int videoCompositorInputId = this.videoCompositor.registerInputSource();
        DefaultVideoFrameProcessor preProcessor = this.videoFrameProcessorFactory.buildUpon().setTextureOutput((textureProducer, texture, presentationTimeUs, syncObject) -> this.queuePreProcessingOutputToCompositor(videoCompositorInputId, textureProducer, texture, presentationTimeUs), 2).build().create(this.context, DebugViewProvider.NONE, this.inputColorInfo, this.outputColorInfo, true, this.listenerExecutor, new VideoFrameProcessor.Listener(){

            public void onInputStreamRegistered(int inputType, List<Effect> effects, FrameInfo frameInfo) {
            }

            public void onOutputSizeChanged(int width, int height) {
            }

            public void onOutputFrameAvailableForRendering(long presentationTimeUs) {
            }

            public void onError(VideoFrameProcessingException exception) {
                MultipleInputVideoGraph.this.handleVideoFrameProcessingException((Exception)((Object)exception));
            }

            public void onEnded() {
                MultipleInputVideoGraph.this.onPreProcessingVideoFrameProcessorEnded(videoCompositorInputId);
            }
        });
        this.preProcessors.add(preProcessor);
        return videoCompositorInputId;
    }

    public VideoFrameProcessor getProcessor(int inputId) {
        Assertions.checkState((inputId < this.preProcessors.size() ? 1 : 0) != 0);
        return this.preProcessors.get(inputId);
    }

    public void setOutputSurfaceInfo(@Nullable SurfaceInfo outputSurfaceInfo) {
        ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.compositionVideoFrameProcessor)).setOutputSurfaceInfo(outputSurfaceInfo);
    }

    public boolean hasProducedFrameWithTimestampZero() {
        return this.hasProducedFrameWithTimestampZero;
    }

    public void release() {
        if (this.released) {
            return;
        }
        for (int i = 0; i < this.preProcessors.size(); ++i) {
            this.preProcessors.get(i).release();
        }
        this.preProcessors.clear();
        if (this.videoCompositor != null) {
            this.videoCompositor.release();
            this.videoCompositor = null;
        }
        if (this.compositionVideoFrameProcessor != null) {
            this.compositionVideoFrameProcessor.release();
            this.compositionVideoFrameProcessor = null;
        }
        this.sharedExecutorService.shutdown();
        try {
            this.sharedExecutorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.listenerExecutor.execute(() -> this.listener.onError(VideoFrameProcessingException.from((Exception)e)));
        }
        this.released = true;
    }

    protected ColorInfo getInputColorInfo() {
        return this.inputColorInfo;
    }

    protected long getInitialTimestampOffsetUs() {
        return this.initialTimestampOffsetUs;
    }

    private void queuePreProcessingOutputToCompositor(int videoCompositorInputId, GlTextureProducer textureProducer, GlTextureInfo texture, long presentationTimeUs) {
        DebugTraceUtil.logEvent("VFP-OutputTextureRendered", presentationTimeUs);
        ((VideoCompositor)Assertions.checkNotNull((Object)this.videoCompositor)).queueInputTexture(videoCompositorInputId, textureProducer, texture, this.outputColorInfo, presentationTimeUs);
    }

    private void processCompositorOutputTexture(GlTextureProducer textureProducer, GlTextureInfo outputTexture, long presentationTimeUs, long syncObject) {
        Assertions.checkStateNotNull((Object)this.compositionVideoFrameProcessor);
        Assertions.checkState((!this.compositorEnded ? 1 : 0) != 0);
        DebugTraceUtil.logEvent("COMP-OutputTextureRendered", presentationTimeUs);
        this.compositorOutputTextures.add(new CompositorOutputTextureInfo(outputTexture, presentationTimeUs));
        this.compositorOutputTextureReleases.put(outputTexture.texId, (Object)new CompositorOutputTextureRelease(textureProducer, presentationTimeUs));
        if (!this.compositionVideoFrameProcessorInputStreamRegistered) {
            ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.compositionVideoFrameProcessor)).registerInputStream(3, this.compositionEffects, new FrameInfo.Builder(outputTexture.width, outputTexture.height).build());
            this.compositionVideoFrameProcessorInputStreamRegistered = true;
            return;
        }
        this.queueCompositionOutputInternal();
    }

    private void onCompositionVideoFrameProcessorInputFrameProcessed(int textureId, long syncObject) {
        Assertions.checkState((boolean)Util.contains(this.compositorOutputTextureReleases, (int)textureId));
        ((CompositorOutputTextureRelease)this.compositorOutputTextureReleases.get(textureId)).release();
        this.compositorOutputTextureReleases.remove(textureId);
        this.queueCompositionOutputInternal();
    }

    private void onPreProcessingVideoFrameProcessorEnded(int videoCompositorInputId) {
        ((VideoCompositor)Assertions.checkNotNull((Object)this.videoCompositor)).signalEndOfInputSource(videoCompositorInputId);
    }

    private void onVideoCompositorEnded() {
        this.compositorEnded = true;
        if (this.compositorOutputTextures.isEmpty()) {
            ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.compositionVideoFrameProcessor)).signalEndOfInput();
        } else {
            this.queueCompositionOutputInternal();
        }
    }

    private void queueCompositionOutputInternal() {
        Assertions.checkStateNotNull((Object)this.compositionVideoFrameProcessor);
        if (!this.compositionVideoFrameProcessorInputStreamRegistrationCompleted) {
            return;
        }
        CompositorOutputTextureInfo outputTexture = this.compositorOutputTextures.peek();
        if (outputTexture == null) {
            return;
        }
        Assertions.checkState((boolean)((VideoFrameProcessor)Assertions.checkNotNull((Object)this.compositionVideoFrameProcessor)).queueInputTexture(outputTexture.glTextureInfo.texId, outputTexture.presentationTimeUs));
        this.compositorOutputTextures.remove();
        if (this.compositorEnded && this.compositorOutputTextures.isEmpty()) {
            ((VideoFrameProcessor)Assertions.checkNotNull((Object)this.compositionVideoFrameProcessor)).signalEndOfInput();
        }
    }

    private void handleVideoFrameProcessingException(Exception e) {
        this.listenerExecutor.execute(() -> this.listener.onError(e instanceof VideoFrameProcessingException ? (VideoFrameProcessingException)((Object)((Object)e)) : VideoFrameProcessingException.from((Exception)e)));
    }

    private static final class SingleContextGlObjectsProvider
    implements GlObjectsProvider {
        private final GlObjectsProvider glObjectsProvider = new DefaultGlObjectsProvider();
        private @MonotonicNonNull EGLContext singleEglContext;

        public EGLContext createEglContext(EGLDisplay eglDisplay, int openGlVersion, int[] configAttributes) throws GlUtil.GlException {
            if (this.singleEglContext == null) {
                this.singleEglContext = this.glObjectsProvider.createEglContext(eglDisplay, openGlVersion, configAttributes);
            }
            return this.singleEglContext;
        }

        public EGLSurface createEglSurface(EGLDisplay eglDisplay, Object surface, int colorTransfer, boolean isEncoderInputSurface) throws GlUtil.GlException {
            return this.glObjectsProvider.createEglSurface(eglDisplay, surface, colorTransfer, isEncoderInputSurface);
        }

        public EGLSurface createFocusedPlaceholderEglSurface(EGLContext eglContext, EGLDisplay eglDisplay) throws GlUtil.GlException {
            return this.glObjectsProvider.createFocusedPlaceholderEglSurface(eglContext, eglDisplay);
        }

        public GlTextureInfo createBuffersForTexture(int texId, int width, int height) throws GlUtil.GlException {
            return this.glObjectsProvider.createBuffersForTexture(texId, width, height);
        }
    }

    private static final class CompositorOutputTextureInfo {
        public final GlTextureInfo glTextureInfo;
        public final long presentationTimeUs;

        private CompositorOutputTextureInfo(GlTextureInfo glTextureInfo, long presentationTimeUs) {
            this.glTextureInfo = glTextureInfo;
            this.presentationTimeUs = presentationTimeUs;
        }
    }

    private static final class CompositorOutputTextureRelease {
        private final GlTextureProducer textureProducer;
        private final long presentationTimeUs;

        public CompositorOutputTextureRelease(GlTextureProducer textureProducer, long presentationTimeUs) {
            this.textureProducer = textureProducer;
            this.presentationTimeUs = presentationTimeUs;
        }

        public void release() {
            this.textureProducer.releaseOutputTexture(this.presentationTimeUs);
        }
    }
}

