/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.opengl.Matrix;
import android.util.Pair;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.Size;
import androidx.media3.effect.OverlaySettings;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class OverlayMatrixProvider {
    protected static final int MATRIX_OFFSET = 0;
    private final float[] backgroundFrameAnchorMatrix;
    private final float[] aspectRatioMatrix = GlUtil.create4x4IdentityMatrix();
    private final float[] scaleMatrix;
    private final float[] scaleMatrixInv;
    private final float[] overlayFrameAnchorMatrix;
    private final float[] rotateMatrix;
    private final float[] overlayAspectRatioMatrix;
    private final float[] overlayAspectRatioMatrixInv;
    private final float[] transformationMatrix;
    private @MonotonicNonNull Size backgroundSize;

    public OverlayMatrixProvider() {
        this.backgroundFrameAnchorMatrix = GlUtil.create4x4IdentityMatrix();
        this.overlayFrameAnchorMatrix = GlUtil.create4x4IdentityMatrix();
        this.rotateMatrix = GlUtil.create4x4IdentityMatrix();
        this.scaleMatrix = GlUtil.create4x4IdentityMatrix();
        this.scaleMatrixInv = GlUtil.create4x4IdentityMatrix();
        this.overlayAspectRatioMatrix = GlUtil.create4x4IdentityMatrix();
        this.overlayAspectRatioMatrixInv = GlUtil.create4x4IdentityMatrix();
        this.transformationMatrix = GlUtil.create4x4IdentityMatrix();
    }

    public void configure(Size backgroundSize) {
        this.backgroundSize = backgroundSize;
    }

    public float[] getTransformationMatrix(Size overlaySize, OverlaySettings overlaySettings) {
        this.reset();
        Pair<Float, Float> backgroundFrameAnchor = overlaySettings.backgroundFrameAnchor;
        Matrix.translateM((float[])this.backgroundFrameAnchorMatrix, (int)0, (float)((Float)backgroundFrameAnchor.first).floatValue(), (float)((Float)backgroundFrameAnchor.second).floatValue(), (float)0.0f);
        Assertions.checkStateNotNull((Object)this.backgroundSize);
        Matrix.scaleM((float[])this.aspectRatioMatrix, (int)0, (float)((float)overlaySize.getWidth() / (float)this.backgroundSize.getWidth()), (float)((float)overlaySize.getHeight() / (float)this.backgroundSize.getHeight()), (float)1.0f);
        Pair<Float, Float> scale = overlaySettings.scale;
        Matrix.scaleM((float[])this.scaleMatrix, (int)0, (float)((Float)scale.first).floatValue(), (float)((Float)scale.second).floatValue(), (float)1.0f);
        Matrix.invertM((float[])this.scaleMatrixInv, (int)0, (float[])this.scaleMatrix, (int)0);
        Pair<Float, Float> overlayFrameAnchor = overlaySettings.overlayFrameAnchor;
        Matrix.translateM((float[])this.overlayFrameAnchorMatrix, (int)0, (float)(-1.0f * ((Float)overlayFrameAnchor.first).floatValue()), (float)(-1.0f * ((Float)overlayFrameAnchor.second).floatValue()), (float)0.0f);
        Matrix.rotateM((float[])this.rotateMatrix, (int)0, (float)overlaySettings.rotationDegrees, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])this.overlayAspectRatioMatrix, (int)0, (float)((float)overlaySize.getHeight() / (float)overlaySize.getWidth()), (float)1.0f, (float)1.0f);
        Matrix.invertM((float[])this.overlayAspectRatioMatrixInv, (int)0, (float[])this.overlayAspectRatioMatrix, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.backgroundFrameAnchorMatrix, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.aspectRatioMatrix, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.scaleMatrix, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.overlayFrameAnchorMatrix, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.scaleMatrixInv, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.overlayAspectRatioMatrix, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.rotateMatrix, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.overlayAspectRatioMatrixInv, (int)0);
        Matrix.multiplyMM((float[])this.transformationMatrix, (int)0, (float[])this.transformationMatrix, (int)0, (float[])this.scaleMatrix, (int)0);
        return this.transformationMatrix;
    }

    private void reset() {
        GlUtil.setToIdentity((float[])this.aspectRatioMatrix);
        GlUtil.setToIdentity((float[])this.backgroundFrameAnchorMatrix);
        GlUtil.setToIdentity((float[])this.overlayFrameAnchorMatrix);
        GlUtil.setToIdentity((float[])this.scaleMatrix);
        GlUtil.setToIdentity((float[])this.scaleMatrixInv);
        GlUtil.setToIdentity((float[])this.rotateMatrix);
        GlUtil.setToIdentity((float[])this.overlayAspectRatioMatrix);
        GlUtil.setToIdentity((float[])this.overlayAspectRatioMatrixInv);
        GlUtil.setToIdentity((float[])this.transformationMatrix);
    }
}

