/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.effect;

import android.util.Pair;
import androidx.annotation.FloatRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class OverlaySettings {
    public final boolean useHdr;
    public final float alphaScale;
    public final Pair<Float, Float> backgroundFrameAnchor;
    public final Pair<Float, Float> overlayFrameAnchor;
    public final Pair<Float, Float> scale;
    public final float rotationDegrees;

    private OverlaySettings(boolean useHdr, float alphaScale, Pair<Float, Float> backgroundFrameAnchor, Pair<Float, Float> overlayFrameAnchor, Pair<Float, Float> scale, float rotationDegrees) {
        this.useHdr = useHdr;
        this.alphaScale = alphaScale;
        this.backgroundFrameAnchor = backgroundFrameAnchor;
        this.overlayFrameAnchor = overlayFrameAnchor;
        this.scale = scale;
        this.rotationDegrees = rotationDegrees;
    }

    Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        private boolean useHdr;
        private float alphaScale;
        private Pair<Float, Float> backgroundFrameAnchor;
        private Pair<Float, Float> overlayFrameAnchor;
        private Pair<Float, Float> scale;
        private float rotationDegrees;

        public Builder() {
            this.alphaScale = 1.0f;
            this.backgroundFrameAnchor = Pair.create((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            this.overlayFrameAnchor = Pair.create((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            this.scale = Pair.create((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
            this.rotationDegrees = 0.0f;
        }

        private Builder(OverlaySettings overlaySettings) {
            this.useHdr = overlaySettings.useHdr;
            this.alphaScale = overlaySettings.alphaScale;
            this.backgroundFrameAnchor = overlaySettings.backgroundFrameAnchor;
            this.overlayFrameAnchor = overlaySettings.overlayFrameAnchor;
            this.scale = overlaySettings.scale;
            this.rotationDegrees = overlaySettings.rotationDegrees;
        }

        @CanIgnoreReturnValue
        public Builder setUsesHdr(boolean useHdr) {
            this.useHdr = useHdr;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAlphaScale(@FloatRange(from=0.0) float alphaScale) {
            Assertions.checkArgument((0.0f <= alphaScale ? 1 : 0) != 0, (Object)"alphaScale needs to be greater than or equal to zero.");
            this.alphaScale = alphaScale;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBackgroundFrameAnchor(@FloatRange(from=-1.0, to=1.0) float x, @FloatRange(from=-1.0, to=1.0) float y) {
            Assertions.checkArgument((-1.0f <= x && x <= 1.0f ? 1 : 0) != 0);
            Assertions.checkArgument((-1.0f <= y && y <= 1.0f ? 1 : 0) != 0);
            this.backgroundFrameAnchor = Pair.create((Object)Float.valueOf(x), (Object)Float.valueOf(y));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOverlayFrameAnchor(@FloatRange(from=-1.0, to=1.0) float x, @FloatRange(from=-1.0, to=1.0) float y) {
            Assertions.checkArgument((-1.0f <= x && x <= 1.0f ? 1 : 0) != 0);
            Assertions.checkArgument((-1.0f <= y && y <= 1.0f ? 1 : 0) != 0);
            this.overlayFrameAnchor = Pair.create((Object)Float.valueOf(x), (Object)Float.valueOf(y));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScale(float x, float y) {
            this.scale = Pair.create((Object)Float.valueOf(x), (Object)Float.valueOf(y));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRotationDegrees(float rotationDegree) {
            this.rotationDegrees = rotationDegree;
            return this;
        }

        public OverlaySettings build() {
            return new OverlaySettings(this.useHdr, this.alphaScale, this.backgroundFrameAnchor, this.overlayFrameAnchor, this.scale, this.rotationDegrees);
        }
    }
}

